/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.plane.corelib.client.obj.OBJModelOptions;
import de.maxhenkel.plane.corelib.math.Rotation;
import de.maxhenkel.plane.entity.EntityCargoPlane;
import de.maxhenkel.plane.entity.render.AbstractPlaneModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class CargoPlaneModel
extends AbstractPlaneModel<EntityCargoPlane> {
    private static final List<OBJModelInstance<EntityCargoPlane>> MODELS = Arrays.asList(new OBJModelInstance<EntityCargoPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/wheel.obj")), new OBJModelOptions<EntityCargoPlane>(new ResourceLocation("plane", "textures/entity/wheel.png"), new Vector3d(-1.125, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityCargoPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/wheel.obj")), new OBJModelOptions<EntityCargoPlane>(new ResourceLocation("plane", "textures/entity/wheel.png"), new Vector3d(1.125, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityCargoPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/propeller.obj")), new OBJModelOptions<EntityCargoPlane>(new ResourceLocation("textures/block/spruce_planks.png"), new Vector3d(0.0, 1.0, -1.84375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-plane.getPropellerRotation(partialTicks)));
    })));
    private static final List<OBJModelInstance<EntityCargoPlane>> OAK_MODEL = CargoPlaneModel.getPlaneModel(new ResourceLocation("textures/block/oak_planks.png"));
    private static final List<OBJModelInstance<EntityCargoPlane>> DARK_OAK_MODEL = CargoPlaneModel.getPlaneModel(new ResourceLocation("textures/block/dark_oak_planks.png"));
    private static final List<OBJModelInstance<EntityCargoPlane>> BIRCH_MODEL = CargoPlaneModel.getPlaneModel(new ResourceLocation("textures/block/birch_planks.png"));
    private static final List<OBJModelInstance<EntityCargoPlane>> JUNGLE_MODEL = CargoPlaneModel.getPlaneModel(new ResourceLocation("textures/block/jungle_planks.png"));
    private static final List<OBJModelInstance<EntityCargoPlane>> ACACIA_MODEL = CargoPlaneModel.getPlaneModel(new ResourceLocation("textures/block/acacia_planks.png"));
    private static final List<OBJModelInstance<EntityCargoPlane>> SPRUCE_MODEL = CargoPlaneModel.getPlaneModel(new ResourceLocation("textures/block/spruce_planks.png"));
    private static final List<OBJModelInstance<EntityCargoPlane>> WARPED_MODEL = CargoPlaneModel.getPlaneModel(new ResourceLocation("textures/block/warped_planks.png"));
    private static final List<OBJModelInstance<EntityCargoPlane>> CRIMSON_MODEL = CargoPlaneModel.getPlaneModel(new ResourceLocation("textures/block/crimson_planks.png"));

    public CargoPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Override
    protected void translateName(EntityCargoPlane plane, PoseStack matrixStack, boolean left) {
        if (left) {
            matrixStack.m_85837_(1.000625, -1.25, -1.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        } else {
            matrixStack.m_85837_(-1.000625, -1.25, -1.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        }
    }

    @Override
    public List<OBJModelInstance<EntityCargoPlane>> getModels(EntityCargoPlane entity) {
        return CargoPlaneModel.getModelFromType(entity);
    }

    private static List<OBJModelInstance<EntityCargoPlane>> getModelFromType(EntityCargoPlane plane) {
        switch (plane.getPlaneType()) {
            default: {
                return OAK_MODEL;
            }
            case DARK_OAK: {
                return DARK_OAK_MODEL;
            }
            case SPRUCE: {
                return SPRUCE_MODEL;
            }
            case JUNGLE: {
                return JUNGLE_MODEL;
            }
            case BIRCH: {
                return BIRCH_MODEL;
            }
            case ACACIA: {
                return ACACIA_MODEL;
            }
            case WARPED: {
                return WARPED_MODEL;
            }
            case CRIMSON: 
        }
        return CRIMSON_MODEL;
    }

    private static List<OBJModelInstance<EntityCargoPlane>> getPlaneModel(ResourceLocation texture) {
        ArrayList<OBJModelInstance<EntityCargoPlane>> models = new ArrayList<OBJModelInstance<EntityCargoPlane>>(MODELS);
        models.add(new OBJModelInstance<EntityCargoPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/cargo_plane.obj")), new OBJModelOptions<EntityCargoPlane>(texture, new Vector3d(0.0, 0.5, 0.0), new Rotation(180.0f, Vector3f.f_122225_), (plane, matrixStack, partialTicks) -> {})));
        return models;
    }
}

