/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityBushPlane
extends EntityPlaneSoundBase {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(EntityBushPlane.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityBushPlane(Level world) {
        this(Main.BUSH_PLANE_ENTITY_TYPE, world);
    }

    public EntityBushPlane(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Type", this.getPlaneType().getTypeName());
    }

    @Override
    public float getPlayerScaleFactor() {
        return 0.8f;
    }

    @Override
    protected boolean isStalling(Vec3 motionVector) {
        return motionVector.m_82542_(1.0, 0.0, 1.0).m_82553_() < -motionVector.f_82480_;
    }

    @Override
    public void openGUI(Player player, boolean outside) {
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPlaneType(Type.fromTypeName(compound.m_128461_("Type")));
    }

    @Override
    public ResourceLocation getLootTable() {
        return new ResourceLocation("plane", "entities/bush_plane_" + this.getPlaneType().getTypeName());
    }

    @Override
    public float getMaxFuelUsage() {
        return 15.0f;
    }

    @Override
    public int getMaxFuel() {
        return 6000;
    }

    @Override
    public double getFallSpeed() {
        return 0.08;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    @Override
    public Vec3[] getPlayerOffsets() {
        return new Vec3[]{new Vec3(0.0, 0.0, 0.5)};
    }

    public Type getPlaneType() {
        return Type.values()[(Integer)this.f_19804_.m_135370_(TYPE)];
    }

    public void setPlaneType(Type type) {
        this.f_19804_.m_135381_(TYPE, (Object)type.ordinal());
    }

    public static enum Type {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        WARPED("warped"),
        CRIMSON("crimson");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getTypeName() {
            return this.name;
        }

        public static Type fromTypeName(String name) {
            for (Type type : Type.values()) {
                if (!type.getTypeName().equals(name)) continue;
                return type;
            }
            return OAK;
        }
    }
}

