/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.integration.jei.CarRecipeBuilder;
import de.maxhenkel.car.integration.jei.CarRecipeCategory;
import de.maxhenkel.car.integration.jei.PainterRecipe;
import de.maxhenkel.car.integration.jei.PainterRecipeCategory;
import de.maxhenkel.car.integration.jei.PainterRecipeCategoryYellow;
import de.maxhenkel.car.items.ModItems;
import java.util.Arrays;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final RecipeType<CarRecipe> CATEGORY_CAR_WORKSHOP = RecipeType.create((String)"car", (String)"car_workshop", CarRecipe.class);
    public static final RecipeType<PainterRecipe> CATEGORY_PAINTER = RecipeType.create((String)"car", (String)"painter", PainterRecipe.class);
    public static final RecipeType<PainterRecipe> CATEGORY_PAINTER_YELLOW = RecipeType.create((String)"car", (String)"painter_yellow", PainterRecipe.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModItems.PAINTER), new RecipeType[]{CATEGORY_PAINTER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.PAINTER_YELLOW), new RecipeType[]{CATEGORY_PAINTER_YELLOW});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CAR_WORKSHOP), new RecipeType[]{CATEGORY_CAR_WORKSHOP});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CATEGORY_PAINTER, Arrays.stream(ModBlocks.PAINTS).map(paint -> new PainterRecipe(ModItems.PAINTER, (BlockPaint)paint)).toList());
        registration.addRecipes(CATEGORY_PAINTER_YELLOW, Arrays.stream(ModBlocks.YELLOW_PAINTS).map(paint -> new PainterRecipe(ModItems.PAINTER_YELLOW, (BlockPaint)paint)).toList());
        registration.addRecipes(CATEGORY_CAR_WORKSHOP, CarRecipeBuilder.getAllRecipes());
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.PAINTER), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.painter_white")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.PAINTER_YELLOW), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.painter_yellow")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.CANISTER), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.canister")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.REPAIR_KIT), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.repair_kit")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.CRANK), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.crank")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.DYNAMO), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.dynamo")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.GAS_STATION), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.fuel_station")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.GAS_STATION), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.fuel_station_admin")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.TANK), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.tank")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.FLUID_EXTRACTOR), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.fluid_extractor")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.BATTERY), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.battery")});
        registration.addIngredientInfo(Arrays.stream(ModItems.CONTAINERS).map(ItemStack::new).collect(Collectors.toList()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.container")});
        registration.addIngredientInfo(Arrays.stream(ModItems.TANK_CONTAINERS).map(ItemStack::new).collect(Collectors.toList()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.tank_container")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.LICENSE_PLATE), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.license_plate")});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("car", "car");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PainterRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PainterRecipeCategoryYellow(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CarRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

