/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.gui.ContainerGasStation;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GuiGasStation
extends ScreenBase<ContainerGasStation> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_gas_station.png");
    private TileEntityGasStation gasStation;
    private Inventory playerInventory;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    protected Button buttonStart;
    protected Button buttonStop;

    public GuiGasStation(ContainerGasStation gasStation, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, gasStation, playerInventory, title);
        this.gasStation = gasStation.getGasStation();
        this.playerInventory = playerInventory;
        this.f_97726_ = 176;
        this.f_97727_ = 217;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttonStart = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 20, this.f_97736_ + 100, 40, 20, (Component)new TranslatableComponent("button.car.start"), button -> {
            this.gasStation.setFueling(true);
            this.gasStation.sendStartFuelPacket(true);
        }));
        this.buttonStop = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + this.f_97726_ - 40 - 7, this.f_97736_ + 100, 40, 20, (Component)new TranslatableComponent("button.car.stop"), button -> {
            this.gasStation.setFueling(false);
            this.gasStation.sendStartFuelPacket(false);
        }));
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.buttonStart.f_93623_ = !this.gasStation.isFueling();
        this.buttonStop.f_93623_ = this.gasStation.isFueling();
        GuiGasStation.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)new TranslatableComponent("gui.gas_station").getString(), (int)(this.f_96543_ / 2), (int)(this.f_97736_ + 5), (int)TITLE_COLOR);
        IFluidHandler fluidHandler = this.gasStation.getFluidHandlerInFront();
        if (fluidHandler instanceof Entity) {
            this.drawCarName(matrixStack, (Entity)fluidHandler);
        }
        this.drawCarFuel(matrixStack, fluidHandler);
        this.drawRefueled(matrixStack);
        this.drawBuffer(matrixStack);
        this.f_96547_.m_92877_(matrixStack, this.playerInventory.m_5446_().m_7532_(), (float)(this.f_97735_ + 8), (float)(this.f_97736_ + this.f_97727_ - 93), FONT_COLOR);
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        ItemStack stack = this.gasStation.getTradingInventory().m_8020_(0);
        if (stack.m_41619_()) {
            return;
        }
        if (mouseX >= this.f_97735_ + 18 && mouseX <= this.f_97735_ + 33 && mouseY >= this.f_97736_ + 99 && mouseY <= this.f_97736_ + 114) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(new TranslatableComponent("tooltip.trade", new Object[]{stack.m_41613_(), stack.m_41786_(), this.gasStation.getTradeAmount()}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    private void drawCarName(PoseStack matrixStack, Entity entity) {
        String name = entity instanceof EntityGenericCar ? ((EntityGenericCar)entity).getShortName().getString() : entity.m_5446_().getString();
        this.f_96547_.m_92877_(matrixStack, new TranslatableComponent("gas_station.car_info", new Object[]{new TextComponent(name).m_130940_(ChatFormatting.WHITE)}).m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 20), FONT_COLOR);
    }

    private void drawCarFuel(PoseStack matrixStack, IFluidHandler handler) {
        if (handler == null) {
            this.f_96547_.m_92877_(matrixStack, new TranslatableComponent("gas_station.no_car").m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 30), FONT_COLOR);
            return;
        }
        if (handler.getTanks() <= 0) {
            this.f_96547_.m_92877_(matrixStack, new TranslatableComponent("gas_station.fuel_empty").m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 30), FONT_COLOR);
            return;
        }
        FluidStack tank = handler.getFluidInTank(0);
        TranslatableComponent fuelText = new TranslatableComponent("gas_station.car_fuel_amount", new Object[]{new TextComponent(String.valueOf(tank.getAmount())).m_130940_(ChatFormatting.WHITE), new TextComponent(String.valueOf(handler.getTankCapacity(0))).m_130940_(ChatFormatting.WHITE)});
        this.f_96547_.m_92877_(matrixStack, fuelText.m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 30), FONT_COLOR);
        if (!tank.isEmpty()) {
            this.f_96547_.m_92877_(matrixStack, new TranslatableComponent("gas_station.car_fuel_type", new Object[]{new TextComponent(tank.getDisplayName().getString()).m_130940_(ChatFormatting.WHITE)}).m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 40), FONT_COLOR);
        }
    }

    private void drawRefueled(PoseStack matrixStack) {
        this.f_96547_.m_92877_(matrixStack, new TranslatableComponent("gas_station.refueled", new Object[]{new TextComponent(String.valueOf(this.gasStation.getFuelCounter())).m_130940_(ChatFormatting.WHITE)}).m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 60), FONT_COLOR);
    }

    private void drawBuffer(PoseStack matrixStack) {
        FluidStack stack = this.gasStation.getStorage();
        if (stack.isEmpty()) {
            this.f_96547_.m_92877_(matrixStack, new TranslatableComponent("gas_station.fuel_empty").m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 70), FONT_COLOR);
            return;
        }
        int amount = this.gasStation.getFuelAmount();
        TranslatableComponent amountText = new TranslatableComponent("gas_station.fuel_buffer_amount", new Object[]{new TextComponent(String.valueOf(amount)).m_130940_(ChatFormatting.WHITE), new TextComponent(String.valueOf(this.gasStation.maxStorageAmount)).m_130940_(ChatFormatting.WHITE)});
        this.f_96547_.m_92877_(matrixStack, amountText.m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 70), FONT_COLOR);
        TranslatableComponent bufferText = new TranslatableComponent("gas_station.fuel_buffer_type", new Object[]{new TextComponent(stack.getDisplayName().getString()).m_130940_(ChatFormatting.WHITE)});
        this.f_96547_.m_92877_(matrixStack, bufferText.m_7532_(), (float)(this.f_97735_ + 63), (float)(this.f_97736_ + 80), FONT_COLOR);
    }

    public boolean m_7043_() {
        return false;
    }
}

