/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public class PlayerEvents {
    private Minecraft minecraft = Minecraft.m_91087_();
    private EntityVehicleBase lastVehicle = null;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side.equals((Object)LogicalSide.SERVER)) {
            return;
        }
        if (!evt.player.equals((Object)this.getPlayer())) {
            return;
        }
        EntityVehicleBase vehicle = this.getRidingVehicle();
        if (vehicle != null && this.lastVehicle == null) {
            if (vehicle.doesEnterThirdPerson()) {
                this.setThirdPerson(true);
            }
        } else if (vehicle == null && this.lastVehicle != null && this.lastVehicle.doesEnterThirdPerson()) {
            this.setThirdPerson(false);
        }
        this.lastVehicle = vehicle;
    }

    private void setThirdPerson(boolean third) {
        if (!((Boolean)Main.CLIENT_CONFIG.thirdPersonEnter.get()).booleanValue()) {
            return;
        }
        if (third) {
            this.minecraft.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        } else {
            this.minecraft.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
    }

    private LocalPlayer getPlayer() {
        return this.minecraft.f_91074_;
    }

    private Entity getRidingEntity() {
        return this.getPlayer().m_20202_();
    }

    private EntityVehicleBase getRidingVehicle() {
        Entity e = this.getRidingEntity();
        if (e instanceof EntityVehicleBase) {
            return (EntityVehicleBase)e;
        }
        return null;
    }
}

