/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityGenerator
extends TileEntityBase
implements ITickableBlockEntity,
IFluidHandler,
IEnergyStorage,
Container {
    public final int maxStorage;
    public int storedEnergy;
    public final int maxMillibuckets;
    protected int currentMillibuckets;
    protected final int energyGeneration;
    protected Fluid currentFluid;
    protected SimpleContainer inventory;
    public final ContainerData FIELDS = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TileEntityGenerator.this.storedEnergy;
                }
                case 1: {
                    return TileEntityGenerator.this.currentMillibuckets;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityGenerator.this.storedEnergy = value;
                    break;
                }
                case 1: {
                    TileEntityGenerator.this.currentMillibuckets = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public TileEntityGenerator(BlockPos pos, BlockState state) {
        super(Main.GENERATOR_TILE_ENTITY_TYPE, pos, state);
        this.inventory = new SimpleContainer(0);
        this.maxStorage = (Integer)Main.SERVER_CONFIG.generatorEnergyStorage.get();
        this.storedEnergy = 0;
        this.maxMillibuckets = (Integer)Main.SERVER_CONFIG.generatorFluidStorage.get();
        this.currentMillibuckets = 0;
        this.energyGeneration = (Integer)Main.SERVER_CONFIG.generatorEnergyGeneration.get();
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.setBlockEnabled(this.isEnabled());
        if (this.currentFluid != null && this.currentMillibuckets > 0 && this.storedEnergy + this.energyGeneration <= this.maxStorage) {
            --this.currentMillibuckets;
            this.storedEnergy += this.energyGeneration;
            if (this.currentMillibuckets <= 0) {
                this.currentMillibuckets = 0;
                this.currentFluid = null;
            }
        }
        if (this.currentMillibuckets <= 0 && this.currentFluid != null) {
            this.currentMillibuckets = 0;
            this.currentFluid = null;
        }
        if (this.currentFluid == null && this.currentMillibuckets > 0) {
            this.currentMillibuckets = 0;
        }
        this.handlePushEnergy();
        this.m_6596_();
    }

    public boolean isValidFuel(Fluid f) {
        return Main.SERVER_CONFIG.generatorValidFuelList.stream().anyMatch(fluidTag -> fluidTag.contains(f));
    }

    private void handlePushEnergy() {
        for (Direction side : Direction.values()) {
            IEnergyStorage storage = EnergyUtils.getEnergyStorageOffset((LevelAccessor)this.f_58857_, this.f_58858_, side);
            if (storage == null) continue;
            EnergyUtils.pushEnergy(this, storage, this.storedEnergy);
        }
    }

    public boolean isEnabled() {
        return this.currentMillibuckets > 0 && this.storedEnergy + this.energyGeneration < this.maxStorage;
    }

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_().equals(ModBlocks.GENERATOR) && (Boolean)state.m_61143_((Property)BlockGui.POWERED) != enabled) {
            ModBlocks.GENERATOR.setPowered(this.f_58857_, this.f_58858_, state, enabled);
        }
    }

    @Override
    public Component getTranslatedName() {
        return new TranslatableComponent("block.car.generator");
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("stored_energy", this.storedEnergy);
        if (this.currentFluid != null) {
            FluidStack stack = new FluidStack(this.currentFluid, this.currentMillibuckets);
            CompoundTag comp = new CompoundTag();
            stack.writeToNBT(comp);
            compound.m_128365_("fluid", (Tag)comp);
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.storedEnergy = compound.m_128451_("stored_energy");
        if (compound.m_128441_("fluid")) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("fluid"));
            this.currentFluid = stack.getFluid();
            this.currentMillibuckets = stack.getAmount();
        }
        super.m_142466_(compound);
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public ItemStack m_8020_(int index) {
        return this.inventory.m_8020_(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return this.inventory.m_7407_(index, count);
    }

    public ItemStack m_8016_(int index) {
        return this.inventory.m_8016_(index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.m_6836_(index, stack);
    }

    public int m_6893_() {
        return this.inventory.m_6893_();
    }

    public boolean m_6542_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public void m_5856_(Player player) {
        this.inventory.m_5856_(player);
    }

    public void m_5785_(Player player) {
        this.inventory.m_5785_(player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.inventory.m_7013_(index, stack);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int i = Math.min(maxExtract, this.storedEnergy);
        if (!simulate) {
            this.storedEnergy -= i;
            this.m_6596_();
        }
        return i;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (this.currentFluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.currentFluid, this.currentMillibuckets);
    }

    public int getTankCapacity(int tank) {
        return this.maxMillibuckets;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack.getFluid()) && (this.currentFluid == null || this.currentFluid.equals(stack.getFluid()));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.currentFluid == null && this.isValidFuel(resource.getFluid()) || resource.getFluid().equals(this.currentFluid)) {
            int amount = Math.min(this.maxMillibuckets - this.currentMillibuckets, resource.getAmount());
            if (action.execute()) {
                this.currentMillibuckets += amount;
                if (this.currentFluid == null) {
                    this.currentFluid = resource.getFluid();
                }
                this.m_6596_();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

