/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TCuboidPart;
import codechicken.multipart.TDynamicRenderPart;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TFastRenderPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TNormalOcclusionPart;
import codechicken.multipart.TileMultipart;
import codechicken.translocators.client.render.RenderTranslocator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TranslocatorPart
extends TMultiPart
implements TCuboidPart,
TFacePart,
TNormalOcclusionPart,
ITickable,
TDynamicRenderPart,
TFastRenderPart {
    public static Cuboid6 base = new Cuboid6(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
    public static Cuboid6[] boxes = new Cuboid6[6];
    public static Cuboid6[][] base_parts = new Cuboid6[6][4];
    public static int HIT_BASE = 0;
    public static int HIT_INSERT = 1;
    public byte side;
    public boolean a_eject = true;
    public boolean b_eject = true;
    public boolean redstone;
    public boolean invert_redstone = true;
    public boolean fast;
    public double a_insertpos = 1.0;
    public double b_insertpos = 1.0;

    public void save(NBTTagCompound tag) {
        tag.func_74774_a("side", this.side);
        tag.func_74757_a("invert_redstone", this.invert_redstone);
        tag.func_74757_a("redstone", this.redstone);
        tag.func_74757_a("fast", this.fast);
    }

    public void load(NBTTagCompound tag) {
        this.side = tag.func_74771_c("side");
        this.invert_redstone = tag.func_74767_n("invert_redstone");
        this.redstone = tag.func_74767_n("redstone");
        this.fast = tag.func_74767_n("fast");
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.side);
        packet.writeBoolean(this.a_eject);
        packet.writeBoolean(this.redstone);
        packet.writeBoolean(this.fast);
    }

    public void readDesc(MCDataInput packet) {
        this.side = packet.readByte();
        this.a_eject = packet.readBoolean();
        this.redstone = packet.readBoolean();
        this.fast = packet.readBoolean();
    }

    public void sendDescUpdate() {
        this.writeDesc(this.getWriteStream().writeBoolean(true));
    }

    public void read(MCDataInput packet) {
        boolean desc = packet.readBoolean();
        if (desc) {
            super.read(packet);
            this.onPartChanged(this);
        } else {
            this.readIncUpdate(packet);
        }
    }

    public MCDataOutput getIncStream() {
        return this.getWriteStream().writeBoolean(false);
    }

    public void readIncUpdate(MCDataInput packet) {
    }

    public void onPartChanged(TMultiPart part) {
        if (!this.world().field_72995_K) {
            this.onNeighborChanged();
        }
        super.onPartChanged(part);
    }

    public boolean solid(int side) {
        return false;
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public int getSlotMask() {
        return 1 << this.side;
    }

    public Cuboid6 getBounds() {
        return boxes[this.side];
    }

    public Cuboid6 getInsertBounds() {
        return new Cuboid6(0.375, 0.0, 0.375, 0.625, this.a_insertpos * 2.0 / 16.0 + 0.0625, 0.625).apply(Rotation.sideRotations[this.side].at(Vector3.center));
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(boxes[this.side], this.getInsertBounds());
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList cuboids = Lists.newArrayList((Object[])new Cuboid6[]{boxes[this.side]});
        cuboids.add(this.getInsertBounds().copy());
        return cuboids;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        List<IndexedCuboid6> parts = Lists.newArrayList((Object[])base_parts[this.side]).stream().map(b -> new IndexedCuboid6((Object)HIT_BASE, b)).collect(Collectors.toList());
        parts.add(new IndexedCuboid6((Object)HIT_INSERT, this.getInsertBounds()));
        return parts;
    }

    public void onNeighborChanged() {
        if (!this.dropIfCantStay()) {
            this.sendDescUpdate();
        }
    }

    public void func_73660_a() {
        this.b_insertpos = this.a_insertpos;
        this.a_insertpos = MathHelper.approachExp((double)this.a_insertpos, (double)(this.a_eject ? 1.0 : 0.0), (double)0.5, (double)0.1);
        if (!this.world().field_72995_K) {
            this.b_eject = this.a_eject;
            boolean bl = this.a_eject = (this.redstone && this.world().func_175640_z(this.pos())) != this.invert_redstone;
            if (this.a_eject != this.b_eject) {
                this.markUpdate();
            }
        }
    }

    public boolean activate(EntityPlayer player, CuboidRayTraceResult hit, ItemStack held, EnumHand hand) {
        if (this.world().field_72995_K) {
            return true;
        }
        if (held.func_190926_b() && player.func_70093_af()) {
            this.stripModifiers();
            this.markUpdate();
        } else if (held.func_190926_b()) {
            if (hit.subHit == HIT_INSERT) {
                this.invert_redstone = !this.invert_redstone;
            } else {
                this.openGui(player);
            }
        } else if (held.func_77973_b() == Items.field_151137_ax && !this.redstone) {
            this.redstone = true;
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            if (this.world().func_175640_z(this.pos()) == this.invert_redstone == this.a_eject) {
                this.invert_redstone = !this.invert_redstone;
            }
            this.markUpdate();
        } else if (held.func_77973_b() == Items.field_151114_aO && !this.fast) {
            this.fast = true;
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            this.markUpdate();
        } else {
            this.openGui(player);
        }
        return true;
    }

    public void openGui(EntityPlayer player) {
    }

    public void stripModifiers() {
        if (this.redstone) {
            this.redstone = false;
            this.dropItem(new ItemStack(Items.field_151137_ax));
            if (this.invert_redstone != this.a_eject) {
                boolean bl = this.invert_redstone = !this.invert_redstone;
            }
        }
        if (this.fast) {
            this.fast = false;
            this.dropItem(new ItemStack(Items.field_151114_aO));
        }
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(this.getItem());
        if (this.redstone) {
            stacks.add(new ItemStack(Items.field_151137_ax));
        }
        if (this.fast) {
            stacks.add(new ItemStack(Items.field_151114_aO));
        }
        return stacks;
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        this.getDrops().forEach(this::dropItem);
        this.tile().remPart((TMultiPart)this);
    }

    public ItemStack pickItem(CuboidRayTraceResult hit) {
        return this.getItem();
    }

    public abstract ItemStack getItem();

    public abstract int getTType();

    public abstract boolean canStay();

    public TranslocatorPart setupPlacement(EntityPlayer player, int side) {
        this.side = (byte)(side ^ 1);
        return this;
    }

    public void markUpdate() {
        this.tile().func_70296_d();
        this.tile().notifyPartChange((TMultiPart)this);
        this.sendDescUpdate();
    }

    public boolean canEject() {
        if (!this.world().field_72995_K) {
            boolean b;
            boolean bl = b = (this.redstone && this.world().func_175640_z(this.pos())) != this.invert_redstone;
            if (b != this.a_eject) {
                return b;
            }
        }
        return this.a_eject;
    }

    public boolean canConnect(int side) {
        TMultiPart other = this.tile().partMap(side);
        return other instanceof TranslocatorPart && this.getTType() == ((TranslocatorPart)other).getTType();
    }

    public boolean canInsert(int side) {
        return this.canConnect(side) && !((TranslocatorPart)this.tile().partMap(side)).canEject();
    }

    public <T> T getOther(int side) {
        return (T)this.tile().partMap(side);
    }

    protected void dropItem(ItemStack stack) {
        TileMultipart.dropItem((ItemStack)stack, (World)this.world(), (Vector3)Vector3.fromTileCenter((TileEntity)this.tile()));
    }

    public int getIconIndex() {
        int i = 0;
        if (this.redstone) {
            i |= this.world().func_175640_z(this.pos()) ? 2 : 1;
        }
        if (this.fast) {
            i |= 4;
        }
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, BlockRenderLayer layer, CCRenderState ccrs) {
        if (layer == BlockRenderLayer.SOLID) {
            RenderTranslocator.renderStatic(ccrs, this, pos);
            return true;
        }
        return false;
    }

    public boolean drawHighlight(EntityPlayer player, CuboidRayTraceResult hit, float frame) {
        if (hit.subHit == HIT_BASE) {
            RenderUtils.renderHitBox((EntityPlayer)player, (Cuboid6)boxes[this.side].copy().add(hit.func_178782_a()), (float)frame);
            return true;
        }
        return false;
    }

    public Cuboid6 getRenderBounds() {
        return this.getBounds();
    }

    public void renderDynamic(Vector3 pos, int pass, float frame) {
        RenderTranslocator.renderDynamic(this, pos, frame);
    }

    public boolean canRenderDynamic(int pass) {
        return pass == 0 && this.a_eject;
    }

    public void renderFast(CCRenderState ccrs, Vector3 pos, int pass, float frameDelta) {
        RenderTranslocator.renderFast(ccrs, this, pos, frameDelta);
    }

    public boolean canRenderFast(int pass) {
        return pass == 0;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            double d1 = 0.1875;
            double x1 = TranslocatorPart.base.min.x;
            double y1 = TranslocatorPart.base.min.y;
            double z1 = TranslocatorPart.base.min.z;
            double x2 = TranslocatorPart.base.max.x;
            double y2 = TranslocatorPart.base.max.y;
            double z2 = TranslocatorPart.base.max.z;
            Transformation rt = Rotation.sideRotations[i].at(Vector3.center);
            TranslocatorPart.boxes[i] = base.copy().apply(rt);
            TranslocatorPart.base_parts[i] = new Cuboid6[]{new Cuboid6(x1, y1, z1, x1 + d1, y2, z2).apply(rt), new Cuboid6(x2 - d1, y1, z1, x2, y2, z2).apply(rt), new Cuboid6(x1 + d1, y1, z1, x2 - d1, y2, z1 + d1).apply(rt), new Cuboid6(x1 + d1, y1, z2 - d1, x2 - d1, y2, z2).apply(rt)};
        }
    }
}

