/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.shapelessenchant;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ShapelessEnchantSerializer
extends ShapelessRecipe.Serializer {
    @Nonnull
    public ShapelessRecipe func_199425_a_(@Nonnull ResourceLocation recipeId, JsonObject json) {
        HashMap enchantmentLevelMap;
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingredients = ShapelessEnchantSerializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        JsonObject jsonObject = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)jsonObject);
        if (jsonObject.has("enchantments")) {
            JsonElement enchantments = jsonObject.get("enchantments");
            enchantmentLevelMap = Maps.newHashMap();
            if (enchantments.isJsonArray()) {
                for (JsonElement jsonElement : enchantments.getAsJsonArray()) {
                    if (!jsonElement.isJsonObject()) continue;
                    Pair<Enchantment, Integer> enchantmentLevelPair = ShapelessEnchantSerializer.parseJson(jsonElement.getAsJsonObject());
                    enchantmentLevelMap.put(enchantmentLevelPair.getKey(), enchantmentLevelPair.getValue());
                }
            } else if (enchantments.isJsonObject()) {
                Pair<Enchantment, Integer> enchantmentLevelPair = ShapelessEnchantSerializer.parseJson(enchantments.getAsJsonObject());
                enchantmentLevelMap.put(enchantmentLevelPair.getKey(), enchantmentLevelPair.getValue());
            }
        } else {
            throw new JsonParseException("No String or Array found for enchantments");
        }
        EnchantmentHelper.func_82782_a((Map)enchantmentLevelMap, (ItemStack)itemstack);
        return new ShapelessRecipe(recipeId, s, itemstack, ingredients);
    }

    private static Pair<Enchantment, Integer> parseJson(JsonObject jsonObject) {
        String name = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"name");
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(name));
        if (enchantment == null) {
            throw new JsonParseException("Failed to find enchantment named: " + name);
        }
        return Pair.of((Object)enchantment, (Object)JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"level", (int)1));
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
            if (ingredient.func_203189_d()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }
}

