/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network.locator;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class PlayerInventoryFinder {
    public static String MAIN = "main_inventory";
    public static HashMap<String, PlayerInventoryFinder> FINDERS = new HashMap();
    private final Function<PlayerEntity, Integer> slotAmountGetter;
    private final BiFunction<PlayerEntity, Integer, ItemStack> stackGetter;
    private final IStackModifier stackSetter;

    public static Optional<PlayerInventoryFinder> get(String name) {
        return Optional.ofNullable(FINDERS.get(name));
    }

    public PlayerInventoryFinder(Function<PlayerEntity, Integer> slotAmountGetter, BiFunction<PlayerEntity, Integer, ItemStack> stackGetter, IStackModifier stackSetter) {
        this.slotAmountGetter = slotAmountGetter;
        this.stackGetter = stackGetter;
        this.stackSetter = stackSetter;
    }

    public Function<PlayerEntity, Integer> getSlotAmountGetter() {
        return this.slotAmountGetter;
    }

    public BiFunction<PlayerEntity, Integer, ItemStack> getStackGetter() {
        return this.stackGetter;
    }

    public IStackModifier getStackSetter() {
        return this.stackSetter;
    }

    public static void init() {
    }

    static {
        FINDERS.put(MAIN, new PlayerInventoryFinder(playerEntity -> playerEntity.field_71071_by.field_70462_a.size(), (playerEntity, integer) -> (ItemStack)playerEntity.field_71071_by.field_70462_a.get(integer.intValue()), (playerEntity, slot, stack) -> {
            ItemStack cfr_ignored_0 = (ItemStack)playerEntity.field_71071_by.field_70462_a.set(slot, (Object)stack);
        }));
    }

    public static class Target {
        private final String name;
        private final PlayerInventoryFinder finder;
        private final int slot;

        public Target(String name, PlayerInventoryFinder finder, int slot) {
            this.name = name;
            this.finder = finder;
            this.slot = slot;
        }

        public String getName() {
            return this.name;
        }

        public PlayerInventoryFinder getFinder() {
            return this.finder;
        }

        public int getSlot() {
            return this.slot;
        }
    }

    public static interface IStackModifier {
        public void consume(PlayerEntity var1, int var2, ItemStack var3);
    }
}

