/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.nbthandler;

import com.google.common.collect.Lists;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.INBTHandler;
import com.hrznstudio.titanium.nbthandler.data.BlockPosNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.BooleanNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.DoubleNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.EnumDyeColorNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.FloatNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.IntegerNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.ItemStackHandlerNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.ItemStackNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.LongNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.NBTSerializableNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.ShortNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.StringNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.TankNBTHandler;
import com.hrznstudio.titanium.nbthandler.data.UUIDNBTHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;

public class NBTManager {
    private static NBTManager ourInstance = new NBTManager();
    private List<INBTHandler> handlerList = new ArrayList<INBTHandler>();
    private HashMap<Class<? extends TileEntity>, List<Field>> tileFieldList = new HashMap();

    private NBTManager() {
        this.handlerList.add(new IntegerNBTHandler());
        this.handlerList.add(new ShortNBTHandler());
        this.handlerList.add(new LongNBTHandler());
        this.handlerList.add(new FloatNBTHandler());
        this.handlerList.add(new DoubleNBTHandler());
        this.handlerList.add(new BooleanNBTHandler());
        this.handlerList.add(new ItemStackNBTHandler());
        this.handlerList.add(new BlockPosNBTHandler());
        this.handlerList.add(new StringNBTHandler());
        this.handlerList.add(new EnumDyeColorNBTHandler());
        this.handlerList.add(new ItemStackHandlerNBTHandler());
        this.handlerList.add(new TankNBTHandler());
        this.handlerList.add(new UUIDNBTHandler());
        this.handlerList.add(new NBTSerializableNBTHandler());
    }

    public static NBTManager getInstance() {
        return ourInstance;
    }

    private static List<Field> getAllDeclaredFields(Class<?> entity) {
        ArrayList currentClassFields = Lists.newArrayList((Object[])entity.getDeclaredFields());
        Class<?> parent = entity.getSuperclass();
        if (TileEntity.class.isAssignableFrom(parent)) {
            currentClassFields.addAll(NBTManager.getAllDeclaredFields(entity.getSuperclass()));
        }
        return currentClassFields;
    }

    public void scanTileClassForAnnotations(Class<? extends TileEntity> entity) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : NBTManager.getAllDeclaredFields(entity)) {
            if (!field.isAnnotationPresent(Save.class) || !this.checkForHandler(field)) continue;
            field.setAccessible(true);
            fields.add(field);
        }
        for (Field field : entity.getFields()) {
            if (!field.isAnnotationPresent(Save.class) || !this.checkForHandler(field)) continue;
            fields.add(field);
        }
        if (!fields.isEmpty()) {
            this.tileFieldList.put(entity, fields);
        }
    }

    private boolean checkForHandler(Field field) {
        for (INBTHandler handler : this.handlerList) {
            if (!handler.isClassValid(field.getType())) continue;
            return true;
        }
        throw new RuntimeException("Missing NBT Field processor for " + field.getType());
    }

    public CompoundNBT writeTileEntity(TileEntity entity, CompoundNBT compound) {
        if (this.tileFieldList.containsKey(entity.getClass())) {
            for (Field field : this.tileFieldList.get(entity.getClass())) {
                Save save = field.getAnnotation(Save.class);
                try {
                    Object obj = field.get(entity);
                    if (obj == null) continue;
                    compound = this.handleNBTWrite(compound, save.value().isEmpty() ? field.getName() : save.value(), obj, field);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return compound;
    }

    public void readTileEntity(TileEntity entity, CompoundNBT compound) {
        if (this.tileFieldList.containsKey(entity.getClass())) {
            for (Field field : this.tileFieldList.get(entity.getClass())) {
                if (!compound.func_74764_b(field.getName())) continue;
                Save save = field.getAnnotation(Save.class);
                try {
                    Object value = this.handleNBTRead(compound, save.value().isEmpty() ? field.getName() : save.value(), field.get(entity), field);
                    field.set(entity, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public CompoundNBT writeTileEntityObject(TileEntity entity, Object object, CompoundNBT compound) {
        if (this.tileFieldList.containsKey(entity.getClass())) {
            for (Field field : this.tileFieldList.get(entity.getClass())) {
                try {
                    if (!object.equals(field.get(entity))) continue;
                    Save save = field.getAnnotation(Save.class);
                    Object obj = field.get(entity);
                    if (obj == null) continue;
                    compound = this.handleNBTWrite(compound, save.value().isEmpty() ? field.getName() : save.value(), obj, field);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return compound;
    }

    private CompoundNBT handleNBTWrite(CompoundNBT compound, String name, Object value, Field field) {
        for (INBTHandler handler : this.handlerList) {
            if (!handler.isClassValid(value == null ? field.getType() : value.getClass()) || !handler.storeToNBT(compound, name, value)) continue;
            return compound;
        }
        return compound;
    }

    private Object handleNBTRead(CompoundNBT compound, String name, @Nullable Object value, Field field) {
        for (INBTHandler handler : this.handlerList) {
            Object readValue;
            if (!handler.isClassValid(value == null ? field.getType() : value.getClass()) || !compound.func_74764_b(name) || (readValue = handler.readFromNBT(compound, name, value)) == null) continue;
            return readValue;
        }
        return value;
    }

    public List<INBTHandler> getHandlerList() {
        return this.handlerList;
    }

    public HashMap<Class<? extends TileEntity>, List<Field>> getTileFieldList() {
        return this.tileFieldList;
    }
}

