/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.bundle;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.LockableOverlayAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.INBTSerializable;

public class LockableInventoryBundle<T extends BasicTile>
implements IComponentBundle,
INBTSerializable<CompoundNBT> {
    private InventoryComponent<T> inventory;
    private BiPredicate<ItemStack, Integer> cachedFilter;
    private ButtonComponent buttonAddon;
    private T componentHarness;
    private ItemStack[] filter;
    private int lockPosX;
    private int lockPosY;
    private boolean isLocked;

    public LockableInventoryBundle(T componentHarness, final InventoryComponent<T> inventory, int lockPosX, int lockPosY, boolean isLocked) {
        this.componentHarness = componentHarness;
        this.inventory = inventory;
        this.cachedFilter = inventory.getInsertPredicate();
        this.filter = new ItemStack[this.inventory.getSlots()];
        Arrays.fill(this.filter, ItemStack.field_190927_a);
        this.lockPosX = lockPosX;
        this.lockPosY = lockPosY;
        this.isLocked = isLocked;
        this.buttonAddon = new ButtonComponent(lockPosX, lockPosY, 14, 14){

            @Override
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(LockableInventoryBundle.this.buttonAddon, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_UNLOCKED, TextFormatting.GOLD + LangUtil.getString("tooltip.titanium.locks", new Object[0]) + TextFormatting.WHITE + " " + LangUtil.getString("tooltip.titanium.facing_handler." + inventory.getName().toLowerCase(), new Object[0])), new StateButtonInfo(1, AssetTypes.BUTTON_LOCKED, TextFormatting.GOLD + LangUtil.getString("tooltip.titanium.unlocks", new Object[0]) + TextFormatting.WHITE + " " + LangUtil.getString("tooltip.titanium.facing_handler." + inventory.getName().toLowerCase(), new Object[0]))}){

                    @Override
                    public int getState() {
                        return LockableInventoryBundle.this.isLocked ? 1 : 0;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.isLocked = !this.isLocked;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.filter[i] = this.inventory.getStackInSlot(i).func_77946_l();
            }
            this.updateFilter();
            ((BasicTile)((Object)((Object)this.componentHarness))).syncObject(this);
        });
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.inventory instanceof SidedInventoryComponent ? Collections.singletonList(() -> new LockableOverlayAddon((SidedInventoryComponent)this.inventory, this.lockPosX, this.lockPosY)) : Collections.emptyList();
    }

    @Override
    public void accept(IComponentHandler ... handler) {
        for (IComponentHandler iComponentHandler : handler) {
            iComponentHandler.add(this.inventory, this.buttonAddon);
        }
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Collections.emptyList();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compoundNBT.func_74757_a("Locked", this.isLocked);
        ListNBT nbt = new ListNBT();
        for (ItemStack stack : this.filter) {
            nbt.add((Object)stack.serializeNBT());
        }
        compoundNBT.func_218657_a("Filter", (INBT)nbt);
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.inventory.deserializeNBT(nbt.func_74775_l("Inventory"));
        this.isLocked = nbt.func_74767_n("Locked");
        ListNBT list = (ListNBT)nbt.func_74781_a("Filter");
        this.filter = new ItemStack[list.size()];
        Arrays.fill(this.filter, ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            this.filter[i] = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
        }
        this.updateFilter();
    }

    private void updateFilter() {
        if (this.isLocked) {
            this.inventory.setInputFilter((stack, integer) -> integer < this.filter.length && !this.filter[integer].func_190926_b() && this.filter[integer].func_77969_a(stack));
        } else {
            Arrays.fill(this.filter, ItemStack.field_190927_a);
            this.inventory.setInputFilter(this.cachedFilter);
        }
        for (int i = 0; i < this.filter.length; ++i) {
            this.inventory.setSlotToItemStackRender(i, this.filter[i]);
        }
    }

    public InventoryComponent<T> getInventory() {
        return this.inventory;
    }
}

