/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockSlimeLeaves;

public class BlockSlimeVine
extends BlockVine {
    protected final BlockSlimeGrass.FoliageType foliage;
    protected final BlockSlimeVine nextStage;

    public BlockSlimeVine(BlockSlimeGrass.FoliageType foliage, BlockSlimeVine nextStage) {
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabWorld);
        this.func_149672_a(SoundType.field_185850_c);
        this.foliage = foliage;
        this.nextStage = nextStage;
    }

    public boolean func_193395_a(World world, BlockPos pos, EnumFacing side) {
        Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.isAcceptableNeighbor(world, pos.func_177972_a(side.func_176734_d()), side) && (above == Blocks.field_150350_a || above instanceof BlockVine || this.isAcceptableNeighbor(world, pos.func_177984_a(), EnumFacing.UP));
    }

    private boolean isAcceptableNeighbor(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_193401_d((IBlockAccess)world, pos, side) == BlockFaceShape.SOLID && !BlockSlimeVine.func_193397_e((Block)state.func_177230_c());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = iblockstate.func_177226_a((IProperty)field_176273_b, (Comparable)Boolean.valueOf(this.isAcceptableNeighbor(world, pos.func_177978_c(), EnumFacing.SOUTH)));
        iblockstate = iblockstate.func_177226_a((IProperty)field_176278_M, (Comparable)Boolean.valueOf(this.isAcceptableNeighbor(world, pos.func_177974_f(), EnumFacing.WEST)));
        iblockstate = iblockstate.func_177226_a((IProperty)field_176279_N, (Comparable)Boolean.valueOf(this.isAcceptableNeighbor(world, pos.func_177968_d(), EnumFacing.NORTH)));
        iblockstate = iblockstate.func_177226_a((IProperty)field_176280_O, (Comparable)Boolean.valueOf(this.isAcceptableNeighbor(world, pos.func_177976_e(), EnumFacing.EAST)));
        return iblockstate;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState state2;
        if (world.field_72995_K) {
            return;
        }
        IBlockState oldState = state;
        for (EnumFacing side : EnumFacing.Plane.HORIZONTAL) {
            IBlockState above;
            Block aboveBlock;
            PropertyBool prop = BlockSlimeVine.func_176267_a((EnumFacing)side);
            if (!((Boolean)state.func_177229_b((IProperty)prop)).booleanValue() || this.func_193395_a(world, pos, side.func_176734_d()) || (aboveBlock = (above = world.func_180495_p(pos.func_177984_a())).func_177230_c()) instanceof BlockSlimeLeaves || aboveBlock instanceof BlockVine && ((Boolean)above.func_177229_b((IProperty)prop)).booleanValue()) continue;
            state = state.func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(false));
        }
        if (BlockSlimeVine.func_176268_d((IBlockState)state) == 0) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        } else if (oldState != state) {
            world.func_180501_a(pos, state, 2);
        }
        BlockPos down = pos.func_177977_b();
        while ((state2 = world.func_180495_p(down)).func_177230_c() instanceof BlockVine) {
            world.func_184138_a(down, state2, state2, 3);
            down = down.func_177977_b();
        }
    }

    public void func_180650_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!worldIn.field_72995_K && rand.nextInt(4) == 0) {
            this.grow(worldIn, rand, pos, state);
        }
    }

    public void grow(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (this.nextStage == null) {
            return;
        }
        BlockPos below = pos.func_177977_b();
        if (worldIn.func_175623_d(below)) {
            if (this.freeFloating(worldIn, pos, state)) {
                int i = 0;
                while (worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this) {
                    ++i;
                }
                if (i > 2 || rand.nextInt(2) == 0) {
                    state = this.nextStage.func_176223_P().func_177226_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176273_b)).func_177226_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176278_M)).func_177226_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176279_N)).func_177226_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176280_O));
                }
            }
            worldIn.func_175656_a(below, state);
        }
    }

    private boolean freeFloating(World world, BlockPos pos, IBlockState state) {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (!((Boolean)state.func_177229_b((IProperty)BlockSlimeVine.func_176267_a((EnumFacing)side))).booleanValue() || !this.isAcceptableNeighbor(world, pos.func_177972_a(side), side.func_176734_d())) continue;
            return false;
        }
        return true;
    }
}

