/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitLightweight
extends AbstractTrait {
    private final float bonus = 0.1f;

    public TraitLightweight() {
        super("lightweight", 65280);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ToolNBT data = TagUtil.getToolStats(rootCompound);
        data.attackSpeedMultiplier = 1.1f;
        TagUtil.setToolTag(rootCompound, data.get());
        if (TinkerUtil.hasCategory(rootCompound, Category.LAUNCHER)) {
            ProjectileLauncherNBT launcherData = new ProjectileLauncherNBT(TagUtil.getToolTag(rootCompound));
            launcherData.drawSpeed += launcherData.drawSpeed * 0.1f;
            TagUtil.setToolTag(rootCompound, launcherData.get());
        }
    }

    @Override
    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        event.setNewSpeed(event.getNewSpeed() * 1.1f);
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getModifierIdentifier());
        return ImmutableList.of((Object)Util.translateFormatted(loc, Util.dfPercent.format(0.1f)));
    }
}

