/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.core;

import cofh.core.RegistryEnderAttuned;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.network.ByteBufHelper;
import cofh.lib.transport.ClientEnderChannelRegistry;
import cofh.lib.transport.EnderRegistry;
import cofh.lib.transport.IEnderChannelRegistry;
import cofh.lib.transport.ServerEnderChannelRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;

public class TeleportChannelRegistry {
    static ServerEnderChannelRegistry serverChannels;
    static ClientEnderChannelRegistry clientChannels;
    static final String dummy;

    public static void initialize() {
        PacketHandler.instance.registerPacket(Packet.class);
    }

    public static void createClientRegistry() {
        clientChannels = new ClientEnderChannelRegistry(){

            public String setFrequency(String string, int n, String string2) {
                if (string != dummy) {
                    PacketHandler.sendToServer((PacketBase)new Packet(this.hostedChannel, n, string2));
                }
                return super.setFrequency(this.hostedChannel, n, string2);
            }

            public String removeFrequency(String string, int n) {
                if (string != dummy) {
                    PacketHandler.sendToServer((PacketBase)new Packet(this.hostedChannel, n));
                }
                return super.removeFrequency(this.hostedChannel, n);
            }
        };
    }

    public static void createServerRegistry() {
        serverChannels = new ServerEnderChannelRegistry(new Configuration(new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/TeleportFrequencies.cfg")));
    }

    static void save() {
        serverChannels.save();
    }

    public static EnderRegistry getRegistry() {
        return RegistryEnderAttuned.getRegistry();
    }

    public static IEnderChannelRegistry getChannels(boolean bl) {
        return bl ? serverChannels : clientChannels;
    }

    public static void requestChannelList(String string) {
        PacketHandler.sendToServer((PacketBase)new Packet(string));
    }

    public static void updateChannelFrequency(EntityPlayer entityPlayer, String string, int n, String string2) {
        PacketHandler.sendTo((PacketBase)new Packet(string, n, string2), (EntityPlayer)entityPlayer);
    }

    public static void removeChannelFrequency(EntityPlayer entityPlayer, String string, int n) {
        PacketHandler.sendTo((PacketBase)new Packet(string, n), (EntityPlayer)entityPlayer);
    }

    static {
        dummy = new String();
    }

    public static class Packet
    extends PacketBase {
        public ByteBuf data;

        public Packet() {
        }

        private Packet(String string) {
            this.data = Unpooled.directBuffer();
            this.data.writeByte(0);
            ByteBufHelper.writeString((String)string, (ByteBuf)this.data);
        }

        private Packet(String string, int n) {
            this.data = Unpooled.directBuffer();
            this.data.writeByte(2);
            ByteBufHelper.writeString((String)string, (ByteBuf)this.data);
            ByteBufHelper.writeVarInt((int)n, (ByteBuf)this.data);
        }

        private Packet(String string, int n, String string2) {
            this.data = Unpooled.directBuffer();
            this.data.writeByte(1);
            ByteBufHelper.writeString((String)string, (ByteBuf)this.data);
            ByteBufHelper.writeVarInt((int)n, (ByteBuf)this.data);
            ByteBufHelper.writeString((String)string2, (ByteBuf)this.data);
        }

        private Packet(String string, Void void_) {
            this.data = Unpooled.directBuffer();
            this.data.writeByte(0);
            this.data.writeBytes(serverChannels.getFrequencyData(string));
        }

        public void encodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
            byteBuf.writeBytes(this.data);
        }

        public void decodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
            this.data = byteBuf;
        }

        public void handleClientSide(EntityPlayer entityPlayer) {
            switch (this.data.readByte()) {
                case 0: {
                    clientChannels.readFrequencyData(this.data);
                    break;
                }
                case 1: {
                    if (!clientChannels.getChannelName().equals(ByteBufHelper.readString((ByteBuf)this.data))) break;
                    clientChannels.setFrequency(dummy, ByteBufHelper.readVarInt((ByteBuf)this.data), ByteBufHelper.readString((ByteBuf)this.data));
                    break;
                }
                case 2: {
                    if (!clientChannels.getChannelName().equals(ByteBufHelper.readString((ByteBuf)this.data))) break;
                    clientChannels.removeFrequency(dummy, ByteBufHelper.readVarInt((ByteBuf)this.data));
                }
            }
        }

        public void handleServerSide(EntityPlayer entityPlayer) {
            switch (this.data.readByte()) {
                case 0: {
                    PacketHandler.sendTo((PacketBase)new Packet(ByteBufHelper.readString((ByteBuf)this.data), null), (EntityPlayer)entityPlayer);
                    break;
                }
                case 1: {
                    serverChannels.setFrequency(ByteBufHelper.readString((ByteBuf)this.data), ByteBufHelper.readVarInt((ByteBuf)this.data), ByteBufHelper.readString((ByteBuf)this.data));
                    break;
                }
                case 2: {
                    serverChannels.removeFrequency(ByteBufHelper.readString((ByteBuf)this.data), ByteBufHelper.readVarInt((ByteBuf)this.data));
                }
            }
        }
    }
}

