/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.FilterItem;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.item.ItemAttachment;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemFilter
extends ItemAttachment {
    IIcon[] icons;
    public static EnumRarity[] rarity = new EnumRarity[]{EnumRarity.common, EnumRarity.common, EnumRarity.uncommon, EnumRarity.uncommon, EnumRarity.rare};
    public static ItemStack basicFilter;
    public static ItemStack hardenedFilter;
    public static ItemStack reinforcedFilter;
    public static ItemStack signalumFilter;
    public static ItemStack resonantFilter;

    public ItemFilter() {
        this.func_77655_b("thermaldynamics.filter");
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + "." + itemStack.func_77960_j();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 5; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return rarity[itemStack.func_77960_j() % 5];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iIconRegister) {
        this.icons = new IIcon[5];
        for (int i = 0; i < 5; ++i) {
            this.icons[i] = iIconRegister.func_94245_a("thermaldynamics:filter" + i);
        }
        this.field_77791_bV = this.icons[0];
    }

    public IIcon func_77617_a(int n) {
        return this.icons[n % this.icons.length];
    }

    @Override
    public Attachment getAttachment(int n, ItemStack itemStack, TileTDBase tileTDBase) {
        int n2 = itemStack.func_77960_j() % 5;
        if (tileTDBase instanceof TileFluidDuct) {
            return new FilterFluid(tileTDBase, (byte)(n ^ 1), n2);
        }
        if (tileTDBase instanceof TileItemDuct) {
            return new FilterItem(tileTDBase, (byte)(n ^ 1), n2);
        }
        return null;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        super.func_77624_a(itemStack, entityPlayer, list, bl);
        int n = itemStack.func_77960_j() % 5;
        if (!StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.getInfoText((String)"item.thermaldynamics.filter.info"));
            if (StringHelper.displayShiftForDetail) {
                list.add(StringHelper.shiftForDetails());
            }
            return;
        }
        list.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        ItemFilter.addFiltering(list, n, Duct.Type.ITEM);
        list.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        ItemFilter.addFiltering(list, n, Duct.Type.FLUID);
    }

    public static void addFiltering(List list, int n, Duct.Type type) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringHelper.localize((String)"info.thermaldynamics.filter.options") + ": " + "\u00a7f");
        boolean bl = false;
        for (int i = 0; i < FilterLogic.flagTypes.length; ++i) {
            if (!FilterLogic.canAlterFlag(type, n, i)) continue;
            if (bl) {
                stringBuilder.append(", ");
            } else {
                bl = true;
            }
            stringBuilder.append(StringHelper.localize((String)("info.thermaldynamics.filter." + FilterLogic.flagTypes[i])));
        }
        bl = false;
        for (String string : Minecraft.func_71410_x().field_71466_p.func_78271_c(stringBuilder.toString(), 140)) {
            if (bl) {
                string = "  \u00a7f" + string;
            }
            bl = true;
            list.add("  " + string + "\u00a7r");
        }
    }

    public boolean preInit() {
        GameRegistry.registerItem((Item)this, (String)"filter");
        basicFilter = new ItemStack((Item)this, 1, 0);
        hardenedFilter = new ItemStack((Item)this, 1, 1);
        reinforcedFilter = new ItemStack((Item)this, 1, 2);
        signalumFilter = new ItemStack((Item)this, 1, 3);
        resonantFilter = new ItemStack((Item)this, 1, 4);
        return true;
    }
}

