/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.position.BlockPosition;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.debughelper.DebugHelper;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.TileTransportDuctBase;
import cofh.thermaldynamics.duct.entity.TileTransportDuctBaseRoute;
import cofh.thermaldynamics.duct.entity.TileTransportDuctLongRange;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.Route;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTransportDuctCrossover
extends TileTransportDuctBaseRoute {
    final BlockPosition[] rangePos = new BlockPosition[6];
    static final BlockPosition clientValue = new BlockPosition(0, 0, 0, ForgeDirection.DOWN);
    public static byte CHARGE_TIME = (byte)120;

    @Override
    public void handleTileSideUpdate(int n) {
        super.handleTileSideUpdate(n);
        if (this.rangePos[n] == null || this.rangePos[n].orientation == ForgeDirection.UNKNOWN) {
            this.rangePos[n] = null;
            return;
        }
        if (this.neighborTypes[n] != TileTDBase.NeighborTypes.OUTPUT) {
            if (n < 2 || ((TileEntity)this).field_145850_b.func_72899_e(((TileEntity)this).field_145851_c + Facing.field_71586_b[n], ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e + Facing.field_71585_d[n])) {
                this.rangePos[n] = null;
            }
            return;
        }
        if (this.rangePos[n] == clientValue) {
            return;
        }
        int n2 = this.rangePos[n].orientation.ordinal();
        if (((TileEntity)this).field_145850_b.func_72899_e(this.rangePos[n].x, this.rangePos[n].y, this.rangePos[n].z)) {
            TileEntity tileEntity = ((TileEntity)this).field_145850_b.func_147438_o(this.rangePos[n].x, this.rangePos[n].y, this.rangePos[n].z);
            if (tileEntity instanceof TileTransportDuctCrossover && !this.isBlockedSide(n) && !((TileTDBase)tileEntity).isBlockedSide(n2 ^ 1)) {
                this.neighborMultiBlocks[n] = (IMultiBlock)tileEntity;
                this.neighborTypes[n] = TileTDBase.NeighborTypes.MULTIBLOCK;
            } else {
                this.rangePos[n] = null;
                super.handleTileSideUpdate(n);
            }
        } else {
            this.neighborMultiBlocks[n] = null;
            this.neighborTypes[n] = TileTDBase.NeighborTypes.OUTPUT;
        }
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public Route getRoute(Entity entity, int n, byte by) {
        return null;
    }

    @Override
    public boolean openGui(EntityPlayer entityPlayer) {
        if (((TileEntity)this).field_145850_b.field_72995_K) {
            return true;
        }
        DebugHelper.startTimer();
        for (byte by = 0; by < 6; by = (byte)((byte)(by + 1))) {
            this.rangePos[by] = null;
            int n = 1;
            TileEntity tileEntity = this.getAdjTileEntitySafe(by);
            if (!(tileEntity instanceof TileTransportDuctLongRange)) continue;
            entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("Searching on side - " + ForgeDirection.getOrientation((int)by)));
            TileTransportDuctLongRange tileTransportDuctLongRange = (TileTransportDuctLongRange)tileEntity;
            TileTDBase tileTDBase = null;
            byte by2 = tileTransportDuctLongRange.nextDirection(by);
            BlockPosition blockPosition = new BlockPosition((TileEntity)tileTransportDuctLongRange);
            while (by2 != -1) {
                ++n;
                blockPosition.step((int)by2);
                for (int i = 2; i < 6; ++i) {
                    ((TileEntity)this).field_145850_b.func_72938_d(blockPosition.x + Facing.field_71586_b[i], blockPosition.z + Facing.field_71585_d[i]);
                }
                TileEntity tileEntity2 = ((TileEntity)this).field_145850_b.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
                if (tileEntity2 instanceof TileTransportDuctCrossover) {
                    tileTDBase = (TileTransportDuctCrossover)tileEntity2;
                    break;
                }
                if (!(tileEntity2 instanceof TileTransportDuctLongRange)) break;
                tileTransportDuctLongRange = (TileTransportDuctLongRange)tileEntity2;
                tileTransportDuctLongRange.onNeighborBlockChange();
                by2 = tileTransportDuctLongRange.nextDirection(by2);
            }
            if (tileTDBase != null) {
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("Linked to -  (" + tileTDBase.x() + ", " + tileTDBase.y() + ", " + tileTDBase.z() + ")"));
                ((TileTransportDuctCrossover)tileTDBase).rangePos[by2 ^ 1] = new BlockPosition((TileEntity)this).setOrientation(ForgeDirection.getOrientation((int)(by ^ 1)));
                this.rangePos[by] = new BlockPosition((TileEntity)tileTDBase).setOrientation(ForgeDirection.getOrientation((int)by2));
                if (this.internalGrid != null) {
                    this.internalGrid.destroyAndRecreate();
                }
                if (((TileTransportDuctBaseRoute)tileTDBase).internalGrid == null) continue;
                ((TileTransportDuctBaseRoute)tileTDBase).internalGrid.destroyAndRecreate();
                continue;
            }
            entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("Failed at - (" + blockPosition.x + ", " + blockPosition.y + ", " + blockPosition.z + ")"));
        }
        DebugHelper.stopTimer("Timer: ");
        return true;
    }

    @Override
    public IMultiBlock getPhysicalConnectedSide(byte by) {
        if (this.rangePos[by] != null) {
            TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)by);
            if (tileEntity instanceof TileTransportDuctLongRange) {
                return (TileTransportDuctLongRange)tileEntity;
            }
            return null;
        }
        return super.getPhysicalConnectedSide(by);
    }

    @Override
    public void advanceToNextTile(EntityTransport entityTransport) {
        if (this.rangePos[entityTransport.direction] == null) {
            super.advanceToNextTile(entityTransport);
        } else if (this.neighborTypes[entityTransport.direction] == TileTDBase.NeighborTypes.MULTIBLOCK && this.connectionTypes[entityTransport.direction].allowTransfer) {
            TileTransportDuctBase tileTransportDuctBase = (TileTransportDuctBase)this.getPhysicalConnectedSide(entityTransport.direction);
            if (!(tileTransportDuctBase instanceof TileTransportDuctLongRange)) {
                entityTransport.bouncePassenger(this);
                return;
            }
            if (tileTransportDuctBase.neighborTypes[entityTransport.direction ^ 1] == TileTDBase.NeighborTypes.MULTIBLOCK) {
                entityTransport.pos = new BlockPosition((TileEntity)tileTransportDuctBase);
                entityTransport.oldDirection = entityTransport.direction;
                entityTransport.direction = ((TileTransportDuctLongRange)tileTransportDuctBase).nextDirection(entityTransport.direction);
                if (entityTransport.direction == -1) {
                    entityTransport.dropPassenger();
                }
            } else {
                entityTransport.reRoute = true;
            }
        } else if (this.neighborTypes[entityTransport.direction] == TileTDBase.NeighborTypes.OUTPUT && this.connectionTypes[entityTransport.direction].allowTransfer) {
            entityTransport.dropPassenger();
        } else {
            entityTransport.bouncePassenger(this);
        }
    }

    @Override
    public boolean advanceEntity(EntityTransport entityTransport) {
        if (entityTransport.progress < 50 && entityTransport.progress + entityTransport.step >= 50 && this.neighborTypes[entityTransport.direction] == TileTDBase.NeighborTypes.MULTIBLOCK && this.rangePos[entityTransport.direction] != null) {
            entityTransport.progress = (byte)50;
            entityTransport.pause = CHARGE_TIME;
            return true;
        }
        return super.advanceEntity(entityTransport);
    }

    @Override
    public boolean advanceEntityClient(EntityTransport entityTransport) {
        if (entityTransport.progress < 50 && entityTransport.progress + entityTransport.step >= 50 && this.neighborTypes[entityTransport.direction] == TileTDBase.NeighborTypes.MULTIBLOCK && this.rangePos[entityTransport.direction] != null) {
            entityTransport.progress = (byte)50;
            entityTransport.pause = CHARGE_TIME;
            return true;
        }
        return super.advanceEntityClient(entityTransport);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        for (int n = 0; n < 6; n = (int)((byte)(n + 1))) {
            if (!nBTTagCompound.func_150297_b("crossover" + n, 10)) continue;
            NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("crossover" + n);
            this.rangePos[n] = new BlockPosition(nBTTagCompound2);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        for (int i = 0; i < 6; ++i) {
            if (this.rangePos[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            this.rangePos[i].writeToNBT(nBTTagCompound2);
            nBTTagCompound.func_74782_a("crossover" + i, (NBTBase)nBTTagCompound2);
        }
    }

    @Override
    public boolean isConnectable(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileTransportDuctBaseRoute && !(tileEntity instanceof TileTransportDuctCrossover);
    }

    @Override
    public boolean isSignificantTile(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileTransportDuctLongRange;
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        int n = 0;
        for (int n2 = 0; n2 < 6; n2 = (int)((byte)(n2 + 1))) {
            if (this.rangePos[n2] == null) continue;
            n |= 1 << n2;
        }
        packetCoFHBase.addInt(n);
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            int n = packetCoFHBase.getInt();
            for (int i = 0; i < this.rangePos.length; ++i) {
                if ((n & 1 << i) == 0) continue;
                this.rangePos[i] = clientValue;
            }
        }
    }

    @Override
    public int getWeight() {
        return super.getWeight() * 100;
    }
}

