/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.energy;

import cofh.api.energy.EnergyStorage;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.energy.TileEnergyDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.MultiBlockGridTracking;
import net.minecraft.world.World;

public class EnergyGrid
extends MultiBlockGridTracking {
    public final EnergyStorage myStorage;
    private int currentEnergy = 0;
    private int extraEnergy = 0;
    private final int type;
    public static int[] NODE_STORAGE = new int[]{1200, 4800, 48000, 192000, 0};
    public static int[] NODE_TRANSFER = new int[]{200, 800, 8000, 32000, 0};

    public static void initialize() {
        String[] stringArray = new String[]{"Basic", "Hardened", "Reinforced", "Resonant"};
        String string = "Duct.Energy.";
        for (int i = 0; i < 4; ++i) {
            String string2 = string + stringArray[i];
            EnergyGrid.NODE_TRANSFER[i] = MathHelper.clamp((int)ThermalDynamics.config.get(string2, "Transfer", NODE_TRANSFER[i]), (int)(NODE_TRANSFER[i] / 10), (int)(NODE_TRANSFER[i] * 10));
            EnergyGrid.NODE_STORAGE[i] = NODE_TRANSFER[i] * 6;
        }
    }

    public EnergyGrid(World world, int n) {
        super(world);
        this.type = n;
        this.myStorage = new EnergyStorage(NODE_STORAGE[n], NODE_TRANSFER[n]){

            public int receiveEnergy(int n, boolean bl) {
                return EnergyGrid.this.trackIn(super.receiveEnergy(n, bl), bl);
            }

            public int extractEnergy(int n, boolean bl) {
                return EnergyGrid.this.trackOut(super.extractEnergy(n, bl), bl);
            }
        };
    }

    @Override
    public void balanceGrid() {
        this.myStorage.setCapacity(this.nodeSet.size() * NODE_STORAGE[this.type]);
    }

    @Override
    public boolean canAddBlock(IMultiBlock iMultiBlock) {
        return iMultiBlock instanceof TileEnergyDuct && ((TileEnergyDuct)iMultiBlock).getDuctType().type == this.type;
    }

    @Override
    public int getLevel() {
        return this.myStorage.getEnergyStored();
    }

    @Override
    public void tickGrid() {
        block1: {
            super.tickGrid();
            if (this.nodeSet.isEmpty() || this.myStorage.getEnergyStored() <= 0) break block1;
            this.currentEnergy = this.myStorage.getEnergyStored() / this.nodeSet.size();
            this.extraEnergy = this.myStorage.getEnergyStored() % this.nodeSet.size();
            for (IMultiBlock iMultiBlock : this.nodeSet) {
                if (!iMultiBlock.tickPass(0) || iMultiBlock.getGrid() == null) break;
            }
        }
    }

    public int getSendableEnergy() {
        return Math.min(this.myStorage.getMaxExtract(), this.currentEnergy == 0 ? this.extraEnergy : this.currentEnergy);
    }

    public void useEnergy(int n) {
        this.myStorage.extractEnergy(n, false);
        if (n > this.currentEnergy) {
            this.extraEnergy -= n - this.currentEnergy;
            this.extraEnergy = Math.max(0, this.extraEnergy);
        }
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid multiBlockGrid) {
        return super.canGridsMerge(multiBlockGrid) && ((EnergyGrid)multiBlockGrid).type == this.type;
    }

    @Override
    public void addNode(IMultiBlock iMultiBlock) {
        super.addNode(iMultiBlock);
        TileEnergyDuct tileEnergyDuct = (TileEnergyDuct)iMultiBlock;
        if (tileEnergyDuct.energyForGrid > 0) {
            this.myStorage.modifyEnergyStored(tileEnergyDuct.energyForGrid);
        }
    }

    @Override
    public void removeBlock(IMultiBlock iMultiBlock) {
        if (iMultiBlock.isNode()) {
            ((TileEnergyDuct)iMultiBlock).energyForGrid = this.getNodeShare(iMultiBlock);
        }
        super.removeBlock(iMultiBlock);
    }

    public int getNodeShare(IMultiBlock iMultiBlock) {
        return this.nodeSet.size() == 1 ? this.myStorage.getEnergyStored() : (this.isFirstMultiblock(iMultiBlock) ? this.myStorage.getEnergyStored() / this.nodeSet.size() + this.myStorage.getEnergyStored() % this.nodeSet.size() : this.myStorage.getEnergyStored() / this.nodeSet.size());
    }

    @Override
    protected String getUnit() {
        return "RF";
    }
}

