/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.BlockTFLeaves;
import twilightforest.block.BlockTFLog;
import twilightforest.block.TFBlocks;
import twilightforest.enums.LeavesVariant;
import twilightforest.enums.WoodVariant;
import twilightforest.world.feature.TFGenerator;
import twilightforest.world.feature.TFTreeGenerator;

public class TFGenCanopyTree
extends TFTreeGenerator {
    protected int minHeight = 20;
    protected int chanceAddFirstFive = 3;
    protected int chanceAddSecondFive = 8;
    private List<BlockPos> leaves = Lists.newArrayList();

    public TFGenCanopyTree() {
        this(false);
    }

    public TFGenCanopyTree(boolean notify) {
        super(notify);
        this.treeState = TFBlocks.twilight_log.func_176223_P().func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.CANOPY));
        this.branchState = this.treeState.func_177226_a((IProperty)BlockTFLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leafState = TFBlocks.twilight_leaves.func_176223_P().func_177226_a(BlockTFLeaves.VARIANT, (Comparable)((Object)LeavesVariant.CANOPY)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.rootState = TFBlocks.root.func_176223_P();
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int treeHeight = this.minHeight;
        if (random.nextInt(this.chanceAddFirstFive) == 0) {
            treeHeight += random.nextInt(5);
            if (random.nextInt(this.chanceAddSecondFive) == 0) {
                treeHeight += random.nextInt(5);
            }
        }
        if (pos.func_177956_o() >= 256 - treeHeight) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (!state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this.source)) {
            return false;
        }
        this.leaves.clear();
        this.buildBranch(world, pos, 0, treeHeight, 0.0, 0.0, true, random);
        int numBranches = 3 + random.nextInt(2);
        float offset = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, pos, treeHeight - 10 + b, 9.0, 0.3 * (double)b + (double)offset, 0.2, false, random);
        }
        for (BlockPos leafPos : this.leaves) {
            this.makeLeafBlob(world, leafPos);
        }
        if (TFGenerator.hasAirAround(world, pos.func_177977_b())) {
            this.func_175903_a(world, pos.func_177977_b(), this.treeState);
        } else {
            this.func_175903_a(world, pos.func_177977_b(), this.rootState);
        }
        int numRoots = 3 + random.nextInt(2);
        offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, pos, offset, b);
        }
        return true;
    }

    private void makeLeafBlob(World world, BlockPos leafPos) {
        TFGenerator.makeLeafCircle(this, world, leafPos.func_177977_b(), 3, this.leafState, true);
        TFGenerator.makeLeafCircle(this, world, leafPos, 4, this.leafState, true);
        TFGenerator.makeLeafCircle(this, world, leafPos.func_177984_a(), 2, this.leafState, true);
    }

    void buildBranch(World world, BlockPos pos, int height, double length, double angle, double tilt, boolean trunk, Random treeRNG) {
        BlockPos src = pos.func_177981_b(height);
        BlockPos dest = TFGenerator.translate(src, length, angle, tilt);
        if (world.func_175697_a(dest, 5)) {
            TFGenerator.drawBresehnam(this, world, src, dest, trunk ? this.treeState : this.branchState);
            if (trunk) {
                this.addFirefly(world, pos, 3 + treeRNG.nextInt(7), treeRNG.nextDouble());
            }
            this.func_175903_a(world, dest.func_177974_f(), this.branchState);
            this.func_175903_a(world, dest.func_177976_e(), this.branchState);
            this.func_175903_a(world, dest.func_177968_d(), this.branchState);
            this.func_175903_a(world, dest.func_177978_c(), this.branchState);
            this.leaves.add(dest);
        }
    }
}

