/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import twilightforest.entity.ai.EntityAITFHoverBase;
import twilightforest.entity.boss.EntityTFSnowQueen;

public class EntityAITFHoverSummon
extends EntityAITFHoverBase<EntityTFSnowQueen> {
    private static final int MAX_MINIONS_AT_ONCE = 4;
    private int seekTimer;
    private final int maxSeekTime;

    public EntityAITFHoverSummon(EntityTFSnowQueen snowQueen, Class<EntityPlayer> targetClass, double speed) {
        super(snowQueen, targetClass, 6.0f, 6.0f);
        this.func_75248_a(3);
        this.maxSeekTime = 80;
    }

    public boolean func_75250_a() {
        EntityLivingBase target = ((EntityTFSnowQueen)this.attacker).func_70638_az();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(target.getClass())) {
            return false;
        }
        if (((EntityTFSnowQueen)this.attacker).getCurrentPhase() != EntityTFSnowQueen.Phase.SUMMON) {
            return false;
        }
        return ((EntityTFSnowQueen)this.attacker).func_70635_at().func_75522_a((Entity)target);
    }

    public boolean func_75253_b() {
        EntityLivingBase target = ((EntityTFSnowQueen)this.attacker).func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (((EntityTFSnowQueen)this.attacker).getCurrentPhase() != EntityTFSnowQueen.Phase.SUMMON) {
            return false;
        }
        if (this.seekTimer > this.maxSeekTime) {
            return false;
        }
        return this.canEntitySee((Entity)this.attacker, this.hoverPosX, this.hoverPosY, this.hoverPosZ);
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        ++this.seekTimer;
        EntityLivingBase target = ((EntityTFSnowQueen)this.attacker).func_70638_az();
        if (((EntityTFSnowQueen)this.attacker).func_70092_e(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            this.checkAndSummon();
            this.makeNewHoverSpot(target);
        }
        double offsetX = this.hoverPosX - ((EntityTFSnowQueen)this.attacker).field_70165_t;
        double offsetY = this.hoverPosY - ((EntityTFSnowQueen)this.attacker).field_70163_u;
        double offsetZ = this.hoverPosZ - ((EntityTFSnowQueen)this.attacker).field_70161_v;
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        distanceDesired = MathHelper.func_76133_a((double)distanceDesired);
        double velX = offsetX / distanceDesired * 0.05;
        double velY = offsetY / distanceDesired * 0.1;
        double velZ = offsetZ / distanceDesired * 0.05;
        ((EntityTFSnowQueen)this.attacker).func_70024_g(velX, velY += (double)0.05f, velZ);
        if (target != null) {
            ((EntityTFSnowQueen)this.attacker).func_70625_a((Entity)target, 30.0f, 30.0f);
            ((EntityTFSnowQueen)this.attacker).func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        }
    }

    @Override
    protected void makeNewHoverSpot(EntityLivingBase target) {
        super.makeNewHoverSpot(target);
        this.seekTimer = 0;
    }

    private void checkAndSummon() {
        if (((EntityTFSnowQueen)this.attacker).getSummonsRemaining() > 0 && ((EntityTFSnowQueen)this.attacker).countMyMinions() < 4) {
            ((EntityTFSnowQueen)this.attacker).summonMinionAt(((EntityTFSnowQueen)this.attacker).func_70638_az());
        }
    }
}

