/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.Items;
import net.minecraft.world.World;
import twilightforest.client.particle.ParticleAnnihilate;
import twilightforest.client.particle.ParticleFirefly;
import twilightforest.client.particle.ParticleGhastTear;
import twilightforest.client.particle.ParticleGhastTrap;
import twilightforest.client.particle.ParticleIceBeam;
import twilightforest.client.particle.ParticleLargeFlame;
import twilightforest.client.particle.ParticleLeafRune;
import twilightforest.client.particle.ParticleProtection;
import twilightforest.client.particle.ParticleSmokeScale;
import twilightforest.client.particle.ParticleSnow;
import twilightforest.client.particle.ParticleSnowGuardian;
import twilightforest.client.particle.ParticleSnowWarning;
import twilightforest.client.particle.TFParticleType;

public class TFParticleFactory {
    private static final Map<TFParticleType, IParticleFactory> factories = new EnumMap<TFParticleType, IParticleFactory>(TFParticleType.class);

    @Nullable
    public static Particle createParticle(TFParticleType particleType, World world, double x, double y, double z, double vx, double vy, double vz) {
        IParticleFactory factory = factories.get((Object)particleType);
        return factory != null ? factory.createParticle(world, x, y, z, vx, vy, vz) : null;
    }

    static {
        factories.put(TFParticleType.LARGE_FLAME, ParticleLargeFlame::new);
        factories.put(TFParticleType.LEAF_RUNE, ParticleLeafRune::new);
        factories.put(TFParticleType.BOSS_TEAR, (world, x, y, z, vx, vy, vz) -> new ParticleGhastTear(world, x, y, z, vx, vy, vz, Items.field_151073_bk));
        factories.put(TFParticleType.GHAST_TRAP, ParticleGhastTrap::new);
        factories.put(TFParticleType.PROTECTION, ParticleProtection::new);
        factories.put(TFParticleType.SNOW, ParticleSnow::new);
        factories.put(TFParticleType.SNOW_GUARDIAN, (world, x, y, z, vx, vy, vz) -> new ParticleSnowGuardian(world, x, y, z, vx, vy, vz, 0.75f));
        factories.put(TFParticleType.SNOW_WARNING, (world, x, y, z, vx, vy, vz) -> new ParticleSnowWarning(world, x, y, z, vx, vy, vz, 1.0f));
        factories.put(TFParticleType.ICE_BEAM, (world, x, y, z, vx, vy, vz) -> new ParticleIceBeam(world, x, y, z, vx, vy, vz, 0.75f));
        factories.put(TFParticleType.ANNIHILATE, (world, x, y, z, vx, vy, vz) -> new ParticleAnnihilate(world, x, y, z, vx, vy, vz, 0.75f));
        factories.put(TFParticleType.HUGE_SMOKE, (world, x, y, z, vx, vy, vz) -> new ParticleSmokeScale(world, x, y, z, vx, vy, vz, 4.0f + world.field_73012_v.nextFloat()));
        factories.put(TFParticleType.FIREFLY, ParticleFirefly::new);
    }

    @FunctionalInterface
    private static interface IParticleFactory {
        public Particle createParticle(World var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }
}

