/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.entity.EntityTFWinterWolf;
import twilightforest.entity.EntityTFYeti;
import twilightforest.potions.TFPotions;
import twilightforest.world.feature.TFGenLargeWinter;

public class TFBiomeSnow
extends TFBiomeBase {
    private static final int MONSTER_SPAWN_RATE = 10;
    private final Random monsterRNG = new Random(53439L);

    public TFBiomeSnow(Biome.BiomeProperties props) {
        super(props);
        this.getTFBiomeDecorator().setTreesPerChunk(7);
        this.getTFBiomeDecorator().setGrassPerChunk(1);
        this.getTFBiomeDecorator().hasCanopy = false;
        this.getTFBiomeDecorator().field_76808_K = false;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFYeti.class, 20, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFWinterWolf.class, 5, 1, 4));
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return new WorldGenTaiga1();
        }
        if (random.nextInt(8) == 0) {
            return new TFGenLargeWinter();
        }
        return new WorldGenTaiga2(true);
    }

    public boolean func_76746_c() {
        return true;
    }

    public boolean func_76738_d() {
        return false;
    }

    public List<Biome.SpawnListEntry> func_76747_a(EnumCreatureType creatureType) {
        if (creatureType == EnumCreatureType.MONSTER) {
            return this.monsterRNG.nextInt(10) == 0 ? this.field_76761_J : new ArrayList();
        }
        return super.func_76747_a(creatureType);
    }

    @Override
    protected ResourceLocation[] getRequiredAdvancements() {
        return new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")};
    }

    @Override
    public void enforceProgression(EntityPlayer player, World world) {
        if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
            player.func_70690_d(new PotionEffect(TFPotions.frosty, 100, 2));
            if (world.field_73012_v.nextInt(4) == 0) {
                TFFeature.YETI_CAVE.trySpawnHintMonster(world, player);
            }
        }
    }
}

