/*
 * Decompiled with CFR 0.152.
 */
package net.modcrafters.mclib.ingredients.implementations;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.modcrafters.mclib.ingredients.IFluidIngredient;
import net.modcrafters.mclib.ingredients.IItemIngredient;
import net.modcrafters.mclib.ingredients.IMachineIngredient;
import net.modcrafters.mclib.ingredients.IngredientAmountMatch;
import net.modcrafters.mclib.ingredients.implementations.BaseFluidIngredient$WhenMappings;
import net.modcrafters.mclib.inventory.IMachineInventory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lnet/modcrafters/mclib/ingredients/implementations/BaseFluidIngredient;", "Lnet/modcrafters/mclib/ingredients/IFluidIngredient;", "()V", "amount", "", "getAmount", "()I", "isMatch", "", "ingredient", "Lnet/modcrafters/mclib/ingredients/IMachineIngredient;", "amountMatch", "Lnet/modcrafters/mclib/ingredients/IngredientAmountMatch;", "tesla-core-lib"})
public abstract class BaseFluidIngredient
implements IFluidIngredient {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isMatch(@NotNull IMachineIngredient ingredient, @NotNull IngredientAmountMatch amountMatch) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        Intrinsics.checkParameterIsNotNull((Object)((Object)amountMatch), (String)"amountMatch");
        IMachineIngredient iMachineIngredient = ingredient;
        if (iMachineIngredient instanceof IItemIngredient) {
            List<ItemStack> other = ((IItemIngredient)ingredient).getItemStacks();
            if (other.size() == 1 && other.get(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidHandlerItem cap = (IFluidHandlerItem)other.get(0).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (cap != null) {
                    switch (BaseFluidIngredient$WhenMappings.$EnumSwitchMapping$0[amountMatch.ordinal()]) {
                        case 1: {
                            FluidStack fluid = cap.drain(this.getFluidStack(), false);
                            if (fluid != null && fluid.amount > 0) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 2: {
                            FluidStack fluid = cap.drain(this.getFluidStack(), false);
                            if (fluid != null && fluid.amount == this.getFluidStack().amount) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 3: {
                            FluidStack fluid = cap.drain(this.getFluidStack(), false);
                            if (fluid != null && fluid.amount == this.getFluidStack().amount) {
                                IFluidTankProperties[] iFluidTankPropertiesArray = cap.getTankProperties();
                                Intrinsics.checkExpressionValueIsNotNull((Object)iFluidTankPropertiesArray, (String)"cap.tankProperties");
                                Object[] $receiver$iv = iFluidTankPropertiesArray;
                                int sum$iv = 0;
                                for (int i = 0; i < $receiver$iv.length; ++i) {
                                    void it;
                                    Object element$iv = $receiver$iv[i];
                                    IFluidTankProperties iFluidTankProperties = (IFluidTankProperties)element$iv;
                                    int n = sum$iv;
                                    void v2 = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                                    FluidStack fluidStack = v2.getContents();
                                    int n2 = fluidStack != null ? fluidStack.amount : 0;
                                    sum$iv = n + n2;
                                }
                                if (sum$iv == this.getFluidStack().amount) {
                                    bl = true;
                                    break;
                                }
                            }
                            bl = false;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
        } else if (iMachineIngredient instanceof IFluidIngredient) {
            FluidStack other = ((IFluidIngredient)ingredient).getFluidStack();
            bl = this.getFluidStack().isFluidEqual(other) && amountMatch.compare(this.getFluidStack().amount, other.amount);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int getAmount() {
        return this.getFluidStack().amount;
    }

    @Override
    public boolean isMatch(@NotNull IMachineInventory inventory, int slot, @NotNull IngredientAmountMatch amountMatch) {
        Intrinsics.checkParameterIsNotNull((Object)inventory, (String)"inventory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)amountMatch), (String)"amountMatch");
        return IFluidIngredient.DefaultImpls.isMatch(this, inventory, slot, amountMatch);
    }

    @Override
    public boolean isSame(@NotNull IMachineIngredient ingredient) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        return IFluidIngredient.DefaultImpls.isSame(this, ingredient);
    }

    @Override
    public boolean isEnough(@NotNull IMachineIngredient ingredient) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        return IFluidIngredient.DefaultImpls.isEnough(this, ingredient);
    }

    @Override
    public boolean isSameIngredient(@NotNull IMachineIngredient ingredient) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        return IFluidIngredient.DefaultImpls.isSameIngredient(this, ingredient);
    }
}

