/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.songs;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public class Song {
    private String name;
    private int tempo;
    private Integer[] notes;
    private String credits;
    private int weight;
    public static final Song EMPTY = new Song("Error", 1, new Integer[]{0, 0});

    public Song(String name, int tempo, Integer[] notes) {
        this(name, tempo, notes, "");
    }

    public Song(String name, int tempo, Integer[] notes, String credits) {
        this.name = name;
        this.tempo = Math.max(1, tempo);
        this.notes = notes;
        this.credits = credits;
        this.weight = 100;
    }

    public void processForPlaying() {
        ArrayList<Integer> newNotes = new ArrayList<Integer>();
        Integer[] integerArray = this.notes;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            if (i2 <= 0) {
                int j = -Math.min(-1, i2);
                int blanks = j - 1;
                for (int k = 0; k < blanks; ++k) {
                    newNotes.add(0);
                }
                continue;
            }
            newNotes.add(i2);
        }
        this.notes = newNotes.toArray(new Integer[0]);
    }

    public String getTranslationKey() {
        return this.name;
    }

    public TranslatableComponent getName() {
        return new TranslatableComponent(this.getTranslationKey());
    }

    public int getTempo() {
        if (this.tempo <= 1) {
            boolean bl = true;
        }
        return Math.max(1, this.tempo);
    }

    public Integer[] getNotes() {
        return this.notes;
    }

    public static CompoundTag saveToTag(Song song) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", song.name);
        tag.m_128405_("tempo", song.tempo);
        tag.m_128408_("notes", List.of(song.notes));
        tag.m_128359_("credits", song.credits);
        return tag;
    }

    public static Song loadFromTag(CompoundTag tag) {
        String name = tag.m_128461_("name");
        int tempo = tag.m_128451_("tempo");
        int[] notes = tag.m_128465_("notes");
        Integer[] n = new Integer[notes.length];
        for (int i = 0; i < notes.length; ++i) {
            n[i] = notes[i];
        }
        String credits = tag.m_128461_("credits");
        return new Song(name, tempo, n, credits);
    }

    public IntList getNoteToPlay(long timeSinceStarted) {
        IntArrayList toPlay = new IntArrayList();
        try {
            int currentIndex = (int)(timeSinceStarted / (long)this.getTempo()) % this.notes.length;
            for (int n = this.notes[currentIndex].intValue(); n > 1; n /= 100) {
                toPlay.add(Mth.m_14045_((int)(n % 100), (int)0, (int)25));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toPlay;
    }

    public String toString() {
        return "Song{name='" + this.name + "'}";
    }

    public int getWeight() {
        return this.weight;
    }
}

