/*
 * Decompiled with CFR 0.152.
 */
package streams.tfc;

import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.WorldGen.MapGen.MapGenBaseTFC;
import com.bioxx.tfc.api.TFCOptions;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class MapGenRavineTFC
extends MapGenBaseTFC {
    private float[] multipliers = new float[1024];
    private final int height;
    private final int variability;

    public MapGenRavineTFC(int h, int v) {
        this.height = h;
        this.variability = v;
    }

    public void generate(IChunkProvider par1IChunkProvider, World par2World, int par3, int par4, Block[] idsBig, byte[] metaBig) {
        super.generate(par1IChunkProvider, par2World, par3, par4, idsBig);
    }

    protected void generateRavine(long seed, int chunkX, int chunkZ, Block[] blockArray, double xCoord, double yCoord, double zCoord, float par12, float par13, float par14, int par15, int par16, double yScale) {
        Random var19 = new Random(seed);
        double chunkMidX = chunkX * 16 + 8;
        double chunkMidZ = chunkZ * 16 + 8;
        float var24 = 0.0f;
        float var25 = 0.0f;
        if (par16 <= 0) {
            int var26 = this.range * 16 - 16;
            par16 = var26 - var19.nextInt(var26 / 4);
        }
        boolean var54 = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            var54 = true;
        }
        float var27 = 1.0f;
        for (int var28 = 0; var28 < 256; ++var28) {
            if (var28 == 0 || var19.nextInt(3) == 0) {
                var27 = 1.0f + var19.nextFloat() * var19.nextFloat() * 1.0f;
            }
            this.multipliers[var28] = var27 * var27;
        }
        while (par15 < par16) {
            double var53 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)par15 * (float)Math.PI / (float)par16)) * par12 * 1.0f);
            double var30 = var53 * yScale;
            var53 *= (double)var19.nextFloat() * 0.25 + 0.75;
            var30 *= (double)var19.nextFloat() * 0.25 + 0.75;
            float var32 = MathHelper.func_76134_b((float)par14);
            float var33 = MathHelper.func_76126_a((float)par14);
            xCoord += (double)(MathHelper.func_76134_b((float)par13) * var32);
            yCoord += (double)var33;
            zCoord += (double)(MathHelper.func_76126_a((float)par13) * var32);
            par14 *= 0.7f;
            par14 += var25 * 0.05f;
            par13 += var24 * 0.05f;
            var25 *= 0.8f;
            var24 *= 0.5f;
            var25 += (var19.nextFloat() - var19.nextFloat()) * var19.nextFloat() * 2.0f;
            var24 += (var19.nextFloat() - var19.nextFloat()) * var19.nextFloat() * 4.0f;
            if (var54 || var19.nextInt(4) != 0) {
                double var34 = xCoord - chunkMidX;
                double var36 = zCoord - chunkMidZ;
                double var38 = par16 - par15;
                double var40 = par12 + 2.0f + 16.0f;
                if (var34 * var34 + var36 * var36 - var38 * var38 > var40 * var40) {
                    return;
                }
                if (xCoord >= chunkMidX - 16.0 - var53 * 2.0 && zCoord >= chunkMidZ - 16.0 - var53 * 2.0 && xCoord <= chunkMidX + 16.0 + var53 * 2.0 && zCoord <= chunkMidZ + 16.0 + var53 * 2.0) {
                    int index;
                    int x;
                    int xMin = MathHelper.func_76128_c((double)(xCoord - var53)) - chunkX * 16 - 1;
                    int xMax = MathHelper.func_76128_c((double)(xCoord + var53)) - chunkX * 16 + 1;
                    int minY = MathHelper.func_76128_c((double)(yCoord - var30)) - 1;
                    int maxY = MathHelper.func_76128_c((double)(yCoord + var30)) + 1;
                    int zMin = MathHelper.func_76128_c((double)(zCoord - var53)) - chunkZ * 16 - 1;
                    int zMax = MathHelper.func_76128_c((double)(zCoord + var53)) - chunkZ * 16 + 1;
                    if (xMin < 0) {
                        xMin = 0;
                    }
                    if (xMax > 16) {
                        xMax = 16;
                    }
                    if (minY < 1) {
                        minY = 1;
                    }
                    if (maxY > 250) {
                        maxY = 250;
                    }
                    if (zMin < 0) {
                        zMin = 0;
                    }
                    if (zMax > 16) {
                        zMax = 16;
                    }
                    boolean isBlocked = false;
                    for (x = xMin; !isBlocked && x < xMax; ++x) {
                        for (int z = zMin; !isBlocked && z < zMax; ++z) {
                            for (int y = maxY + 1; !isBlocked && y >= minY - 1; --y) {
                                index = (x * 16 + z) * 256 + y;
                                if (y < 0 || y >= 256) continue;
                                int roofOffset = 1;
                                while (TFC_Core.isSoilWAILA((Block)blockArray[index + roofOffset])) {
                                    ++roofOffset;
                                }
                                if (blockArray[index + roofOffset] != null && blockArray[index + roofOffset].func_149688_o().func_76224_d()) {
                                    isBlocked = true;
                                }
                                if (y == minY - 1 || x == xMin || x == xMax - 1 || z == zMin || z == zMax - 1) continue;
                                y = minY;
                            }
                        }
                    }
                    if (!isBlocked) {
                        for (x = xMin; x < xMax; ++x) {
                            double var59 = ((double)(x + chunkX * 16) + 0.5 - xCoord) / var53;
                            for (index = zMin; index < zMax; ++index) {
                                double var45 = ((double)(index + chunkZ * 16) + 0.5 - zCoord) / var53;
                                int index2 = (x * 16 + index) * 256 + maxY;
                                if (!(var59 * var59 + var45 * var45 < 1.0)) continue;
                                for (int var49 = maxY - 1; var49 >= minY; --var49) {
                                    double var50 = ((double)var49 + 0.5 - yCoord) / var30;
                                    if ((var59 * var59 + var45 * var45) * (double)this.multipliers[var49] + var50 * var50 / 6.0 < 1.0 && TFC_Core.isGround((Block)blockArray[index2])) {
                                        if (TFC_Core.isSoilOrGravel((Block)blockArray[index2 + 1])) {
                                            int upCount = 1;
                                            while (TFC_Core.isSoilOrGravel((Block)blockArray[index2 + upCount])) {
                                                blockArray[index2 + upCount] = Blocks.field_150350_a;
                                                ++upCount;
                                            }
                                        }
                                        blockArray[index2] = var49 < 10 ? Blocks.field_150353_l : Blocks.field_150350_a;
                                    }
                                    --index2;
                                }
                            }
                        }
                        if (var54) break;
                    }
                }
            }
            ++par15;
        }
    }

    protected void recursiveGenerate(World par1World, int chunkX, int chunkZ, int par4, int par5, Block[] par6) {
        if (TFCOptions.ravineRarity > 0 && this.rand.nextInt(TFCOptions.ravineRarity) == 0) {
            double startX = chunkX * 16 + this.rand.nextInt(16);
            double startY = this.rand.nextInt(this.variability) + this.height;
            double startZ = chunkZ * 16 + this.rand.nextInt(16);
            int var13 = 1;
            for (int var14 = 0; var14 < var13; ++var14) {
                float angleY = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float angleZ = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float angleX = (this.rand.nextFloat() * 2.0f + this.rand.nextFloat()) * 2.0f;
                double scaleY = 1.2 + (double)this.rand.nextFloat() + (double)this.rand.nextFloat();
                this.generateRavine(this.rand.nextLong(), par4, par5, par6, startX, startY, startZ, angleX, angleY, angleZ, 0, 0, scaleY);
            }
        }
    }
}

