/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.common.network.packets;

import com.black_dog20.servertabinfo.client.ClientDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPlayers {
    private Map<UUID, ResourceLocation> playerDims;

    public PacketPlayers(Map<UUID, ResourceLocation> playerDims) {
        this.playerDims = playerDims;
    }

    public static void encode(PacketPlayers msg, PacketBuffer buffer) {
        buffer.writeInt(msg.playerDims.size());
        for (Map.Entry<UUID, ResourceLocation> playerKvP : msg.playerDims.entrySet()) {
            buffer.func_179252_a(playerKvP.getKey());
            buffer.func_192572_a(playerKvP.getValue());
        }
    }

    public static PacketPlayers decode(PacketBuffer buffer) {
        HashMap<UUID, ResourceLocation> map = new HashMap<UUID, ResourceLocation>();
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            map.put(buffer.func_179253_g(), buffer.func_192575_l());
        }
        return new PacketPlayers(map);
    }

    public static class Handler {
        public static void handle(PacketPlayers msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ClientDataManager.PLAYER_DIMENSIONS = msg.playerDims;
            }));
            ctx.get().setPacketHandled(true);
        }
    }
}

