/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.common.events;

import com.black_dog20.servertabinfo.Config;
import com.black_dog20.servertabinfo.common.network.PacketHandler;
import com.black_dog20.servertabinfo.common.network.packets.PacketDimensions;
import com.black_dog20.servertabinfo.common.network.packets.PacketPlayers;
import com.black_dog20.servertabinfo.common.utils.Dimension;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="servertabinfo")
public class ServerEvents {
    private static List<Dimension> DIMENSIONS = new LinkedList<Dimension>();
    private static Map<UUID, ResourceLocation> PLAYER_DIMENSIONS = new HashMap<UUID, ResourceLocation>();
    private static int ticks = 0;

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.func_184103_al().func_72394_k() == 0) {
            ticks = 0;
            return;
        }
        if (ticks % (Integer)Config.REFRESH_TICKS.get() == 0) {
            Pair<Integer, Double> overall = ServerEvents.getTpsAndMean(server.field_71311_j);
            DIMENSIONS.clear();
            DIMENSIONS.add(new Dimension(new ResourceLocation("servertabinfo", "overall"), (Double)overall.getSecond(), (Integer)overall.getFirst()));
            for (ServerWorld world : server.forgeGetWorldMap().values()) {
                ResourceLocation name = world.func_234923_W_().func_240901_a_();
                Pair<Integer, Double> tpsAndMean = ServerEvents.getTpsAndMean(server.getTickTime(world.func_234923_W_()));
                DIMENSIONS.add(new Dimension(name, (Double)tpsAndMean.getSecond(), (Integer)tpsAndMean.getFirst()));
            }
            List playerList = server.func_184103_al().func_181057_v();
            PLAYER_DIMENSIONS.clear();
            for (ServerPlayerEntity player : playerList) {
                ResourceLocation name = player.func_130014_f_().func_234923_W_().func_240901_a_();
                PLAYER_DIMENSIONS.put(player.func_110124_au(), name);
            }
            PacketHandler.sendToAll(new PacketDimensions(DIMENSIONS));
            PacketHandler.sendToAll(new PacketPlayers(PLAYER_DIMENSIONS));
            ticks = 1;
            return;
        }
        ++ticks;
    }

    private static Pair<Integer, Double> getTpsAndMean(long[] tickArray) {
        long sum = 0L;
        if (tickArray == null) {
            return Pair.of((Object)0, (Object)0.0);
        }
        for (long tickTime : tickArray) {
            sum += tickTime;
        }
        double mean = (double)(sum / (long)tickArray.length) * 1.0E-6;
        int tps = (int)Math.min(1000.0 / mean, 20.0);
        return Pair.of((Object)tps, (Object)mean);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)event.getPlayer();
            ResourceLocation name = playerEntity.func_130014_f_().func_234923_W_().func_240901_a_();
            PLAYER_DIMENSIONS.put(playerEntity.func_110124_au(), name);
            PacketHandler.sendTo(new PacketDimensions(DIMENSIONS), playerEntity);
            PacketHandler.sendTo(new PacketPlayers(PLAYER_DIMENSIONS), playerEntity);
        }
    }
}

