/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import net.minecraft.world.biome.Biome;

public class BiomeControllerMapping {
    public static final Map<Integer, Integer> coldBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> warmBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> mediumBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> wetBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> dryBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> fieldsBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> mountainsBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> magicalBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> forestBiomeReplacements = new HashMap<Integer, Integer>();

    public static void setupControllerBiomes() {
        BiomeControllerMapping.makeFilteredBiomeMap(coldBiomeReplacements, ControllerType.CONTROLLER_COLD);
        BiomeControllerMapping.makeFilteredBiomeMap(warmBiomeReplacements, ControllerType.CONTROLLER_WARM);
        BiomeControllerMapping.makeFilteredBiomeMap(mediumBiomeReplacements, ControllerType.CONTROLLER_MEDIUM);
        BiomeControllerMapping.makeFilteredBiomeMap(wetBiomeReplacements, ControllerType.CONTROLLER_WET);
        BiomeControllerMapping.makeFilteredBiomeMap(dryBiomeReplacements, ControllerType.CONTROLLER_DRY);
        BiomeControllerMapping.makeFilteredBiomeMap(fieldsBiomeReplacements, ControllerType.CONTROLLER_FIELDS);
        BiomeControllerMapping.makeFilteredBiomeMap(mountainsBiomeReplacements, ControllerType.CONTROLLER_MOUNTAINS);
        BiomeControllerMapping.makeFilteredBiomeMap(magicalBiomeReplacements, ControllerType.CONTROLLER_MAGICAL);
        BiomeControllerMapping.makeFilteredBiomeMap(forestBiomeReplacements, ControllerType.CONTROLLER_FOREST);
    }

    private static void makeFilteredBiomeMap(Map<Integer, Integer> map, ControllerType type) {
        BiomeControllerMapping.makeFilteredBiomeMap(map, type.getFilter());
    }

    public static void makeFilteredBiomeMap(Map<Integer, Integer> map, ControllerType.BiomeFilter filter) {
        map.clear();
        boolean ok = false;
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            try {
                if (!filter.match(biome)) continue;
                ok = true;
                break;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Checking suitability of biome " + biome.field_76791_y + " (" + Biome.field_185377_q.func_177774_c((Object)biome) + ")", e);
            }
        }
        if (!ok) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null) continue;
                map.put(Biome.func_185362_a((Biome)biome), Biome.func_185362_a((Biome)biome));
            }
        } else {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null) continue;
                try {
                    if (filter.match(biome)) {
                        map.put(Biome.func_185362_a((Biome)biome), Biome.func_185362_a((Biome)biome));
                        continue;
                    }
                    map.put(Biome.func_185362_a((Biome)biome), BiomeControllerMapping.findSuitableBiomes(biome, filter));
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Checking suitability of biome " + biome.field_76791_y + " (" + Biome.field_185377_q.func_177774_c((Object)biome) + ")", e);
                }
            }
        }
    }

    private static int findSuitableBiomes(Biome biome, ControllerType.BiomeFilter filter) {
        double bestdist = 1.0E9;
        int bestidx = 0;
        for (Biome base : Biome.field_185377_q) {
            try {
                if (base == null || !filter.match(base)) continue;
                if (biome.func_150562_l() == base.func_150562_l()) {
                    return Biome.func_185362_a((Biome)base);
                }
                double dist = filter.calculateBiomeDistance(biome, base);
                if (!(dist < bestdist)) continue;
                bestdist = dist;
                bestidx = Biome.func_185362_a((Biome)base);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Checking suitability of biome " + base.field_76791_y + " (" + Biome.field_185377_q.func_177774_c((Object)base) + ")", e);
            }
        }
        return bestidx;
    }
}

