/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.dimlets.DimensionBuilderContainer;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class DimensionBuilderTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory,
SimpleComponent,
IPeripheral {
    public static final String CMD_GETBUILDING = "getBuilding";
    public static final String CLIENTCMD_GETBUILDING = "getBuilding";
    public static final String CMD_RSMODE = "rsMode";
    public static final String COMPONENT_NAME = "dimension_builder";
    private static int buildPercentage = 0;
    private int creative = -1;
    private RedstoneMode redstoneMode = RedstoneMode.REDSTONE_IGNORED;
    private int powered = 0;
    public static int OK = 0;
    public static int ERROR_NOOWNER = -1;
    public static int ERROR_TOOMANYDIMENSIONS = -2;
    private int errorMode = 0;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimensionBuilderContainer.factory, 1);
    private static int counter = 20;
    private static Random random = new Random();

    public DimensionBuilderTileEntity() {
        super(DimletConfiguration.BUILDER_MAXENERGY, DimletConfiguration.BUILDER_RECEIVEPERTICK);
    }

    private boolean isCreative() {
        if (this.creative == -1) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.creative = ((Object)((Object)DimletSetup.creativeDimensionBuilderBlock)).equals(block) ? 1 : 0;
        }
        return this.creative == 1;
    }

    protected void checkStateServer() {
        int ticksLeft;
        NBTTagCompound tagCompound = this.hasTab();
        if (tagCompound == null) {
            this.setState(-1);
            return;
        }
        if (this.redstoneMode != RedstoneMode.REDSTONE_IGNORED) {
            boolean rs;
            boolean bl = rs = this.powered > 0;
            if (this.redstoneMode == RedstoneMode.REDSTONE_OFFREQUIRED) {
                if (rs) {
                    this.setState(-1);
                    return;
                }
            } else if (this.redstoneMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                this.setState(-1);
                return;
            }
        }
        if ((ticksLeft = tagCompound.func_74762_e("ticksLeft")) > 0) {
            ticksLeft = this.createDimensionTick(tagCompound, ticksLeft);
        } else {
            this.maintainDimensionTick(tagCompound);
        }
        this.setState(ticksLeft);
    }

    public void setPowered(int powered) {
        if (this.powered != powered) {
            this.powered = powered;
            this.func_70296_d();
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return COMPONENT_NAME;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"hasTab", "getBuildingPercentage", "getDimensionPower", "getRedstoneMode", "setRedstoneMode"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.hasTab() != null};
            }
            case 1: {
                return this.getBuildingPercentage();
            }
            case 2: {
                return this.getDimensionPower();
            }
            case 3: {
                return new Object[]{this.getRedstoneMode().getDescription()};
            }
            case 4: {
                return this.setRedstoneMode((String)arguments[0]);
            }
        }
        return new Object[0];
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback(doc="Return true if this builder has a dimension tab in it", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] hasTab(Context context, Arguments args) throws Exception {
        return new Object[]{this.hasTab() != null};
    }

    @Callback(doc="Return the current dimension building progress as a percentage", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getBuildingPercentage(Context context, Arguments args) throws Exception {
        return this.getBuildingPercentage();
    }

    private Object[] getBuildingPercentage() {
        NBTTagCompound tagCompound = this.hasTab();
        if (tagCompound != null) {
            int ticksLeft = tagCompound.func_74762_e("ticksLeft");
            int tickCost = tagCompound.func_74762_e("tickCost");
            int pct = (tickCost - ticksLeft) * 100 / tickCost;
            return new Object[]{pct};
        }
        return new Object[]{0};
    }

    @Callback(doc="Return how much power (RF) the dimension in the builder is currently having", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getDimensionPower(Context context, Arguments args) throws Exception {
        return this.getDimensionPower();
    }

    private Object[] getDimensionPower() {
        NBTTagCompound tagCompound = this.hasTab();
        if (tagCompound != null) {
            int id = tagCompound.func_74762_e("id");
            int power = 0;
            if (id != 0) {
                DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(this.field_145850_b);
                power = dimensionStorage.getEnergyLevel(id);
            }
            return new Object[]{power};
        }
        return new Object[]{0};
    }

    @Callback(doc="Get the current redstone mode. Values are 'Ignored', 'Off', or 'On'", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getRedstoneMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.getRedstoneMode().getDescription()};
    }

    @Callback(doc="Set the current redstone mode. Values are 'Ignored', 'Off', or 'On'", setter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setRedstoneMode(Context context, Arguments args) throws Exception {
        String mode = args.checkString(0);
        return this.setRedstoneMode(mode);
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode(mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRedstoneMode(redstoneMode);
        return null;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    private NBTTagCompound hasTab() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack == null || itemStack.field_77994_a == 0) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound;
    }

    private void maintainDimensionTick(NBTTagCompound tagCompound) {
        int id = tagCompound.func_74762_e("id");
        if (id != 0) {
            int energy;
            int maxEnergy;
            DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(this.field_145850_b);
            int rf = this.isCreative() ? DimletConfiguration.BUILDER_MAXENERGY : this.getEnergyStored(ForgeDirection.DOWN);
            if (rf > (maxEnergy = DimletConfiguration.MAX_DIMENSION_POWER - (energy = dimensionStorage.getEnergyLevel(id)))) {
                rf = maxEnergy;
            }
            if (--counter < 0) {
                counter = 20;
                if (Logging.debugMode) {
                    Logging.log((String)("#################### id:" + id + ", rf:" + rf + ", energy:" + energy + ", max:" + maxEnergy));
                }
            }
            if (!this.isCreative()) {
                this.consumeEnergy(rf);
            }
            dimensionStorage.setEnergyLevel(id, energy + rf);
            dimensionStorage.save(this.field_145850_b);
        }
    }

    private int createDimensionTick(NBTTagCompound tagCompound, int ticksLeft) {
        RfToolsDimensionManager manager;
        if (DimletConfiguration.dimensionBuilderNeedsOwner) {
            int cnt;
            int tickCost;
            if (this.getOwnerUUID() == null) {
                this.errorMode = ERROR_NOOWNER;
                return ticksLeft;
            }
            if (DimletConfiguration.maxDimensionsPerPlayer >= 0 && (ticksLeft == (tickCost = tagCompound.func_74762_e("tickCost")) || ticksLeft < 5) && (cnt = (manager = RfToolsDimensionManager.getDimensionManager(this.field_145850_b)).countOwnedDimensions(this.getOwnerUUID())) >= DimletConfiguration.maxDimensionsPerPlayer) {
                this.errorMode = ERROR_TOOMANYDIMENSIONS;
                return ticksLeft;
            }
        }
        this.errorMode = OK;
        int createCost = tagCompound.func_74762_e("rfCreateCost");
        createCost = (int)((float)createCost * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.isCreative() || this.getEnergyStored(ForgeDirection.DOWN) >= createCost) {
            if (this.isCreative()) {
                ticksLeft = 0;
            } else {
                this.consumeEnergy(createCost);
                --ticksLeft;
                if (random.nextFloat() < this.getInfusedFactor() && --ticksLeft < 0) {
                    ticksLeft = 0;
                }
            }
            tagCompound.func_74768_a("ticksLeft", ticksLeft);
            if (ticksLeft <= 0) {
                manager = RfToolsDimensionManager.getDimensionManager(this.field_145850_b);
                DimensionDescriptor descriptor = new DimensionDescriptor(tagCompound);
                String name = tagCompound.func_74779_i("name");
                int id = manager.createNewDimension(this.field_145850_b, descriptor, name, this.getOwnerName(), this.getOwnerUUID());
                tagCompound.func_74768_a("id", id);
            }
        }
        return ticksLeft;
    }

    private void setState(int ticksLeft) {
        int state = 0;
        state = ticksLeft == 0 ? 0 : (ticksLeft == -1 ? 1 : ((ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int newmeta = BlockTools.setState((int)metadata, (int)state);
        if (newmeta != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newmeta, 2);
        }
    }

    public int[] func_94128_d(int side) {
        return DimensionBuilderContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return DimensionBuilderContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return DimensionBuilderContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Builder Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void requestBuildingPercentage() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getBuilding", "getBuilding", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getBuilding".equals(command)) {
            ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
            if (itemStack == null || itemStack.field_77994_a == 0) {
                return 0;
            }
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound == null) {
                return 0;
            }
            if (this.errorMode != OK) {
                return this.errorMode;
            }
            int ticksLeft = tagCompound.func_74762_e("ticksLeft");
            int tickCost = tagCompound.func_74762_e("tickCost");
            return (tickCost - ticksLeft) * 100 / tickCost;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getBuilding".equals(command)) {
            buildPercentage = result;
            return true;
        }
        return false;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRedstoneMode(RedstoneMode.getMode(m));
            return true;
        }
        return false;
    }

    public static int getBuildPercentage() {
        return buildPercentage;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74771_c("powered");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        byte m = tagCompound.func_74771_c(CMD_RSMODE);
        this.redstoneMode = RedstoneMode.values()[m];
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74774_a("powered", (byte)this.powered);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74774_a(CMD_RSMODE, (byte)this.redstoneMode.ordinal());
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }
}

