/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import mcjty.lib.varia.Check32;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.shapes.ShapeBlockInfo;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public interface IFormula {
    public void setup(BlockPos var1, BlockPos var2, BlockPos var3, NBTTagCompound var4);

    default public void getCheckSumClient(NBTTagCompound cardTag, Check32 crc) {
        ShapeCardItem.getLocalChecksum(cardTag, crc);
    }

    public boolean isInside(int var1, int var2, int var3);

    default public boolean isInsideSafe(int x, int y, int z) {
        return this.isInside(x, y, z);
    }

    default public IBlockState getLastState() {
        return null;
    }

    default public boolean isBorder(int x, int y, int z) {
        if (!(this.isInsideSafe(x - 1, y, z) && this.isInsideSafe(x + 1, y, z) && this.isInsideSafe(x, y, z - 1) && this.isInsideSafe(x, y, z + 1) && this.isInsideSafe(x, y - 1, z) && this.isInsideSafe(x, y + 1, z))) {
            return this.isInside(x, y, z);
        }
        return false;
    }

    default public boolean isVisible(int x, int y, int z) {
        return this.isClear(x - 1, y, z) || this.isClear(x + 1, y, z) || this.isClear(x, y - 1, z) || this.isClear(x, y + 1, z) || this.isClear(x, y, z - 1) || this.isClear(x, y, z + 1);
    }

    default public boolean isClear(int x, int y, int z) {
        if (!this.isInside(x, y, z)) {
            return true;
        }
        IBlockState state = this.getLastState();
        if (state != null) {
            return ShapeBlockInfo.isNonSolidBlock(state.func_177230_c());
        }
        return false;
    }

    default public boolean isCustom() {
        return false;
    }

    default public IFormula correctFormula(boolean solid) {
        if (solid) {
            return this;
        }
        return new IFormula(){

            @Override
            public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
                IFormula.this.setup(thisCoord, dimension, offset, card);
            }

            @Override
            public void getCheckSumClient(NBTTagCompound cardTag, Check32 crc) {
                IFormula.this.getCheckSumClient(cardTag, crc);
            }

            @Override
            public IBlockState getLastState() {
                return IFormula.this.getLastState();
            }

            @Override
            public boolean isInside(int x, int y, int z) {
                return IFormula.this.isBorder(x, y, z);
            }

            @Override
            public boolean isBorder(int x, int y, int z) {
                return IFormula.this.isBorder(x, y, z);
            }
        };
    }
}

