/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.config;

import com.google.common.base.Throwables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;

public class Config
extends Configuration {
    public static boolean base;
    public static boolean bop;
    public static boolean projectRed;
    public static boolean mekanism;
    public static boolean botania;
    public static boolean advancedRocketry;
    public static boolean armorPlus;
    public static boolean thermalFoundation;
    public static boolean draconicEvolution;
    public static boolean actuallyAdditions;
    public static boolean natura;
    public static boolean psi;
    public static boolean avaritia;
    public static boolean landCraft;
    public static boolean landCore;
    public static boolean mfr;
    public static boolean galacticraft;
    public static boolean survivalist;
    public static boolean projectE;
    public static boolean gemsplus;
    public static boolean appEng2;
    public static boolean environTech;
    public static boolean thaumcraft;
    public static boolean constructsArmory;
    public static boolean machines;
    public static boolean astralSorcery;
    public static boolean jetpackConarmModifier;
    public static float jetpackDurabilityBonusScale;
    public static boolean forceOutNaturalPledgeMaterials;
    public static boolean pyrotheumSmelt;
    public static boolean tfMelt;
    public static boolean katana;
    public static boolean laserGun;
    public static float katana_combo_multiplier;
    public static boolean katana_boosts_only_on_killing;
    public static boolean katana_smooth_progression;
    public static int laser_energy;
    public static int centrifugeEnergyPerMB;
    private static final IntArrayList botan_amount;
    private static final Set<Pair<String, Set<String>>> blacklistedForCentrifuge;
    private static final List<TrashThing> trashThings;
    private static int trashThingsSum;
    public static List<ItemStack> fruitStacks;
    public static IntSet fruitOreDicts;
    private static final MethodHandle injectHandle;
    private static final LanguageMap englishMap;

    public static IntList getBotanAmount() {
        return IntLists.unmodifiable((IntList)botan_amount);
    }

    @Nullable
    public static ItemStack fetchThing(Random random) {
        if (trashThingsSum <= 0) {
            trashThingsSum = trashThings.stream().mapToInt(t -> t.weight).sum();
        }
        int rval = random.nextInt(trashThingsSum);
        ItemStack thing = ItemStack.field_190927_a;
        for (TrashThing entry : trashThings) {
            thing = entry.stack;
            if ((rval -= entry.weight) >= 0) continue;
            break;
        }
        return thing;
    }

    public static boolean isFruit(ItemStack stack) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!fruitOreDicts.contains(id)) continue;
            return true;
        }
        Object object = fruitStacks.iterator();
        while (object.hasNext()) {
            ItemStack fruit = (ItemStack)object.next();
            if (!OreDictionary.itemMatches((ItemStack)fruit, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public Config(FMLPreInitializationEvent event) {
        super(event.getSuggestedConfigurationFile());
    }

    public void init1() {
        int i;
        this.addCustomCategoryComment("modules", "Use this to disable entire modules.");
        base = this.getBoolean("Enable vanilla TiC addons", "modules", true, "Add features to vanilla Tinkers Construct");
        bop = this.getBoolean("Enable BoP integration", "modules", true, "Integrate with Biomes o' Plenty");
        projectRed = this.getBoolean("Enable Project Red integration", "modules", true, "Integrate with Project Red-Core");
        mekanism = this.getBoolean("Enable Mekanism integration", "modules", true, "Integrate with Mekanism");
        botania = this.getBoolean("Enable Botania integration", "modules", true, "Integrate with Botania");
        forceOutNaturalPledgeMaterials = this.getBoolean("Force out Natural Pledge TiC materials", "tweaks", true, "If Natural Pledge is loaded:\nIf true: replace Natural Pledge Botania TiC materials with PlusTiC ones;\nOtherwise: do *not* load the Botania module for PlusTiC, overriding other settings.");
        advancedRocketry = this.getBoolean("Enable Advanced Rocketry integration", "modules", true, "Integrate with Advanced Rocketry (actually LibVulpes)");
        armorPlus = this.getBoolean("Enable ArmorPlus integration", "modules", true, "Integrate with ArmorPlus");
        thermalFoundation = this.getBoolean("Enable Thermal Foundation integration", "modules", true, "Integrate with Thermal Foundation");
        pyrotheumSmelt = this.getBoolean("Use Pyrotheum as smeltery fuel", "tweaks", true, "Use Pyrotheum as TiC smeltery fuel (only if Thermal Foundation is loaded)");
        tfMelt = this.getBoolean("Add smeltery recipes for Redstone, Glowstone, and Ender pearl", "tweaks", true, "Add smelting recipes for Redstone, Glowstone, and Ender pearl (only if Thermal Foundation is loaded)");
        draconicEvolution = this.getBoolean("Enable Draconic Evolution integration", "modules", true, "Integrate with Draconic Evolution");
        actuallyAdditions = this.getBoolean("Enable Actually Additions support", "modules", true, "Integrate with Actually Additions");
        natura = this.getBoolean("Enable Natura support", "modules", true, "Integrate with Natura");
        psi = this.getBoolean("Enable Psi support", "modules", true, "Integrate with Psi");
        avaritia = this.getBoolean("Enable Avaritia support", "modules", true, "Integrate with Avaritia");
        landCraft = this.getBoolean("Enable Land Craft support", "modules", true, "Integrate with Land Craft");
        landCore = this.getBoolean("Enable LandCore support", "modules", true, "Integrate with LandCore");
        mfr = this.getBoolean("Enable MFR support", "modules", true, "Integrate with Minefactory Reloaded");
        galacticraft = this.getBoolean("Enable Galacticraft support", "modules", true, "Integrate with Galacticraft");
        survivalist = this.getBoolean("Enable Survivalist support", "modules", true, "Integrate with Survivalist");
        projectE = this.getBoolean("Enable ProjectE support", "modules", true, "Integrate with ProjectE");
        gemsplus = this.getBoolean("Enable Gems+ support", "modules", true, "Integrate with Gems+");
        appEng2 = this.getBoolean("Enable Applied Energistics 2 support", "modules", true, "Integrate with Applied Energistics 2");
        environTech = this.getBoolean("Enable Environmental Tech support", "modules", true, "Integrate with Environmental Tech");
        thaumcraft = this.getBoolean("Enable Thaumcraft support", "modules", true, "Integrate with Thaumcraft");
        constructsArmory = this.getBoolean("Enable Constructs Armory support", "modules", true, "Integrate with Constructs Armory");
        machines = this.getBoolean("Enable Machines addon", "modules", true, "Enable the machines from this mod (Centrifuge, etc.)");
        astralSorcery = this.getBoolean("Enable Astral Sorcery support", "modules", true, "Integrate with Astral Sorcery");
        jetpackConarmModifier = this.getBoolean("Add Simply Jetpacks as ConArm modifiers", "modifiers", true, "Add Simply Jetpacks as ConArm modifiers");
        jetpackDurabilityBonusScale = this.getFloat("Durability bonus scalar for Simply Jetpacks modifiers", "modifiers", 1.25E-4f, 0.0f, Float.MAX_VALUE, "Durability bonus calculated as FUEL_CAPACITY_OF_JETPACK*this_scalar");
        katana = this.getBoolean("Enable Katana", "tools", true, "Enable Katana");
        katana_combo_multiplier = this.getFloat("Katana combo multiplier", "tools", 1.25f, 0.0f, Float.MAX_VALUE, "Multiply combo value by this to calculate bonus damage");
        katana_boosts_only_on_killing = this.getBoolean("Katana boosts only on killing", "tools", true, "Does Katana boost only on killing mob (true) or on any hit (false)?");
        katana_smooth_progression = this.getBoolean("Smooth Katana progression", "tools", false, "Should boosted damage of Katana change smoothly from material to material?");
        laserGun = this.getBoolean("Enable Laser Gun", "tools", true, "Enable Laser Gun");
        laser_energy = this.getInt("Laser Gun Energy consumed", "tools", 100, 0, Integer.MAX_VALUE, "How much energy is used, by default, per laser attack");
        String[] trash_things_arr = this.getStringList("Trash generation", "tweaks", new String[]{"20|coal", "5|slime_ball", "10|saddle", "5|tconstruct:edible;1", "1|emerald", "3|melon"}, "Objects that the Trash modifier will generate; enter in the format \"weight|modid:name;meta\" (leave meta blank for zero metadata)");
        int meta = 0;
        int weight = 0;
        for (i = 0; i < trash_things_arr.length; ++i) {
            Item it;
            String[] trash_wi = trash_things_arr[i].split("\\|");
            try {
                weight = Integer.parseInt(trash_wi[0]);
                if (weight < 0) {
                    throw new IllegalArgumentException("Weight must not be negative");
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            String[] loc_meta = trash_wi[1].split(";");
            if (loc_meta.length > 1) {
                try {
                    meta = Integer.parseInt(loc_meta[1]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if ((it = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(loc_meta[0]))) == null || weight <= 0) continue;
            trashThings.add(new TrashThing(weight, new ItemStack(it, 1, meta)));
        }
        String[] fruitStacksArr = this.getStringList("Fruits stack list", "tweaks", new String[]{"apple", "golden_apple;32767", "melon", "chorus_fruit"}, "Enter in the format \"modid:name;meta\" (leave meta blank for zero metadata)");
        int meta2 = 0;
        for (i = 0; i < fruitStacksArr.length; ++i) {
            Item it;
            String[] loc_meta = fruitStacksArr[i].split(";");
            if (loc_meta.length > 1) {
                try {
                    meta2 = Integer.parseInt(loc_meta[1]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if ((it = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(loc_meta[0]))) == null) continue;
            fruitStacks.add(new ItemStack(it, 1, meta2));
        }
        fruitOreDicts = (IntSet)Arrays.stream(this.getStringList("Fruits oredict list", "tweaks", new String[]{"cropApple", "listAllfruit"}, "Valid ore dictionary values for Fruit Salad")).mapToInt(OreDictionary::getOreID).collect(IntOpenHashSet::new, IntOpenHashSet::add, IntOpenHashSet::addAll);
        Property botan_amount_prop = this.get("tweaks", "Modifier values for Botanical", new int[0]);
        botan_amount_prop.setLanguageKey("Modifiers added for Botanical modifier");
        botan_amount_prop.setComment("Enter integer amounts, specifying the amount of modifiers added to the tool for each level, in increasing order of level (defaults will be extrapolated if some left blank)");
        botan_amount_prop.setMinValue(0);
        botan_amount.addElements(botan_amount.size(), botan_amount_prop.getIntList());
        if (botan_amount.isEmpty()) {
            botan_amount.add(1);
        }
        while (botan_amount.size() < 3) {
            botan_amount.add(botan_amount.getInt(botan_amount.size() - 1) << 1);
        }
        for (String blacklistEntry : this.getStringList("Centrifuge blacklist", "tweaks", new String[0], "Enter in the format inputFluid:outputFluid1;outputFluid2;outputFluid3")) {
            String[] separateInOut = blacklistEntry.split(":");
            blacklistedForCentrifuge.add((Pair<String, Set<String>>)Pair.of((Object)separateInOut[0], new HashSet<String>(Arrays.asList(separateInOut[1].split(";")))));
        }
        centrifugeEnergyPerMB = this.getInt("Centrifuge energy per mB", "tweaks", 5, 0, Integer.MAX_VALUE, "Energy consumed by centrifuge per millibucket");
        for (String traitLoadEntry : this.getStringList("Force load traits", "tweaks", new String[0], "Force-load these traits (as a fully-qualified class name; e.g. landmaster.plustic.traits.Global) without the required mods themselves being loaded")) {
            try {
                Class.forName(traitLoadEntry);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void init2(Map<String, Material> materials) {
        this.addCustomCategoryComment("materials", "Materials will only appear here when their respective modules are loaded.");
        Iterator<Material> it = materials.values().iterator();
        while (it.hasNext()) {
            Material mat = it.next();
            String matName = englishMap.func_74805_b(String.format("material.%s.name", mat.getIdentifier()));
            if (this.getBoolean(String.format("Enable material %s", mat.getIdentifier()), "materials", true, String.format("Set to false to prevent %s from being loaded", matName))) continue;
            it.remove();
        }
    }

    public void update() {
        if (this.hasChanged()) {
            this.save();
        }
    }

    public static boolean isCentrifugeRecipeValid(AlloyRecipe recipe) {
        Pair pairToCheck = Pair.of((Object)FluidRegistry.getFluidName((FluidStack)recipe.getResult()), recipe.getFluids().stream().map(FluidRegistry::getFluidName).collect(Collectors.toSet()));
        return !blacklistedForCentrifuge.contains(pairToCheck);
    }

    static {
        botan_amount = new IntArrayList(3);
        blacklistedForCentrifuge = new HashSet<Pair<String, Set<String>>>();
        trashThings = new ArrayList<TrashThing>();
        trashThingsSum = 0;
        fruitStacks = new ArrayList<ItemStack>();
        try {
            Method temp = LanguageMap.class.getDeclaredMethod("inject", LanguageMap.class, InputStream.class);
            temp.setAccessible(true);
            injectHandle = MethodHandles.lookup().unreflect(temp);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        englishMap = new LanguageMap();
        try {
            String[] langFiles;
            for (String langFile : langFiles = new String[]{"/assets/plustic/lang/en_us.lang", "/assets/plustic/lang/en_US.lang"}) {
                try (InputStream inS = Config.class.getResourceAsStream(langFile);){
                    injectHandle.invokeExact(englishMap, inS);
                }
            }
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static class TrashThing {
        public final int weight;
        public final ItemStack stack;

        public TrashThing(int weight, ItemStack stack) {
            this.weight = weight;
            this.stack = stack;
        }
    }
}

