/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.data.PMPDataPlantSpawnParams;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.PMPSpawnLocation;

public abstract class PMPGenVine
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData, PMPDataPlantSpawnParams params, PMPBlockPlant plant) {
        int posX = locationData.x;
        int posZ = locationData.z;
        PMPGenVine.spawnVine(world, random, locationData, PMPGenVine.getMetaDataPosition(locationData.spawnDirection), plant);
        for (int index = 0; index < params.clusterAmount; ++index) {
            locationData.x = posX + random.nextInt(params.clusterSize) - random.nextInt(params.clusterSize);
            locationData.z = posZ + random.nextInt(params.clusterSize) - random.nextInt(params.clusterSize);
            Block block = world.func_147439_a(locationData.x, locationData.y, locationData.z);
            if (block.func_149688_o() != Material.field_151584_j) continue;
            locationData.spawnDirection = PMPGenBase.isAdjacentToAirOrVineBlock(world, locationData.x, locationData.y, locationData.z);
            if (locationData.spawnDirection <= 0) continue;
            locationData.moveSpawnLocationToDirection(locationData.spawnDirection, 1);
            locationData.getBlockInfo(world);
            if (!world.func_147437_c(locationData.x, locationData.y, locationData.z)) continue;
            PMPGenVine.spawnVine(world, random, locationData, PMPGenVine.getMetaDataPosition(locationData.spawnDirection), plant);
        }
        return true;
    }

    private static int getMetaDataPosition(int spawnDirection) {
        int metaData = 0;
        if (spawnDirection == 2) {
            metaData = 1;
        } else if (spawnDirection == 3) {
            metaData = 4;
        } else if (spawnDirection == 4) {
            metaData = 8;
        } else if (spawnDirection == 5) {
            metaData = 2;
        }
        return metaData != 0 ? metaData : spawnDirection;
    }

    private static boolean spawnVine(World world, Random random, PMPSpawnLocation locationData, int metaData, PMPBlockPlant plant) {
        Block block;
        int height = 0;
        while ((block = world.func_147439_a(locationData.x, locationData.y - ++height, locationData.z)).func_149688_o() == Material.field_151579_a) {
        }
        for (int actualHeight = locationData.y - random.nextInt(Math.max(1, height)); actualHeight <= locationData.y; ++actualHeight) {
            world.func_147465_d(locationData.x, actualHeight, locationData.z, (Block)plant, metaData, 3);
        }
        return true;
    }
}

