/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import plantmegapack.PlantMegaPack;
import plantmegapack.block.PMPBlockHangingPlant;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.block.PMPBlockWallBracket;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.PMPSpawnLocation;

public abstract class PMPGenVillagePlant
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (!PlantMegaPack.settings.worldgenVillagePlants) {
            return false;
        }
        if (locationData.spawnDirection == 2) {
            locationData.spawnDirection = 3;
        } else if (locationData.spawnDirection == 3) {
            locationData.spawnDirection = 2;
        } else if (locationData.spawnDirection == 4) {
            locationData.spawnDirection = 5;
        } else if (locationData.spawnDirection == 5) {
            locationData.spawnDirection = 4;
        } else {
            return false;
        }
        if (locationData.spawnDirection == 2 || locationData.spawnDirection == 3) {
            PMPGenVillagePlant.scanWestEast(world, random, locationData);
        } else {
            PMPGenVillagePlant.scanNorthSouth(world, random, locationData);
        }
        return true;
    }

    private static void scanWestEast(World world, Random random, PMPSpawnLocation locationData) {
        Block block;
        int maxScan;
        int ix = locationData.x;
        int iy = locationData.y;
        int iz = locationData.z;
        boolean cornerDetected = false;
        for (maxScan = 0; !cornerDetected && maxScan < 16; ++maxScan) {
            if (locationData.spawnDirection == 2 && ((block = world.func_147439_a(ix - 1, iy, iz + 1)).func_149688_o() == Material.field_151579_a || block.getClass() == PMPBlockWallBracket.class)) {
                cornerDetected = true;
                if (!PMPGenVillagePlant.spawnHangingPlant(world, random, ix, iy, iz, locationData.spawnDirection)) {
                    PMPGenVillagePlant.spawnGroundPlant(world, random, locationData);
                }
            }
            if (locationData.spawnDirection == 3 && ((block = world.func_147439_a(ix - 1, iy, iz - 1)).func_149688_o() == Material.field_151579_a || block.getClass() == PMPBlockWallBracket.class)) {
                cornerDetected = true;
                if (!PMPGenVillagePlant.spawnHangingPlant(world, random, ix, iy, iz, locationData.spawnDirection)) {
                    PMPGenVillagePlant.spawnGroundPlant(world, random, locationData);
                }
            }
            --ix;
        }
        ix = locationData.x;
        iy = locationData.y;
        iz = locationData.z;
        cornerDetected = false;
        for (maxScan = 0; !cornerDetected && maxScan < 16; ++maxScan) {
            if (locationData.spawnDirection == 2 && ((block = world.func_147439_a(ix + 1, iy, iz + 1)).func_149688_o() == Material.field_151579_a || block.getClass() == PMPBlockWallBracket.class)) {
                cornerDetected = true;
                if (!PMPGenVillagePlant.spawnHangingPlant(world, random, ix, iy, iz, locationData.spawnDirection)) {
                    PMPGenVillagePlant.spawnGroundPlant(world, random, locationData);
                }
            }
            if (locationData.spawnDirection == 3 && ((block = world.func_147439_a(ix + 1, iy, iz - 1)).func_149688_o() == Material.field_151579_a || block.getClass() == PMPBlockWallBracket.class)) {
                cornerDetected = true;
                if (!PMPGenVillagePlant.spawnHangingPlant(world, random, ix, iy, iz, locationData.spawnDirection)) {
                    PMPGenVillagePlant.spawnGroundPlant(world, random, locationData);
                }
            }
            ++ix;
        }
    }

    private static void scanNorthSouth(World world, Random random, PMPSpawnLocation locationData) {
        Block block;
        int maxScan;
        int ix = locationData.x;
        int iy = locationData.y;
        int iz = locationData.z;
        boolean cornerDetected = false;
        for (maxScan = 0; !cornerDetected && maxScan < 16; ++maxScan) {
            if (locationData.spawnDirection == 4 && ((block = world.func_147439_a(ix + 1, iy, iz - 1)).func_149688_o() == Material.field_151579_a || block.getClass() == PMPBlockWallBracket.class)) {
                cornerDetected = true;
                if (!PMPGenVillagePlant.spawnHangingPlant(world, random, ix, iy, iz, locationData.spawnDirection)) {
                    PMPGenVillagePlant.spawnGroundPlant(world, random, locationData);
                }
            }
            if (locationData.spawnDirection == 5 && ((block = world.func_147439_a(ix - 1, iy, iz - 1)).func_149688_o() == Material.field_151579_a || block.getClass() == PMPBlockWallBracket.class)) {
                cornerDetected = true;
                if (!PMPGenVillagePlant.spawnHangingPlant(world, random, ix, iy, iz, locationData.spawnDirection)) {
                    PMPGenVillagePlant.spawnGroundPlant(world, random, locationData);
                }
            }
            --iz;
        }
        ix = locationData.x;
        iy = locationData.y;
        iz = locationData.z;
        cornerDetected = false;
        for (maxScan = 0; !cornerDetected && maxScan < 16; ++maxScan) {
            if (locationData.spawnDirection == 4 && ((block = world.func_147439_a(ix + 1, iy, iz + 1)).func_149688_o() == Material.field_151579_a || block.getClass() == PMPBlockWallBracket.class)) {
                cornerDetected = true;
                if (!PMPGenVillagePlant.spawnHangingPlant(world, random, ix, iy, iz, locationData.spawnDirection)) {
                    PMPGenVillagePlant.spawnGroundPlant(world, random, locationData);
                }
            }
            if (locationData.spawnDirection == 5 && ((block = world.func_147439_a(ix - 1, iy, iz + 1)).func_149688_o() == Material.field_151579_a || block.getClass() == PMPBlockWallBracket.class)) {
                cornerDetected = true;
                if (!PMPGenVillagePlant.spawnHangingPlant(world, random, ix, iy, iz, locationData.spawnDirection)) {
                    PMPGenVillagePlant.spawnGroundPlant(world, random, locationData);
                }
            }
            ++iz;
        }
    }

    private static boolean spawnHangingPlant(World world, Random random, int x, int y, int z, int direction) {
        Block block = world.func_147439_a(x, y, z);
        if (block.func_149688_o() != Material.field_151579_a) {
            return false;
        }
        block = world.func_147439_a(x, y - 1, z);
        if (block.func_149688_o() != Material.field_151579_a) {
            return false;
        }
        block = world.func_147439_a(x, y - 2, z);
        if (block.func_149688_o() != Material.field_151579_a) {
            return false;
        }
        int distribution = random.nextInt(100);
        world.func_147465_d(x, y, z, (Block)PlantMegaPack.blocks.getWallBracketBlock("wallBracketWoodOak"), direction, 3);
        if (distribution < 5) {
            world.func_147465_d(x, y - 1, z, (Block)PMPGenVillagePlant.getRandomHangingBamboo(random), 0, 3);
        } else if (distribution < 15) {
            world.func_147465_d(x, y - 1, z, (Block)PMPGenVillagePlant.getRandomHangingPlant(random), 0, 3);
        } else if (distribution < 35) {
            world.func_147465_d(x, y - 1, z, (Block)PMPGenVillagePlant.getRandomHangingFoliage(random), 0, 3);
        } else {
            world.func_147465_d(x, y - 1, z, (Block)PMPGenVillagePlant.getRandomHangingFlower(random), 0, 3);
        }
        return true;
    }

    private static void spawnGroundPlant(World world, Random random, PMPSpawnLocation locationData) {
        Block block;
        int ix = locationData.x;
        int iy = locationData.y;
        int iz = locationData.z;
        boolean soilBlockFound = false;
        for (int maxScan = 0; !soilBlockFound && maxScan < 10; ++maxScan) {
            block = world.func_147439_a(ix, iy - 1, iz);
            if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151585_k) {
                --iy;
                continue;
            }
            soilBlockFound = true;
        }
        block = world.func_147439_a(ix, iy, iz);
        if (block.getClass() == PMPBlockHangingPlant.class || block.canSustainPlant((IBlockAccess)world, ix, iy, iz, ForgeDirection.UP, (IPlantable)PlantMegaPack.blocks.getPlantBlock("flowerRose"))) {
            // empty if block
        }
        PMPGenVillagePlant.spawnGardenPlant(world, random, ix, iy, iz, locationData.biome);
    }

    private static void spawnGardenPlant(World world, Random random, int x, int y, int z, BiomeGenBase biome) {
        PMPBlockPlant gardenPlant = PlantMegaPack.blocks.getPlantBlock("flowerRose");
        BlockGrass soilBlock = Blocks.field_150349_c;
        int metaData = random.nextInt(gardenPlant.getSubBlocksCount());
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            gardenPlant = PlantMegaPack.blocks.getPlantBlock("flowerTulip");
            metaData = random.nextInt(gardenPlant.getSubBlocksCount());
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            soilBlock = Blocks.field_150354_m;
            gardenPlant = PlantMegaPack.blocks.getPlantBlock("desertKangarooPaw");
            metaData = 0;
        }
        world.func_147465_d(x, y - 1, z, (Block)soilBlock, metaData, 3);
        world.func_147465_d(x, y, z, (Block)gardenPlant, metaData, 3);
    }

    private static PMPBlockHangingPlant getRandomHangingBamboo(Random random) {
        String name = "";
        switch (random.nextInt(8)) {
            case 0: {
                name = "hangingBambooAsper";
                break;
            }
            case 1: {
                name = "hangingBambooFargesiaRobusta";
                break;
            }
            case 2: {
                name = "hangingBambooGiantTimber";
                break;
            }
            case 3: {
                name = "hangingBambooGolden";
                break;
            }
            case 4: {
                name = "hangingBambooMoso";
                break;
            }
            case 5: {
                name = "hangingBambooShortTassled";
                break;
            }
            case 6: {
                name = "hangingBambooTimorBlack";
                break;
            }
            case 7: {
                name = "hangingBambooTropicalBlue";
                break;
            }
            case 8: {
                name = "hangingBambooWetForest";
                break;
            }
        }
        return PlantMegaPack.blocks.getHangingPlantBlock(name);
    }

    private static PMPBlockHangingPlant getRandomHangingFlower(Random random) {
        String name = "";
        switch (random.nextInt(13)) {
            case 0: {
                name = "hangingFlowersMIX";
                break;
            }
            case 1: {
                name = "hangingFlowersRED";
                break;
            }
            case 2: {
                name = "hangingFlowersCOR";
                break;
            }
            case 3: {
                name = "hangingFlowersORA";
                break;
            }
            case 4: {
                name = "hangingFlowersYEL";
                break;
            }
            case 5: {
                name = "hangingFlowersGRN";
                break;
            }
            case 6: {
                name = "hangingFlowersCYA";
                break;
            }
            case 7: {
                name = "hangingFlowersBLU";
                break;
            }
            case 8: {
                name = "hangingFlowersROY";
                break;
            }
            case 9: {
                name = "hangingFlowersPUR";
                break;
            }
            case 10: {
                name = "hangingFlowersMAG";
                break;
            }
            case 11: {
                name = "hangingFlowersPNK";
                break;
            }
            case 12: {
                name = "hangingFlowersWHT";
                break;
            }
        }
        return PlantMegaPack.blocks.getHangingPlantBlock(name);
    }

    private static PMPBlockHangingPlant getRandomHangingFoliage(Random random) {
        String name = "";
        switch (random.nextInt(5)) {
            case 0: {
                name = "hangingFoliageSMGRN";
                break;
            }
            case 1: {
                name = "hangingFoliageMDGRN";
                break;
            }
            case 2: {
                name = "hangingFoliageLGGRN";
                break;
            }
            case 3: {
                name = "hangingFoliageLGYEL";
                break;
            }
            case 4: {
                name = "hangingFoliageLGRED";
                break;
            }
        }
        return PlantMegaPack.blocks.getHangingPlantBlock(name);
    }

    private static PMPBlockHangingPlant getRandomHangingPlant(Random random) {
        String name = "";
        switch (random.nextInt(9)) {
            case 0: {
                name = "hangingBlueWheatgrass";
                break;
            }
            case 1: {
                name = "hangingBrittlebush";
                break;
            }
            case 2: {
                name = "hangingKrisPlant";
                break;
            }
            case 3: {
                name = "hangingLavender";
                break;
            }
            case 4: {
                name = "hangingPricklyPear";
                break;
            }
            case 5: {
                name = "hangingScalyTree";
                break;
            }
            case 6: {
                name = "hangingPhilodendron";
                break;
            }
            case 7: {
                name = "hangingWildfire";
                break;
            }
            case 8: {
                name = "hangingWolfWillow";
                break;
            }
        }
        return PlantMegaPack.blocks.getHangingPlantBlock(name);
    }
}

