/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.PlantMegaPack;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.common.PMPPlantCategory;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.PMPSpawnLocation;

public abstract class PMPGenVillageCrop
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (!PlantMegaPack.settings.worldgenVillageCrops) {
            return false;
        }
        PMPGenVillageCrop.spawnCropRow(world, random, locationData);
        return true;
    }

    private static void spawnCropRow(World world, Random random, PMPSpawnLocation locationData) {
        block8: {
            int maxScan;
            int direction;
            PMPBlockPlant blockCrop;
            block7: {
                int maxScan2;
                ArrayList<PMPBlockPlant> cropsList = PlantMegaPack.blocks.getPlantBlockList(PMPPlantCategory.CROP_LAND);
                if (cropsList == null || cropsList.size() == 0) {
                    return;
                }
                int index = random.nextInt(cropsList.size());
                blockCrop = cropsList.get(index);
                if (blockCrop == null) {
                    return;
                }
                world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)blockCrop, 0, 3);
                direction = PMPGenVillageCrop.getRowDirection(world, locationData);
                if (direction == 0) {
                    return;
                }
                if (direction != 1) break block7;
                int x = locationData.x;
                int z = locationData.z - 1;
                for (maxScan2 = 0; world.func_147439_a(x, locationData.y, z) == Blocks.field_150464_aj && maxScan2 < 10; ++maxScan2) {
                    world.func_147465_d(x, locationData.y, z, (Block)blockCrop, 0, 3);
                    --z;
                }
                z = locationData.z + 1;
                for (maxScan2 = 0; world.func_147439_a(x, locationData.y, z) == Blocks.field_150464_aj && maxScan2 < 10; ++maxScan2) {
                    world.func_147465_d(x, locationData.y, z, (Block)blockCrop, 0, 3);
                    ++z;
                }
                break block8;
            }
            if (direction != 2) break block8;
            int x = locationData.x - 1;
            int z = locationData.z;
            for (maxScan = 0; world.func_147439_a(x, locationData.y, z) == Blocks.field_150464_aj && maxScan < 10; ++maxScan) {
                world.func_147465_d(x, locationData.y, z, (Block)blockCrop, 0, 3);
                --x;
            }
            x = locationData.x + 1;
            z = locationData.z;
            for (maxScan = 0; world.func_147439_a(x, locationData.y, z) == Blocks.field_150464_aj && maxScan < 10; ++maxScan) {
                world.func_147465_d(x, locationData.y, z, (Block)blockCrop, 0, 3);
                ++x;
            }
        }
    }

    private static int getRowDirection(World world, PMPSpawnLocation locationData) {
        int north = 0;
        int south = 0;
        int west = 0;
        int east = 0;
        if (world.func_147439_a(locationData.x, locationData.y, locationData.z - 1) == Blocks.field_150464_aj) {
            ++north;
            if (world.func_147439_a(locationData.x, locationData.y, locationData.z - 2) == Blocks.field_150464_aj) {
                ++north;
            }
        }
        if (world.func_147439_a(locationData.x, locationData.y, locationData.z + 1) == Blocks.field_150464_aj) {
            ++south;
            if (world.func_147439_a(locationData.x, locationData.y, locationData.z + 2) == Blocks.field_150464_aj) {
                ++south;
            }
        }
        if (world.func_147439_a(locationData.x - 1, locationData.y, locationData.z) == Blocks.field_150464_aj) {
            ++west;
            if (world.func_147439_a(locationData.x - 2, locationData.y, locationData.z) == Blocks.field_150464_aj) {
                ++west;
            }
        }
        if (world.func_147439_a(locationData.x + 1, locationData.y, locationData.z) == Blocks.field_150464_aj) {
            ++east;
            if (world.func_147439_a(locationData.x + 2, locationData.y, locationData.z) == Blocks.field_150464_aj) {
                ++east;
            }
        }
        if (north > 1 || south > 1) {
            return 1;
        }
        if (west > 1 || east > 1) {
            return 2;
        }
        return 0;
    }
}

