/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import plantmegapack.PlantMegaPack;
import plantmegapack.block.PMPBlockBambooStairs;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.common.PMPDecorator;
import plantmegapack.common.PMPDecoratorArea;
import plantmegapack.common.PMPDecoratorType;
import plantmegapack.common.PMPPlantCategory;
import plantmegapack.common.PMPPlantGrowthType;
import plantmegapack.common.PMPPlantRenderType;
import plantmegapack.common.PMPPlantSoilType;
import plantmegapack.data.PMPDataPlantSpawnParams;
import plantmegapack.worldgen.PMPGenAquatic;
import plantmegapack.worldgen.PMPGenEpiphyte;
import plantmegapack.worldgen.PMPGenVillageCrop;
import plantmegapack.worldgen.PMPGenVine;
import plantmegapack.worldgen.PMPSpawnLocation;

public abstract class PMPGenBase {
    public static boolean spawnPlantCluster(World world, Random random, PMPSpawnLocation locationData, PMPDataPlantSpawnParams params) {
        if (world == null || random == null || locationData == null || params == null) {
            return false;
        }
        if (!PlantMegaPack.settings.contentAquatic && locationData.decorator.decoratorType == PMPDecoratorType.WATER) {
            return false;
        }
        int posX = locationData.x;
        int posY = locationData.y;
        int posZ = locationData.z;
        PMPBlockPlant plant = PlantMegaPack.blocks.getPlantBlock(params.plantName);
        if (plant == null) {
            return false;
        }
        if (locationData.decoratorArea == PMPDecoratorArea.EPIPHYTE) {
            return PMPGenEpiphyte.generate(world, random, locationData, params, plant);
        }
        if (locationData.decoratorArea == PMPDecoratorArea.VINE) {
            return PMPGenVine.generate(world, random, locationData, params, plant);
        }
        if (plant.plantData.attributes.growthType == PMPPlantGrowthType.SEAWEED) {
            return PMPGenAquatic.spawnRandomSeaweedCluster(world, random, locationData, plant, params.clusterSize, params.clusterAmount);
        }
        if (locationData.decoratorArea == PMPDecoratorArea.WATER_SUBMERGED || locationData.decoratorArea == PMPDecoratorArea.WATER_IMMERSED) {
            return PMPGenAquatic.spawnWaterPlantCluster(world, random, locationData, plant, params);
        }
        for (int index = 0; index < params.clusterAmount; ++index) {
            int count;
            locationData.x = posX + random.nextInt(params.clusterSize) - random.nextInt(params.clusterSize);
            locationData.y = posY;
            locationData.z = posZ + random.nextInt(params.clusterSize) - random.nextInt(params.clusterSize);
            locationData.getBlockInfo(world);
            boolean spawnPlant = false;
            if (locationData.blockBelow.getClass() == PMPBlockPlant.class || locationData.blockSpawn.getClass() == PMPBlockPlant.class || locationData.blockAbove.getClass() == PMPBlockPlant.class) break;
            if (plant.func_149742_c(world, locationData.x, locationData.y, locationData.z)) {
                spawnPlant = true;
            } else if (PMPGenBase.canReplaceBlockWithPlant(locationData.blockBelow, true)) {
                for (count = 0; count < params.elevationVariance && PMPGenBase.canReplaceBlockWithPlant(locationData.blockBelow, true); ++count) {
                    --locationData.y;
                    locationData.getBlockInfo(world);
                    if (!plant.func_149742_c(world, locationData.x, locationData.y, locationData.z)) continue;
                    spawnPlant = true;
                    break;
                }
            } else if (!PMPGenBase.canReplaceBlockWithPlant(locationData.blockSpawn, true)) {
                for (count = 0; count < params.elevationVariance && !PMPGenBase.canReplaceBlockWithPlant(locationData.blockAbove, true); ++count) {
                    ++locationData.y;
                    locationData.getBlockInfo(world);
                    if (!plant.func_149742_c(world, locationData.x, locationData.y, locationData.z)) continue;
                    spawnPlant = true;
                    break;
                }
            }
            if (!spawnPlant) continue;
            PMPGenBase.spawnPlant(world, random, locationData, params, plant);
        }
        return true;
    }

    public static boolean spawnPlant(World world, Random random, PMPSpawnLocation locationData, PMPDataPlantSpawnParams params, PMPBlockPlant plant) {
        block15: {
            int metaData;
            block14: {
                if (locationData == null || params == null || plant == null || !plant.func_149742_c(world, locationData.x, locationData.y, locationData.z)) {
                    return false;
                }
                metaData = 0;
                Block block = world.func_147439_a(locationData.x, locationData.y, locationData.z);
                if (block == Blocks.field_150464_aj) {
                    return PMPGenVillageCrop.generate(world, random, locationData);
                }
                if (plant.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
                    return PMPGenBase.spawnRandomBambooPlantCluster(world, random, locationData.x, locationData.y, locationData.z, (Block)plant, params.clusterSize, params.clusterAmount, params.overwriteVanilla);
                }
                if (plant.plantData.attributes.renderType == PMPPlantRenderType.FLOATING_FLOWER || plant.plantData.attributes.category == PMPPlantCategory.FLOWER_MULTI) {
                    metaData = random.nextInt(plant.getSubBlocksCount());
                    world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, metaData, 3);
                    return true;
                }
                if (plant.plantData.attributes.renderType == PMPPlantRenderType.FLAT) {
                    metaData = random.nextInt(8);
                    world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, metaData, 3);
                    return true;
                }
                metaData = (PlantMegaPack.settings.worldgenSpawnAtFullGrowth ? plant.plantData.attributes.growthStages - 1 : random.nextInt(plant.plantData.attributes.growthStages)) - 1;
                if (plant.plantData.attributes.growthType != PMPPlantGrowthType.DOUBLE) break block14;
                if (metaData > 1 && world.func_147439_a(locationData.x, locationData.y + 1, locationData.z).func_149688_o() != Material.field_151579_a) {
                    metaData = 0;
                }
                if (plant.isImmersedPlant()) break block15;
                switch (metaData) {
                    case 0: {
                        world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, 0, 3);
                        break block15;
                    }
                    case 1: {
                        world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, 1, 3);
                        break block15;
                    }
                    case 2: {
                        world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, 2, 3);
                        world.func_147465_d(locationData.x, locationData.y + 1, locationData.z, (Block)plant, 3, 3);
                        break block15;
                    }
                    case 3: {
                        world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, 4, 3);
                        world.func_147465_d(locationData.x, locationData.y + 1, locationData.z, (Block)plant, 5, 3);
                        break block15;
                    }
                    case 4: {
                        world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, 6, 3);
                        world.func_147465_d(locationData.x, locationData.y + 1, locationData.z, (Block)plant, 7, 3);
                        break block15;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (metaData < 0 || metaData > 15) {
                metaData = 0;
            }
            world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, metaData, 3);
        }
        return true;
    }

    public static int isStairBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return 0;
        }
        if (block == Blocks.field_150400_ck || block == Blocks.field_150487_bG || block == Blocks.field_150401_cl || block == Blocks.field_150481_bH || block == Blocks.field_150476_ad || block == Blocks.field_150485_bF || block == Blocks.field_150372_bz || block == Blocks.field_150446_ar || block.getClass() == BlockStairs.class || block.getClass() == PMPBlockBambooStairs.class) {
            switch (world.func_72805_g(x, y, z)) {
                case 0: {
                    return 5;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 2;
                }
            }
        }
        return 0;
    }

    public static boolean isAdjacentToBlock(World world, int x, int y, int z, Block block) {
        return world.func_147439_a(x - 1, y, z) == block || world.func_147439_a(x - 1, y, z - 1) == block || world.func_147439_a(x - 1, y, z + 1) == block || world.func_147439_a(x, y, z - 1) == block || world.func_147439_a(x, y, z + 1) == block || world.func_147439_a(x + 1, y, z) == block || world.func_147439_a(x + 1, y, z - 1) == block || world.func_147439_a(x + 1, y, z + 1) == block;
    }

    public static boolean isAdjacentToBlockFull(World world, int x, int y, int z, Block block) {
        return world.func_147439_a(x - 2, y, z - 2) == block || world.func_147439_a(x - 1, y, z - 2) == block || world.func_147439_a(x, y, z - 2) == block || world.func_147439_a(x + 1, y, z - 2) == block || world.func_147439_a(x + 2, y, z - 2) == block || world.func_147439_a(x - 2, y, z - 1) == block || world.func_147439_a(x - 2, y, z) == block || world.func_147439_a(x - 2, y, z + 1) == block || world.func_147439_a(x - 2, y, z + 2) == block || world.func_147439_a(x - 1, y, z + 2) == block || world.func_147439_a(x, y, z + 2) == block || world.func_147439_a(x + 1, y, z + 2) == block || world.func_147439_a(x + 2, y, z + 2) == block || world.func_147439_a(x + 2, y, z + 2) == block || world.func_147439_a(x + 2, y, z + 1) == block || world.func_147439_a(x + 2, y, z) == block || world.func_147439_a(x + 2, y, z - 1) == block;
    }

    public static int isAdjacentToBlockMaterial(World world, int x, int y, int z, Material material) {
        Block block = world.func_147439_a(x, y, z + 1);
        if (block.func_149688_o() == material) {
            return 3;
        }
        block = world.func_147439_a(x + 1, y, z + 1);
        if (block.func_149688_o() == material) {
            return 9;
        }
        block = world.func_147439_a(x + 1, y, z);
        if (block.func_149688_o() == material) {
            return 5;
        }
        block = world.func_147439_a(x + 1, y, z - 1);
        if (block.func_149688_o() == material) {
            return 7;
        }
        block = world.func_147439_a(x, y, z - 1);
        if (block.func_149688_o() == material) {
            return 2;
        }
        block = world.func_147439_a(x - 1, y, z - 1);
        if (block.func_149688_o() == material) {
            return 6;
        }
        block = world.func_147439_a(x - 1, y, z);
        if (block.func_149688_o() == material) {
            return 4;
        }
        block = world.func_147439_a(x - 1, y, z + 1);
        if (block.func_149688_o() == material) {
            return 8;
        }
        return 0;
    }

    public static int isAdjacentToLogBlock(World world, int x, int y, int z, boolean checkDiagonals) {
        if (PMPGenBase.isLogBlock(world, x, y, z + 1)) {
            return 3;
        }
        if (PMPGenBase.isLogBlock(world, x + 1, y, z)) {
            return 5;
        }
        if (PMPGenBase.isLogBlock(world, x, y, z - 1)) {
            return 2;
        }
        if (PMPGenBase.isLogBlock(world, x - 1, y, z)) {
            return 4;
        }
        if (checkDiagonals) {
            if (PMPGenBase.isLogBlock(world, x + 1, y, z + 1)) {
                return 9;
            }
            if (PMPGenBase.isLogBlock(world, x + 1, y, z - 1)) {
                return 7;
            }
            if (PMPGenBase.isLogBlock(world, x - 1, y, z - 1)) {
                return 6;
            }
            if (PMPGenBase.isLogBlock(world, x - 1, y, z + 1)) {
                return 8;
            }
        }
        return 0;
    }

    public static boolean isLogBlock(Block block) {
        return PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block);
    }

    public static boolean isLogBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return PMPGenBase.isLogBlock(block);
    }

    public static boolean isSurroundedByBlock(World world, int x, int y, int z, Block block) {
        return world.func_147439_a(x - 1, y, z) == block && world.func_147439_a(x - 1, y, z - 1) == block && world.func_147439_a(x - 1, y, z + 1) == block && world.func_147439_a(x, y, z - 1) == block && world.func_147439_a(x, y, z + 1) == block && world.func_147439_a(x + 1, y, z) == block && world.func_147439_a(x + 1, y, z - 1) == block && world.func_147439_a(x + 1, y, z + 1) == block;
    }

    public static boolean isVanillaPlant(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        String name = block.func_149739_a().substring(5);
        return name.matches("tallgrass") || name.matches("deadbush") || name.matches("yellow_flower") || name.matches("red_flower") || name.matches("brown_mushroom") || name.matches("red_mushroom") || name.matches("cactus") || name.matches("reeds") || name.matches("double_plant");
    }

    public static boolean isAdjacentToDifferentBiome(BiomeGenBase biome, World world, int x, int y, int z) {
        BiomeGenBase biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z - 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z + 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x, z - 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x, z + 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z - 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z + 1);
        return biome != biomeCompare;
    }

    public static BiomeGenBase checkForNearDifferentBiome(BiomeGenBase biome, World world, int x, int y, int z) {
        BiomeGenBase biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z - 2);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z - 2);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 2, z - 1);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 2, z - 1);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 2, z + 1);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 2, z + 1);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z + 2);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z + 2);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        return null;
    }

    public static int isAdjacentToAirBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z - 1);
        if (block.func_149688_o() == Material.field_151579_a) {
            return 2;
        }
        block = world.func_147439_a(x - 1, y, z);
        if (block.func_149688_o() == Material.field_151579_a) {
            return 4;
        }
        block = world.func_147439_a(x + 1, y, z);
        if (block.func_149688_o() == Material.field_151579_a) {
            return 5;
        }
        block = world.func_147439_a(x, y, z + 1);
        if (block.func_149688_o() == Material.field_151579_a) {
            return 3;
        }
        return 0;
    }

    public static int isAdjacentToAirOrLeafBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z - 1);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j) {
            return 2;
        }
        block = world.func_147439_a(x - 1, y, z);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j) {
            return 4;
        }
        block = world.func_147439_a(x + 1, y, z);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j) {
            return 5;
        }
        block = world.func_147439_a(x, y, z + 1);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j) {
            return 3;
        }
        return 0;
    }

    public static int isAdjacentToPlantSpawnBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z - 1);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151585_k) {
            return 2;
        }
        block = world.func_147439_a(x - 1, y, z);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151585_k) {
            return 4;
        }
        block = world.func_147439_a(x + 1, y, z);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151585_k) {
            return 5;
        }
        block = world.func_147439_a(x, y, z + 1);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151585_k) {
            return 3;
        }
        return 0;
    }

    public static int isAdjacentToAirOrVineBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z - 1);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151582_l) {
            return 2;
        }
        block = world.func_147439_a(x - 1, y, z);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151582_l) {
            return 4;
        }
        block = world.func_147439_a(x + 1, y, z);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151582_l) {
            return 5;
        }
        block = world.func_147439_a(x, y, z + 1);
        if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151582_l) {
            return 3;
        }
        return 0;
    }

    public static void surroundPlantWithGrass(World world, int x, int y, int z) {
        int ix = x - 1;
        int iy = y;
        int iz = z - 1;
        if (Blocks.field_150329_H.func_149742_c(world, ix, iy, iz)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x, iy, iz = z - 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x + 1, iy, iz = z - 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x - 1, iy, iz = z)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x + 1, iy, iz = z)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x - 1, iy, iz = z + 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x, iy, iz = z + 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x + 1, iy, iz = z + 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
    }

    public static boolean checkAndAdjustSpawnForBlock(World world, PMPSpawnLocation locationData, Block block, int heightModifier) {
        int ix = locationData.x - 1;
        int iy = locationData.y + heightModifier;
        int iz = locationData.z - 1;
        Block blockPotential = world.func_147439_a(ix, iy, iz);
        boolean blockFound = false;
        boolean bl = blockFound = block == blockPotential;
        if (!blockFound) {
            ix = locationData.x;
            iz = locationData.z - 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl2 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x + 1;
            iz = locationData.z - 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl3 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x - 1;
            iz = locationData.z;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl4 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x + 1;
            iz = locationData.z;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl5 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x - 1;
            iz = locationData.z + 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl6 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x;
            iz = locationData.z + 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl7 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x + 1;
            iz = locationData.z + 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl8 = blockFound = block == blockPotential;
        }
        if (blockFound) {
            locationData.x = ix;
            locationData.y = iy;
            locationData.z = iz;
            return true;
        }
        return false;
    }

    public static boolean isGroundBlock(World world, int x, int y, int z) {
        return PMPGenBase.isGroundBlock(world.func_147439_a(x, y, z));
    }

    public static boolean isGroundBlock(Block block) {
        if (block == null) {
            return false;
        }
        return block.func_149688_o() == Material.field_151571_B || block.func_149688_o() == Material.field_151577_b || block.func_149688_o() == Material.field_151578_c || block.func_149688_o() == Material.field_151576_e || block.func_149688_o() == Material.field_151595_p || block == Blocks.field_150351_n || block == Blocks.field_150348_b;
    }

    public static boolean isLargeMushroomBlock(World world, int x, int y, int z) {
        return PMPGenBase.isLargeMushroomBlock(world.func_147439_a(x, y, z));
    }

    public static boolean isLargeMushroomBlock(Block block) {
        return block == Blocks.field_150420_aW || block == Blocks.field_150419_aX;
    }

    public static boolean isLeafBlock(Block block) {
        return block.func_149688_o() == Material.field_151584_j || block == Blocks.field_150362_t || block == Blocks.field_150361_u;
    }

    public static boolean isLeafBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return PMPGenBase.isLeafBlock(block);
    }

    private static boolean spawnBamboo(World world, Random random, int x, int y, int z, Block block) {
        PMPBlockPlant blockBamboo = (PMPBlockPlant)block;
        if (blockBamboo == null) {
            return false;
        }
        int spawnHeight = random.nextInt(blockBamboo.plantData.attributes.growthMax);
        for (int count = 0; count < spawnHeight; ++count) {
            if (PMPGenBase.canReplaceBlockWithPlant(world, x, y + count, z, true) && PMPGenBase.canReplaceBlockWithPlant(world, x, y + count + 1, z, true)) {
                if (blockBamboo.plantData.attributes.renderSubtype == 2) {
                    if (count == 0) {
                        world.func_147465_d(x, y + count, z, (Block)blockBamboo, 0, 2);
                        continue;
                    }
                    world.func_147465_d(x, y + count, z, (Block)blockBamboo, 1 + random.nextInt(3), 2);
                    continue;
                }
                world.func_147465_d(x, y + count, z, (Block)blockBamboo, 0, 2);
                continue;
            }
            spawnHeight = count;
        }
        world.func_147465_d(x, y + spawnHeight, z, (Block)blockBamboo, 4, 2);
        blockBamboo.updateBambooFromTop(world, x, y + spawnHeight, z);
        return true;
    }

    public static boolean spawnRandomBambooPlantCluster(World world, Random random, int x, int y, int z, Block block, int range, int maxPlants, boolean overWriteVanilla) {
        for (int count = 0; count < maxPlants; ++count) {
            int iz;
            int iy;
            int ix = x + random.nextInt(range) - random.nextInt(range);
            if (PMPGenBase.isLeafBlock(world, ix, (iy = world.func_72976_f(ix, iz = z + random.nextInt(range) - random.nextInt(range))) - 1, iz)) {
                iy = PMPGenBase.adjustHeightForLeaf(world, random, ix, iy, iz);
            }
            Block blockSoil = world.func_147439_a(ix, iy - 1, iz);
            if (!PMPGenBase.canReplaceBlockWithPlant(world, ix, iy, iz, true) || !PMPGenBase.canReplaceBlockWithPlant(world, ix, iy + 1, iz, true) || !PMPGenBase.isGroundBlock(blockSoil)) continue;
            PMPGenBase.spawnBamboo(world, random, ix, iy, iz, block);
        }
        return true;
    }

    public static int adjustHeightForLeaf(World world, Random random, int x, int y, int z) {
        boolean canContinueDown = true;
        do {
            Block block = world.func_147439_a(x, --y - 1, z);
            if (!PMPGenBase.isGroundBlock(world, x, y - 1, z) && (block == null || block.func_149688_o() != Material.field_151586_h)) continue;
            canContinueDown = false;
        } while (canContinueDown && y > 0);
        return y;
    }

    public static int adjustHeightForLargeMushroom(World world, Random random, int x, int y, int z) {
        boolean canContinueDown = true;
        do {
            if (!PMPGenBase.isGroundBlock(world, x, --y - 1, z)) continue;
            canContinueDown = false;
        } while (canContinueDown && y > 0);
        return y;
    }

    public static boolean canReplaceBlockWithPlant(Block block, boolean includeLeaves) {
        if (block == null) {
            return false;
        }
        if (includeLeaves && PMPGenBase.isLeafBlock(block)) {
            return true;
        }
        return block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151597_y || block.func_149688_o() == Material.field_151582_l || block == Blocks.field_150329_H || block == Blocks.field_150398_cm || block == Blocks.field_150328_O || block == Blocks.field_150327_N || block == Blocks.field_150330_I;
    }

    public static boolean canReplaceBlockWithPlant(World world, int x, int y, int z, boolean includeLeaves) {
        Block block = world.func_147439_a(x, y, z);
        return PMPGenBase.canReplaceBlockWithPlant(block, includeLeaves);
    }

    protected static void spawnWool(World world, PMPSpawnLocation locationData) {
        int color = 15;
        if (locationData.decorator == PMPDecorator.FEATURES) {
            switch (locationData.decoratorFeature) {
                case VILLAGE_CROP: {
                    color = 12;
                    break;
                }
                case VILLAGE_PLANT: {
                    color = 8;
                    break;
                }
            }
        } else {
            switch (locationData.decoratorArea) {
                case EPIPHYTE: {
                    color = 2;
                    break;
                }
                case PRIMARY: {
                    color = 0;
                    break;
                }
                case SHADE: {
                    color = 12;
                    break;
                }
                case WATER_EDGE: {
                    color = 3;
                    break;
                }
                case WATER_FLOATING: {
                    color = 14;
                    break;
                }
                case WATER_IMMERSED: {
                    color = 1;
                    break;
                }
                case WATER_SUBMERGED: {
                    color = 4;
                    break;
                }
                case TREE: {
                    color = 9;
                    break;
                }
                case VINE: {
                    color = 5;
                    break;
                }
            }
        }
        world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, color, 3);
    }

    public static int getOppositeDirection(int direction) {
        if (direction < 2 || direction > 9) {
            return 0;
        }
        switch (direction) {
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 6;
            }
        }
        return 0;
    }
}

