/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import plantmegapack.PlantMegaPack;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.common.PMPDecoratorArea;
import plantmegapack.common.PMPPlantSoilType;
import plantmegapack.data.PMPDataPlantSpawnParams;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.PMPSpawnLocation;

public abstract class PMPGenAquatic
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData, PMPDataPlantSpawnParams params, PMPBlockPlant plant) {
        return true;
    }

    public static boolean spawnRandomSeaweedCluster(World world, Random random, PMPSpawnLocation locationData, PMPBlockPlant plant, int clusterSize, int clusterAmount) {
        int height = 0;
        for (int count = 0; count < clusterAmount; ++count) {
            int iy;
            int ix = random.nextInt(100) < 50 ? locationData.x + random.nextInt(clusterSize) : locationData.x - random.nextInt(clusterSize);
            int iz = random.nextInt(100) < 50 ? locationData.z + random.nextInt(clusterSize) : locationData.z - random.nextInt(clusterSize);
            int bottom = iy = world.func_72976_f(ix, iz) - 1;
            Block block = world.func_147439_a(ix, iy, iz);
            Block blockBelow = world.func_147439_a(ix, iy - 1, iz);
            if (block.func_149688_o() != Material.field_151586_h) continue;
            while (!PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.AQUATIC, blockBelow = world.func_147439_a(ix, --bottom - 1, iz)) && bottom > 1) {
            }
            height = iy - bottom;
            height = random.nextInt(height);
            if (world.func_147439_a(ix, bottom, iz).func_149688_o() != Material.field_151586_h) continue;
            for (int pos = bottom; pos <= bottom + height; ++pos) {
                world.func_147465_d(ix, pos, iz, (Block)plant, 0, 3);
            }
        }
        return true;
    }

    public static void spawnCoralReef(World world, Random random, PMPSpawnLocation locationData) {
        int clusterSize = 10;
        int variance = 4;
        for (int passes = 0; passes < 60; ++passes) {
            int z;
            int y;
            int x = random.nextInt(100) < 50 ? locationData.x + random.nextInt(clusterSize) : locationData.x + random.nextInt(clusterSize) - random.nextInt(variance);
            Block block = world.func_147439_a(x, y = world.func_72976_f(x, z = random.nextInt(100) < 50 ? locationData.z + random.nextInt(clusterSize) : locationData.z + random.nextInt(clusterSize) - random.nextInt(variance)) - 1, z);
            if (block.func_149688_o() != Material.field_151586_h) continue;
            do {
                block = world.func_147439_a(x, --y, z);
            } while (!PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.AQUATIC, world.func_147439_a(x, y - 1, z)) && y > 1);
            if (!PMPGenBase.canReplaceBlockWithPlant(block, false)) continue;
            world.func_147465_d(x, y, z, (Block)PlantMegaPack.blocks.getRandomCoralReefPlant(random), 0, 3);
        }
    }

    public static boolean spawnWaterPlantCluster(World world, Random random, PMPSpawnLocation locationData, PMPBlockPlant plant, PMPDataPlantSpawnParams params) {
        int x = locationData.x;
        int z = locationData.z;
        for (int passes = 0; passes < params.clusterAmount; ++passes) {
            locationData.x = random.nextInt(100) < 50 ? x + random.nextInt(params.clusterSize) : x + random.nextInt(params.clusterSize) - random.nextInt(params.clusterSize);
            locationData.z = random.nextInt(100) < 50 ? z + random.nextInt(params.clusterSize) : z + random.nextInt(params.clusterSize) - random.nextInt(params.clusterSize);
            locationData.y = world.func_72976_f(locationData.x, locationData.z);
            if (!locationData.checkForWaterPlant(world) || locationData.decoratorArea != PMPDecoratorArea.WATER_SUBMERGED && locationData.decoratorArea != PMPDecoratorArea.WATER_IMMERSED || !plant.func_149742_c(world, locationData.x, locationData.y, locationData.z)) continue;
            world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)plant, 0, 3);
        }
        return true;
    }
}

