/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import plantmegapack.bin.PMPRenderers;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.common.PMPPlantCategory;
import plantmegapack.common.PMPPlantGrowthType;

public class PMPRendererImmersed
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return PMPRenderers.renderImmersedID;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof PMPBlockPlant)) {
            return false;
        }
        this.renderPlant(world, renderer, (PMPBlockPlant)block, x, y, z);
        return true;
    }

    private void renderPlant(IBlockAccess world, RenderBlocks renderer, PMPBlockPlant block, int x, int y, int z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        int l = block.func_149720_d(world, x, y, z);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        tessellator.func_78386_a(f, f1, f2);
        double d1 = x;
        double d2 = y;
        double d0 = z;
        long i1 = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
        i1 = i1 * i1 * 42317861L + i1 * 11L;
        d1 += ((double)((float)(i1 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.3;
        d0 += ((double)((float)(i1 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.3;
        if (block.plantData.attributes.category == PMPPlantCategory.CROP_AQUATIC) {
            int indexTop = world.func_72805_g(x, y, z) + 1;
            int indexBottom = 0;
            IIcon iconBottom = block.func_149691_a(0, indexBottom);
            IIcon iconTop = block.func_149691_a(0, indexTop);
            if (iconBottom == null || iconTop == null) {
                return;
            }
            renderer.func_147765_a(iconTop, d1, d2, d0, 1.0f);
            renderer.func_147765_a(iconBottom, d1, d2 - 1.0, d0, 1.0f);
        } else if (block.plantData.attributes.growthType == PMPPlantGrowthType.NORMAL) {
            int indexTop = world.func_72805_g(x, y, z) + 1;
            IIcon iconBottom = block.func_149691_a(0, 0);
            IIcon iconTop = block.func_149691_a(0, indexTop);
            if (iconBottom == null || iconTop == null) {
                return;
            }
            renderer.func_147765_a(iconTop, d1, d2, d0, 1.0f);
            renderer.func_147765_a(iconBottom, d1, d2 - 1.0, d0, 1.0f);
        } else if (block.plantData.attributes.growthType == PMPPlantGrowthType.DOUBLE) {
            int indexBottom;
            renderer.func_147765_a(block.func_149691_a(0, 0), d1, d2 - 1.0, d0, 1.0f);
            int indexTop = 0;
            switch (world.func_72805_g(x, y, z)) {
                case 0: {
                    indexBottom = 1;
                    break;
                }
                case 1: {
                    indexBottom = 2;
                    break;
                }
                case 2: {
                    indexBottom = 3;
                    indexTop = 4;
                    break;
                }
                case 3: {
                    indexBottom = 5;
                    indexTop = 6;
                    break;
                }
                case 4: {
                    indexBottom = 7;
                    indexTop = 8;
                    break;
                }
                default: {
                    indexBottom = 1;
                }
            }
            renderer.func_147765_a(block.func_149691_a(0, indexBottom), d1, d2, d0, 1.0f);
            if (indexTop > 0) {
                renderer.func_147765_a(block.func_149691_a(0, indexTop), d1, d2 + 1.0, d0, 1.0f);
            }
        }
    }
}

