/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import plantmegapack.bin.PMPRenderers;
import plantmegapack.block.PMPBlockPlant;

public class PMPRendererFlatPlant
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return PMPRenderers.renderFlatPlantID;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof PMPBlockPlant)) {
            return false;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon icon = block.func_149691_a(0, 0);
        double iconMinU = icon.func_94209_e();
        double iconMinV = icon.func_94206_g();
        double iconMaxU = icon.func_94212_f();
        double iconMaxV = icon.func_94210_h();
        float cf = 1.0f;
        int colorMultiplier = block.func_149720_d(renderer.field_147845_a, x, y, z);
        float colorRED = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
        float colorGRN = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
        float colorBLU = (float)(colorMultiplier & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            colorRED = (colorRED * 30.0f + colorGRN * 59.0f + colorBLU * 11.0f) / 100.0f;
            colorGRN = (colorRED * 30.0f + colorGRN * 70.0f) / 100.0f;
            colorBLU = (colorRED * 30.0f + colorBLU * 70.0f) / 100.0f;
        }
        tessellator.func_78375_b(0.0f, 0.0f, 0.0f);
        tessellator.func_78386_a(cf * colorRED, cf * colorGRN, cf * colorBLU);
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        tessellator.func_78372_c((float)x, (float)y, (float)z);
        this.renderFlatPlant(tessellator, iconMinU, iconMaxU, iconMinV, iconMaxV, world.func_72805_g(x, y, z));
        tessellator.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    private void renderFlatPlant(Tessellator tessellator, double iconMinU, double iconMaxU, double iconMinV, double iconMaxV, int metaData) {
        double angle = metaData * 45 + 90;
        if (angle > 360.0) {
            angle -= 360.0;
        }
        double radians = Math.toRadians(angle);
        double startX = 0.5;
        double startZ = 0.0;
        double rotStartX = 0.5 + Math.cos(radians) * (startX - 0.5) - Math.sin(radians) * (startZ - 0.5);
        double rotStartZ = 0.5 + Math.sin(radians) * (startX - 0.5) + Math.cos(radians) * (startZ - 0.5);
        startX = 0.5;
        startZ = 1.0;
        double rotEndX = 0.5 + Math.cos(radians) * (startX - 0.5) - Math.sin(radians) * (startZ - 0.5);
        double rotEndZ = 0.5 + Math.sin(radians) * (startX - 0.5) + Math.cos(radians) * (startZ - 0.5);
        tessellator.func_78374_a(rotStartX, 0.0, rotStartZ, iconMaxU, iconMaxV);
        tessellator.func_78374_a(rotStartX, 1.0, rotStartZ, iconMaxU, iconMinV);
        tessellator.func_78374_a(rotEndX, 1.0, rotEndZ, iconMinU, iconMinV);
        tessellator.func_78374_a(rotEndX, 0.0, rotEndZ, iconMinU, iconMaxV);
        tessellator.func_78374_a(rotEndX, 0.0, rotEndZ, iconMaxU, iconMaxV);
        tessellator.func_78374_a(rotEndX, 1.0, rotEndZ, iconMaxU, iconMinV);
        tessellator.func_78374_a(rotStartX, 1.0, rotStartZ, iconMinU, iconMinV);
        tessellator.func_78374_a(rotStartX, 0.0, rotStartZ, iconMinU, iconMaxV);
    }
}

