/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import plantmegapack.PlantMegaPack;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.common.PMPPlantCategory;
import plantmegapack.common.PMPPlantGrowthType;
import plantmegapack.common.PMPPlantPowder;
import plantmegapack.common.PMPPlantRenderType;
import plantmegapack.common.PMPPlantSoilType;
import plantmegapack.common.PMPTab;

public class PMPItemPowder
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon powderIcon;
    private PMPPlantPowder powder;

    public PMPItemPowder(PMPPlantPowder powder) {
        this.powder = powder;
        this.func_77655_b(this.powder.unlocalizedName);
        GameRegistry.registerItem((Item)this, (String)this.powder.unlocalizedName);
        this.func_77637_a(PlantMegaPack.creativeTabs.getCreativeTab(PMPTab.build));
        if (this.powder.unlocalizedName.matches("powderAloe")) {
            this.func_77631_c(PotionHelper.field_77918_f);
        } else if (this.powder.unlocalizedName.matches("powderCoral")) {
            this.func_77631_c(PotionHelper.field_151423_m);
        } else if (this.powder.unlocalizedName.matches("powderCactus")) {
            this.func_77631_c(PotionHelper.field_77919_g);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.powderIcon = ir.func_94245_a("plantmegapack:" + this.func_77658_a().substring(5));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.powderIcon;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (world.func_147439_a(x, y + 1, z).func_149688_o() == Material.field_151586_h) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        String unlocalizedName = this.func_77658_a().substring(5);
        if (unlocalizedName.matches("powderConditioner")) {
            if (block.func_149688_o() == Material.field_151585_k || block instanceof BlockBush) {
                return false;
            }
            if (side == 1) {
                this.applyConditioner(world, x, y, z);
            }
        } else if (unlocalizedName.matches("powderDefoliant")) {
            if (block.func_149688_o() == Material.field_151585_k || block instanceof BlockBush) {
                this.applyDefoliantToPlant(world, x, y, z);
            } else if (side == 1) {
                this.applyDefoliant(world, x, y, z);
            }
        } else if (unlocalizedName.matches("powderFertilizer")) {
            if (block.func_149688_o() == Material.field_151585_k || block instanceof BlockBush || block instanceof BlockCactus || block instanceof BlockReed) {
                this.applyFertilizerToPlant(world, x, y, z);
            } else if (side == 1) {
                this.applyFertilizer(world, x, y, z);
            }
        }
        --itemStack.field_77994_a;
        return true;
    }

    private void applyConditioner(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (!PlantMegaPack.soilBlocks.isGrassBlock(block) && !(block instanceof BlockDirt) && block != Blocks.field_150458_ak) {
            return;
        }
        int radius = PlantMegaPack.settings.powderConditionerRadius;
        int lowX = x - radius;
        int lowZ = z - radius;
        int highX = x + radius;
        int highZ = z + radius;
        for (int ix = lowX; ix <= highX; ++ix) {
            for (int iz = lowZ; iz <= highZ; ++iz) {
                if ((ix == lowX || ix == highX) && (iz == lowZ || iz == highZ) || world.field_73012_v.nextInt(100) >= PlantMegaPack.settings.powderConditionerStrength || !PlantMegaPack.soilBlocks.isGrassBlock(block = world.func_147439_a(ix, y, iz)) && !(block instanceof BlockDirt) && block != Blocks.field_150458_ak) continue;
                world.func_147465_d(ix, y, iz, Blocks.field_150458_ak, 0, 3);
                this.spawnFertilizerParticles(world, ix, y, iz, block, true);
            }
        }
    }

    private void applyFertilizer(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (!(block instanceof BlockDirt || PlantMegaPack.soilBlocks.isGrassBlock(block) || block instanceof BlockMycelium || block instanceof BlockFarmland || block == Blocks.field_150347_e)) {
            return;
        }
        int radius = PlantMegaPack.settings.powderFertilizerRadius;
        int lowX = x - radius;
        int lowZ = z - radius;
        int highX = x + radius;
        int highZ = z + radius;
        for (int ix = lowX; ix <= highX; ++ix) {
            for (int iz = lowZ; iz <= highZ; ++iz) {
                if ((ix == lowX || ix == highX) && (iz == lowZ || iz == highZ) || world.field_73012_v.nextInt(100) >= PlantMegaPack.settings.powderFertilizerStrength) continue;
                block = world.func_147439_a(ix, y, iz);
                if (block instanceof BlockDirt) {
                    world.func_147465_d(ix, y, iz, (Block)Blocks.field_150349_c, 0, 3);
                    this.spawnFertilizerParticles(world, ix, y, iz, block, true);
                    continue;
                }
                if (block instanceof BlockMycelium) {
                    world.func_147465_d(ix, y, iz, (Block)Blocks.field_150349_c, 0, 3);
                    this.spawnFertilizerParticles(world, ix, y, iz, block, true);
                    continue;
                }
                if (block != Blocks.field_150347_e) continue;
                world.func_147465_d(ix, y, iz, Blocks.field_150341_Y, 0, 3);
                this.spawnFertilizerParticles(world, ix, y, iz, block, true);
            }
        }
    }

    private void applyFertilizerToPlant(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metaData = world.func_72805_g(x, y, z);
        if (block instanceof PMPBlockPlant) {
            PMPBlockPlant plantBlock = (PMPBlockPlant)block;
            if (plantBlock.plantData.attributes.growthType == PMPPlantGrowthType.DOUBLE && (metaData == 3 || metaData == 5 || metaData == 7) || plantBlock.isImmersedPlant()) {
                this.spawnPlantRadius(world, x, y - (plantBlock.isImmersedPlant() ? 0 : 1), z, (Block)plantBlock, 0, false);
            } else if (plantBlock.plantData.attributes.category != PMPPlantCategory.BAMBOO && plantBlock.plantData.attributes.category != PMPPlantCategory.CACTUS && plantBlock.plantData.attributes.category != PMPPlantCategory.VINE && plantBlock.plantData.attributes.soilType != PMPPlantSoilType.AQUATIC && plantBlock.plantData.attributes.category != PMPPlantCategory.EPIPHYTE) {
                if (plantBlock.hasFlowerColors()) {
                    this.spawnPlantRadius(world, x, y, z, (Block)plantBlock, metaData, false);
                } else {
                    this.spawnPlantRadius(world, x, y, z, (Block)plantBlock, 0, false);
                }
            }
        } else if (block instanceof BlockSapling) {
            ((BlockSapling)block).func_149878_d(world, x, x, z, world.field_73012_v);
        } else if (block instanceof BlockBush || block instanceof BlockFlower || block instanceof BlockDoublePlant) {
            if (metaData == 8) {
                this.spawnPlantRadius(world, x, y - 1, z, block, world.func_72805_g(x, y - 1, z), false);
            } else {
                this.spawnPlantRadius(world, x, y, z, block, metaData, false);
            }
        }
    }

    private void spawnPlantRadius(World world, int x, int y, int z, Block blockPlant, int metaData, boolean overrideSoilCheck) {
        int radius = PlantMegaPack.settings.powderFertilizerRadius;
        int iy = y;
        int lowX = x - radius;
        int lowZ = z - radius;
        int highX = x + radius;
        int highZ = z + radius;
        for (int ix = lowX; ix <= highX; ++ix) {
            for (int iz = lowZ; iz <= highZ; ++iz) {
                while (world.func_147437_c(ix, iy - 1, iz)) {
                    --iy;
                }
                if ((ix != lowX && ix != highX || iz != lowZ && iz != highZ) && world.field_73012_v.nextInt(100) < PlantMegaPack.settings.powderFertilizerStrength && world.func_147437_c(ix, iy, iz) && (blockPlant.func_149718_j(world, ix, iy, iz) || overrideSoilCheck)) {
                    if (blockPlant instanceof PMPBlockPlant) {
                        if (((PMPBlockPlant)blockPlant).hasFlowerColors()) {
                            world.func_147465_d(ix, iy, iz, blockPlant, metaData, 3);
                            this.spawnFertilizerParticles(world, ix, iy, iz, blockPlant, false);
                        } else if (((PMPBlockPlant)blockPlant).plantData.attributes.renderType == PMPPlantRenderType.FLAT) {
                            world.func_147465_d(ix, iy, iz, blockPlant, world.field_73012_v.nextInt(8), 3);
                            this.spawnFertilizerParticles(world, ix, iy, iz, blockPlant, false);
                        } else {
                            world.func_147465_d(ix, iy, iz, blockPlant, 0, 3);
                            this.spawnFertilizerParticles(world, ix, iy, iz, blockPlant, false);
                        }
                    } else {
                        world.func_147465_d(ix, iy, iz, blockPlant, metaData, 3);
                        this.spawnFertilizerParticles(world, ix, iy, iz, blockPlant, false);
                        if (blockPlant == Blocks.field_150398_cm) {
                            world.func_147465_d(ix, iy + 1, iz, blockPlant, 8, 2);
                            this.spawnFertilizerParticles(world, ix, iy + 1, iz, blockPlant, false);
                        }
                    }
                }
                iy = y;
            }
        }
    }

    private void applyDefoliant(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int radius = PlantMegaPack.settings.powderDefoliantRadius;
        int lowX = x - radius;
        int lowZ = z - radius;
        int highX = x + radius;
        int highZ = z + radius;
        for (int ix = lowX; ix <= highX; ++ix) {
            for (int iz = lowZ; iz <= highZ; ++iz) {
                if ((ix == lowX || ix == highX) && (iz == lowZ || iz == highZ) || world.field_73012_v.nextInt(100) >= PlantMegaPack.settings.powderDefoliantStrength) continue;
                block = world.func_147439_a(ix, y, iz);
                if (PlantMegaPack.soilBlocks.isGrassBlock(block)) {
                    world.func_147465_d(ix, y, iz, Blocks.field_150346_d, 0, 3);
                    this.spawnDefoliantParticles(world, x, y, z, true);
                    block = world.func_147439_a(ix, y + 1, iz);
                    if (block.func_149688_o() != Material.field_151585_k && !(block instanceof BlockBush)) continue;
                    this.applyDefoliantToPlant(world, ix, y + 1, iz);
                    continue;
                }
                if (block == Blocks.field_150458_ak) {
                    world.func_147465_d(ix, y, iz, Blocks.field_150346_d, 1, 3);
                    this.spawnDefoliantParticles(world, x, y, z, true);
                    block = world.func_147439_a(ix, y + 1, iz);
                    if (block.func_149688_o() != Material.field_151585_k && !(block instanceof BlockBush)) continue;
                    this.applyDefoliantToPlant(world, ix, y + 1, iz);
                    continue;
                }
                if (block == Blocks.field_150354_m && world.func_72805_g(ix, y, iz) == 0) {
                    world.func_147465_d(ix, y, iz, (Block)Blocks.field_150354_m, 1, 3);
                    this.spawnDefoliantParticles(world, x, y, z, true);
                    block = world.func_147439_a(ix, y + 1, iz);
                    if (block.func_149688_o() != Material.field_151585_k && !(block instanceof BlockBush)) continue;
                    this.applyDefoliantToPlant(world, ix, y + 1, iz);
                    continue;
                }
                if (block != Blocks.field_150341_Y) continue;
                world.func_147465_d(ix, y, iz, Blocks.field_150347_e, 0, 3);
                this.spawnDefoliantParticles(world, x, y, z, true);
            }
        }
    }

    private void applyDefoliantToPlant(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof PMPBlockPlant) {
            if (((PMPBlockPlant)block).isTopPlantBlock(world, x, y, z)) {
                world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
                this.spawnDefoliantParticles(world, x, y, z, false);
                block = world.func_147439_a(x, y - 1, z);
                if (block instanceof PMPBlockPlant) {
                    world.func_147465_d(x, y - 1, z, Blocks.field_150350_a, 0, 3);
                    this.spawnDefoliantParticles(world, x, y - 1, z, false);
                }
            } else {
                world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
                this.spawnDefoliantParticles(world, x, y, z, false);
            }
        } else if (block instanceof BlockSapling || block.func_149688_o() == Material.field_151585_k || block == Blocks.field_150329_H || block instanceof BlockFlower) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
            this.spawnDefoliantParticles(world, x, y, z, false);
        }
    }

    private void spawnFertilizerParticles(World world, int x, int y, int z, Block block, boolean soilAdjust) {
        double d0 = field_77697_d.nextGaussian() * 0.02;
        double d1 = field_77697_d.nextGaussian() * 0.02;
        double d2 = field_77697_d.nextGaussian() * 0.02;
        double heightAdjustment = soilAdjust ? 1.0f : 0.05f;
        world.func_72869_a("happyVillager", (double)((float)x + field_77697_d.nextFloat()), (double)y + heightAdjustment + (double)field_77697_d.nextFloat() * 1.0, (double)((float)z + field_77697_d.nextFloat()), d0, d1, d2);
    }

    private void spawnDefoliantParticles(World world, int x, int y, int z, boolean soilAdjust) {
        double d0 = field_77697_d.nextGaussian() * 0.02;
        double d1 = field_77697_d.nextGaussian() * 0.02;
        double d2 = field_77697_d.nextGaussian() * 0.02;
        double heightAdjustment = soilAdjust ? 1.0f : 0.05f;
        world.func_72869_a("largesmoke", (double)((float)x + field_77697_d.nextFloat()), (double)y + heightAdjustment + (double)field_77697_d.nextFloat() * 1.0, (double)((float)z + field_77697_d.nextFloat()), d0, d1, d2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        if (PlantMegaPack.settings.tooltipAttributes) {
            String unlocalizedName = this.func_77658_a().substring(5);
            if (unlocalizedName.matches("powderAloe")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipBrewing") + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.potionHealing") + "\u00a7r");
            } else if (unlocalizedName.matches("powderBerry")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipCrafting") + ": \u00a79" + StatCollector.func_74838_a((String)"item.powderFertilizer.name") + "\u00a7r");
            } else if (unlocalizedName.matches("powderCactus")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipBrewing") + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.potionStrength") + "\u00a7r");
            } else if (unlocalizedName.matches("powderCoral")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipBrewing") + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.potionWaterBreathing") + "\u00a7r");
            } else if (unlocalizedName.matches("powderFern")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipCrafting") + ": \u00a79" + StatCollector.func_74838_a((String)"item.powderFertilizer.name") + "\u00a7r");
            } else if (unlocalizedName.matches("powderLeaf")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipCrafting") + ": \u00a79" + StatCollector.func_74838_a((String)"item.powderFertilizer.name") + "\u00a7r");
            } else if (unlocalizedName.matches("powderMoss")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipCrafting") + ": \u00a79" + StatCollector.func_74838_a((String)"item.powderConditioner.name") + "\u00a7r");
            } else if (unlocalizedName.matches("powderMushroom")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipCrafting") + ": \u00a79" + StatCollector.func_74838_a((String)"item.powderFertilizer.name") + "\u00a7r");
            } else if (unlocalizedName.matches("powderMushroomPoison")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipCrafting") + ": \u00a79" + StatCollector.func_74838_a((String)"item.powderDefoliant.name") + "\u00a7r");
            } else if (unlocalizedName.matches("powderConditioner")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipRadius") + ": \u00a79" + String.format("%d", PlantMegaPack.settings.powderConditionerRadius) + "\u00a7r");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipStrength") + ": \u00a79" + String.format("%d", PlantMegaPack.settings.powderConditionerStrength) + "%\u00a7r");
            } else if (unlocalizedName.matches("powderDefoliant")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipRadius") + ": \u00a79" + String.format("%d", PlantMegaPack.settings.powderDefoliantRadius) + "\u00a7r");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipStrength") + ": \u00a79" + String.format("%d", PlantMegaPack.settings.powderDefoliantStrength) + "%\u00a7r");
            } else if (unlocalizedName.matches("powderFertilizer")) {
                list.add("");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipRadius") + ": \u00a79" + String.format("%d", PlantMegaPack.settings.powderFertilizerRadius) + "\u00a7r");
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipStrength") + ": \u00a79" + String.format("%d", PlantMegaPack.settings.powderFertilizerStrength) + "%\u00a7r");
            }
        }
    }
}

