/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.gui;

import cpw.mods.fml.client.GuiScrollingList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import plantmegapack.gui.PMPGuiConfigBase;
import plantmegapack.gui.PMPGuiStringListState;

public class PMPGuiStringList
extends GuiScrollingList {
    private PMPGuiConfigBase parent;
    private final Minecraft client = Minecraft.func_71410_x();
    private int top;
    private int bottom;
    private int left;
    private int right;
    private float initialMouseClickY = -2.0f;
    private int scrollUpActionId;
    private int scrollDownActionId;
    private long lastClickTime = 0L;
    private boolean field_25123_p = true;
    private boolean field_27262_q;
    private int field_27261_r;
    private ArrayList<String> list = null;
    private PMPGuiStringListState listState;

    public PMPGuiStringList(PMPGuiConfigBase parent, int width, int height, int top, int bottom, int left, int slotHeight) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left, slotHeight);
        this.parent = parent;
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = width + this.left;
        this.listState = new PMPGuiStringListState();
    }

    private void applyScrollLimits() {
        int var1 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (var1 < 0) {
            var1 /= 2;
        }
        if (this.listState.scrollDistance < 0.0f) {
            this.listState.scrollDistance = 0.0f;
        }
        if (this.listState.scrollDistance > (float)var1) {
            this.listState.scrollDistance = var1;
        }
    }

    public void func_27258_a(boolean p_27258_1_) {
        this.field_25123_p = p_27258_1_;
    }

    protected void func_27259_a(boolean p_27259_1_, int p_27259_2_) {
        this.field_27262_q = p_27259_1_;
        this.field_27261_r = p_27259_2_;
        if (!p_27259_1_) {
            this.field_27261_r = 0;
        }
    }

    public void registerScrollButtons(List p_22240_1_, int p_22240_2_, int p_22240_3_) {
        this.scrollUpActionId = p_22240_2_;
        this.scrollDownActionId = p_22240_3_;
    }

    public int func_27256_c(int p_27256_1_, int p_27256_2_) {
        int var3 = this.left + 1;
        int var4 = this.left + this.listWidth - 7;
        int var5 = p_27256_2_ - this.top - this.field_27261_r + (int)this.listState.scrollDistance - 4;
        int var6 = var5 / this.slotHeight;
        return p_27256_1_ >= var3 && p_27256_1_ <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
    }

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.field_27261_r;
    }

    protected int getSize() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        if (index != this.listState.selectedIndex) {
            this.listState.selectedIndex = index;
            this.parent.listItemSelected(this, index);
        }
        if (doubleClick) {
            this.parent.listItemActivate(this);
        }
    }

    protected boolean isSelected(int index) {
        return index == this.listState.selectedIndex;
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.scrollUpActionId) {
                this.listState.scrollDistance -= (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            } else if (button.field_146127_k == this.scrollDownActionId) {
                this.listState.scrollDistance += (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            }
        }
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int index, int var2, int var3, int var4, Tessellator var5) {
        if (this.list != null) {
            if (index == this.listState.selectedIndex) {
                this.parent.getFontRenderer().func_78261_a(this.parent.getFontRenderer().func_78269_a(this.list.get(index), this.listWidth - 10), this.left + 3, var3 + 2, 0xFFFF80);
            } else {
                this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(this.list.get(index), this.listWidth - 10), this.left + 3, var3 + 2, 0x80C080);
            }
        }
    }

    public void drawScreen(int mouseX, int mouseY, float p_22243_3_) {
        int var14;
        int var13;
        int var19;
        int var11;
        int var10;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackground();
        int listLength = this.getSize();
        int scrollBarXStart = this.left + this.listWidth - 6;
        int scrollBarXEnd = scrollBarXStart + 6;
        int boxLeft = this.left;
        int boxRight = scrollBarXStart - 1;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                boolean var7 = true;
                if (mouseY >= this.top && mouseY <= this.bottom && mouseX >= this.left && mouseX <= this.right) {
                    var10 = mouseY - this.top - this.field_27261_r + (int)this.listState.scrollDistance - 4;
                    var11 = var10 / this.slotHeight;
                    if (mouseX >= boxLeft && mouseX <= boxRight && var11 >= 0 && var10 >= 0 && var11 < listLength) {
                        boolean var12 = var11 == this.listState.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L;
                        this.elementClicked(var11, var12);
                        this.lastClickTime = System.currentTimeMillis();
                    } else if (mouseX >= boxLeft && mouseX <= boxRight && var10 < 0) {
                        this.func_27255_a(mouseX - boxLeft, mouseY - this.top + (int)this.listState.scrollDistance - 4);
                        var7 = false;
                    }
                    if (mouseX >= scrollBarXStart && mouseX <= scrollBarXEnd) {
                        this.listState.scrollFactor = -1.0f;
                        var19 = this.getContentHeight() - (this.bottom - this.top - 2);
                        if (var19 < 1) {
                            var19 = 1;
                        }
                        if ((var13 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > this.bottom - this.top - 8) {
                            var13 = this.bottom - this.top - 8;
                        }
                        this.listState.scrollFactor /= (float)(this.bottom - this.top - var13) / (float)var19;
                    } else {
                        this.listState.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = var7 ? (float)mouseY : -2.0f;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.listState.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.listState.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        Tessellator tesselator = Tessellator.field_78398_a;
        if (this.client.field_71441_e != null) {
            this.drawGradientRect(this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        } else {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2912);
            this.client.field_71446_o.func_110577_a(Gui.field_110325_k);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float var17 = 32.0f;
            tesselator.func_78382_b();
            tesselator.func_78378_d(0x202020);
            tesselator.func_78374_a((double)this.left, (double)this.bottom, 0.0, (double)((float)this.left / var17), (double)((float)(this.bottom + (int)this.listState.scrollDistance) / var17));
            tesselator.func_78374_a((double)this.right, (double)this.bottom, 0.0, (double)((float)this.right / var17), (double)((float)(this.bottom + (int)this.listState.scrollDistance) / var17));
            tesselator.func_78374_a((double)this.right, (double)this.top, 0.0, (double)((float)this.right / var17), (double)((float)(this.top + (int)this.listState.scrollDistance) / var17));
            tesselator.func_78374_a((double)this.left, (double)this.top, 0.0, (double)((float)this.left / var17), (double)((float)(this.top + (int)this.listState.scrollDistance) / var17));
            tesselator.func_78381_a();
        }
        var10 = this.top + 2 - (int)this.listState.scrollDistance;
        if (this.field_27262_q) {
            this.func_27260_a(boxRight, var10, tesselator);
        }
        for (var11 = 0; var11 < listLength; ++var11) {
            var19 = var10 + var11 * this.slotHeight + this.field_27261_r;
            var13 = this.slotHeight;
            if (var19 > this.bottom || var19 + var13 < this.top) continue;
            if (this.field_25123_p && this.isSelected(var11)) {
                var14 = boxLeft;
                int var15 = boxRight;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tesselator.func_78382_b();
                tesselator.func_78378_d(0x808080);
                tesselator.func_78374_a((double)var14, (double)(var19 + var13 + 1), 0.0, 0.0, 1.0);
                tesselator.func_78374_a((double)var15, (double)(var19 + var13 + 1), 0.0, 1.0, 1.0);
                tesselator.func_78374_a((double)var15, (double)(var19 - 1), 0.0, 1.0, 0.0);
                tesselator.func_78374_a((double)var14, (double)(var19 - 1), 0.0, 0.0, 0.0);
                tesselator.func_78378_d(0);
                tesselator.func_78374_a((double)(var14 + 1), (double)(var19 + var13), 0.0, 0.0, 1.0);
                tesselator.func_78374_a((double)(var15 - 1), (double)(var19 + var13), 0.0, 1.0, 1.0);
                tesselator.func_78374_a((double)(var15 - 1), (double)var19, 0.0, 1.0, 0.0);
                tesselator.func_78374_a((double)(var14 + 1), (double)var19, 0.0, 0.0, 0.0);
                tesselator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            this.drawSlot(var11, boxRight, var19, var13, tesselator);
        }
        GL11.glDisable((int)2929);
        int var20 = 4;
        if (this.client.field_71441_e == null) {
            this.overlayBackground(this.top - 12, this.top, 255, 255);
            this.overlayBackground(this.bottom, this.bottom + 12, 255, 255);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tesselator.func_78382_b();
        tesselator.func_78384_a(0, 0);
        tesselator.func_78374_a((double)this.left, (double)(this.top + var20), 0.0, 0.0, 1.0);
        tesselator.func_78374_a((double)this.right, (double)(this.top + var20), 0.0, 1.0, 1.0);
        tesselator.func_78384_a(0, 255);
        tesselator.func_78374_a((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        tesselator.func_78374_a((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        tesselator.func_78381_a();
        tesselator.func_78382_b();
        tesselator.func_78384_a(0, 255);
        tesselator.func_78374_a((double)this.left, (double)this.bottom, 0.0, 0.0, 1.0);
        tesselator.func_78374_a((double)this.right, (double)this.bottom, 0.0, 1.0, 1.0);
        tesselator.func_78384_a(0, 0);
        tesselator.func_78374_a((double)this.right, (double)(this.bottom - var20), 0.0, 1.0, 0.0);
        tesselator.func_78374_a((double)this.left, (double)(this.bottom - var20), 0.0, 0.0, 0.0);
        tesselator.func_78381_a();
        var19 = this.getContentHeight() - (this.bottom - this.top - 2);
        if (var19 > 0) {
            var13 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (var13 < 32) {
                var13 = 32;
            }
            if (var13 > this.bottom - this.top - 8) {
                var13 = this.bottom - this.top - 8;
            }
            if ((var14 = (int)this.listState.scrollDistance * (this.bottom - this.top - var13) / var19 + this.top) < this.top) {
                var14 = this.top;
            }
            tesselator.func_78382_b();
            tesselator.func_78384_a(0, 255);
            tesselator.func_78374_a((double)scrollBarXStart, (double)this.bottom, 0.0, 0.0, 1.0);
            tesselator.func_78374_a((double)scrollBarXEnd, (double)this.bottom, 0.0, 1.0, 1.0);
            tesselator.func_78374_a((double)scrollBarXEnd, (double)this.top, 0.0, 1.0, 0.0);
            tesselator.func_78374_a((double)scrollBarXStart, (double)this.top, 0.0, 0.0, 0.0);
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78384_a(0x808080, 255);
            tesselator.func_78374_a((double)scrollBarXStart, (double)(var14 + var13), 0.0, 0.0, 1.0);
            tesselator.func_78374_a((double)scrollBarXEnd, (double)(var14 + var13), 0.0, 1.0, 1.0);
            tesselator.func_78374_a((double)scrollBarXEnd, (double)var14, 0.0, 1.0, 0.0);
            tesselator.func_78374_a((double)scrollBarXStart, (double)var14, 0.0, 0.0, 0.0);
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78384_a(0xC0C0C0, 255);
            tesselator.func_78374_a((double)scrollBarXStart, (double)(var14 + var13 - 1), 0.0, 0.0, 1.0);
            tesselator.func_78374_a((double)(scrollBarXEnd - 1), (double)(var14 + var13 - 1), 0.0, 1.0, 1.0);
            tesselator.func_78374_a((double)(scrollBarXEnd - 1), (double)var14, 0.0, 1.0, 0.0);
            tesselator.func_78374_a((double)scrollBarXStart, (double)var14, 0.0, 0.0, 0.0);
            tesselator.func_78381_a();
        }
        this.func_27257_b(mouseX, mouseY);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    private void overlayBackground(int p_22239_1_, int p_22239_2_, int p_22239_3_, int p_22239_4_) {
        Tessellator var5 = Tessellator.field_78398_a;
        this.client.field_71446_o.func_110577_a(Gui.field_110325_k);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float var6 = 32.0f;
        var5.func_78382_b();
        var5.func_78384_a(0x404040, p_22239_4_);
        var5.func_78374_a((double)this.left, (double)p_22239_2_, 0.0, 0.0, (double)((float)p_22239_2_ / var6));
        var5.func_78374_a((double)this.left + (double)this.listWidth, (double)p_22239_2_, 0.0, (double)((float)this.listWidth / var6), (double)((float)p_22239_2_ / var6));
        var5.func_78384_a(0x404040, p_22239_3_);
        var5.func_78374_a((double)this.left + (double)this.listWidth, (double)p_22239_1_, 0.0, (double)((float)this.listWidth / var6), (double)((float)p_22239_1_ / var6));
        var5.func_78374_a((double)this.left, (double)p_22239_1_, 0.0, 0.0, (double)((float)p_22239_1_ / var6));
        var5.func_78381_a();
    }

    public final String getItemText(int index) {
        if (this.list == null || index < 0 || index >= this.list.size()) {
            return "";
        }
        return this.list.get(index);
    }

    public final int getSelectedItemIndex() {
        return this.listState.selectedIndex;
    }

    public final String getSelectedItemText() {
        return this.getItemText(this.listState.selectedIndex);
    }

    public void setTextArray(ArrayList<String> list) {
        this.list = list;
    }

    public void resetSelectionScroll() {
        this.listState.selectedIndex = 0;
        this.listState.scrollFactor = 0.0f;
        this.listState.scrollDistance = 0.0f;
        this.applyScrollLimits();
    }

    public void saveListState(PMPGuiStringListState targetState) {
        if (targetState != null) {
            targetState.saveState(this.listState);
        }
    }

    public void useListState(PMPGuiStringListState sourceState) {
        if (sourceState != null) {
            this.listState.saveState(sourceState);
            this.applyScrollLimits();
        }
    }
}

