/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.gui;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import plantmegapack.gui.PMPGuiButton;
import plantmegapack.gui.PMPGuiConfigBase;

@SideOnly(value=Side.CLIENT)
public class PMPGuiSlider
extends PMPGuiButton {
    private PMPGuiConfigBase parent;
    private String name;
    private float sliderValue;
    public boolean mouseButtonDown;
    private final float valueMin;
    private final float valueMax;
    private final float valueStep;
    private int sliderMode;

    public PMPGuiSlider(PMPGuiConfigBase parent, int id, int xPosition, int yPosition, int width, int height, String name, int valueMin, int valueInitial, int valueMax, int valueStep) {
        super(id, xPosition, yPosition, width, height, name);
        this.parent = parent;
        this.name = name;
        this.sliderMode = 0;
        this.valueStep = valueStep;
        this.valueMin = valueMin;
        this.valueMax = valueMax;
        this.sliderValue = this.normalizeValue(valueInitial);
        this.updateDisplayString();
    }

    public int func_146114_a(boolean state) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int xPos, int yPos) {
        if (this.field_146125_m) {
            if (this.mouseButtonDown) {
                this.sliderValue = (float)(xPos - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                if (this.sliderValue < 0.0f) {
                    this.sliderValue = 0.0f;
                }
                if (this.sliderValue > 1.0f) {
                    this.sliderValue = 1.0f;
                }
                this.parent.updateIntSetting(this.name, this.getIntValue());
                this.sliderValue = this.normalizeValue(this.getIntValue());
                this.updateDisplayString();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int xPos, int yPos) {
        if (super.func_146116_c(mc, xPos, yPos)) {
            this.sliderValue = (float)(xPos - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            this.parent.updateIntSetting(this.name, this.getIntValue());
            this.updateDisplayString();
            this.mouseButtonDown = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int xPos, int yPos) {
        this.parent.updateIntSetting(this.name, this.getIntValue());
        this.mouseButtonDown = false;
    }

    public int getIntValue() {
        return (int)this.denormalizeValue(this.sliderValue);
    }

    public void setIntValue(int value) {
        if ((float)value < this.valueMin || (float)value > this.valueMax) {
            return;
        }
        this.sliderValue = this.normalizeValue(value);
    }

    public void updateDisplayString() {
        String label = "";
        if (this.sliderMode == 0) {
            label = LanguageRegistry.instance().getStringLocalization(this.name) + ": ";
            if (this.valueStep > 0.0f) {
                if (this.getIntValue() > 0) {
                    label = label + String.valueOf(this.getIntValue());
                    if (this.valueMax == 100.0f) {
                        label = label + "%";
                    }
                } else {
                    label = label + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
                }
            } else {
                label = label + String.valueOf(this.getIntValue());
            }
        }
        if (this.sliderMode == 1) {
            label = String.format("%s: %d", LanguageRegistry.instance().getStringLocalization("gui.label.plantSpawnWeight"), this.getIntValue());
        }
        this.field_146126_j = label;
    }

    private float normalizeValue(float value) {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(value) - this.valueMin) / (this.valueMax - this.valueMin)), (float)0.0f, (float)1.0f);
    }

    private float denormalizeValue(float value) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    private float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return MathHelper.func_76131_a((float)value, (float)this.valueMin, (float)this.valueMax);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public void setSliderMode(int mode) {
        if (mode < 0 || mode > 1) {
            return;
        }
        this.sliderMode = mode;
    }
}

