/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.common;

import cpw.mods.fml.common.Loader;
import plantmegapack.PlantMegaPack;
import plantmegapack.common.PMPDecoratorSet;
import plantmegapack.common.PMPPlantCategory;

public abstract class PMPModInfo {
    public static final String LOGGER_NAME = "PlantMegaPack";
    private static int statRegisteredBlocks = 0;
    private static int statRegisteredItems = 0;
    private static int statRegisteredPlants = 0;
    private static int statRegisteredRecipes = 0;
    private static int statRegisteredChestItems = 0;
    private static Boolean[] modInstalled = new Boolean[PMPDecoratorSet.values().length];

    public static void addToRegisteredBlocks(int quantity) {
        if (quantity > 0) {
            statRegisteredBlocks += quantity;
        }
    }

    public static void addToRegisteredItems(int quantity) {
        if (quantity > 0) {
            statRegisteredItems += quantity;
        }
    }

    public static void addToRegisteredPlants(int quantity) {
        if (quantity > 0) {
            statRegisteredPlants += quantity;
        }
    }

    public static void addToRegisteredRecipes(int quantity) {
        if (quantity > 0) {
            statRegisteredRecipes += quantity;
        }
    }

    public static void addToRegisteredChestItems(int quantity) {
        if (quantity > 0) {
            statRegisteredChestItems += quantity;
        }
    }

    public static int getRegisteredBlocks() {
        return statRegisteredBlocks;
    }

    public static int getRegisteredCategories() {
        int categoryCount = 0;
        for (PMPPlantCategory category : PMPPlantCategory.values()) {
            if (category.addToGame <= 0) continue;
            ++categoryCount;
        }
        return categoryCount;
    }

    public static int getRegisteredItems() {
        return statRegisteredItems;
    }

    public static int getRegisteredPlants() {
        return statRegisteredPlants;
    }

    public static int getRegisteredRecipes() {
        return statRegisteredRecipes;
    }

    public static int getRegisteredChestItems() {
        return statRegisteredChestItems;
    }

    public static void initModsInstalled() {
        PMPModInfo.modInstalled[0] = Loader.isModLoaded((String)"BiomesOPlenty");
        PMPModInfo.modInstalled[1] = Loader.isModLoaded((String)"enhancedbiomes");
        PMPModInfo.modInstalled[2] = Loader.isModLoaded((String)"ExtrabiomesXL");
        PMPModInfo.modInstalled[3] = Loader.isModLoaded((String)"Highlands");
        PMPModInfo.modInstalled[4] = true;
    }

    public static boolean isModInstalled(PMPDecoratorSet decoratorSet) {
        return modInstalled[decoratorSet.ordinal()];
    }

    public static void outputModStatisticsToConsole() {
        PlantMegaPack.instance.logOutput(String.format("Building blocks    : %d", PMPModInfo.getRegisteredBlocks()));
        PlantMegaPack.instance.logOutput(String.format("Plant categories   : %d", PMPModInfo.getRegisteredCategories()));
        PlantMegaPack.instance.logOutput(String.format("Plant blocks       : %d", PMPModInfo.getRegisteredPlants()));
        PlantMegaPack.instance.logOutput(String.format("Items              : %d", PMPModInfo.getRegisteredItems()));
        PlantMegaPack.instance.logOutput(String.format("Recipes            : %d", PMPModInfo.getRegisteredRecipes()));
        PlantMegaPack.instance.logOutput(String.format("Chest items        : %d", PMPModInfo.getRegisteredChestItems()));
        PlantMegaPack.instance.logOutput(String.format("Worldgen decorators: %d", PlantMegaPack.worldGenerator.getDecoratorsCount()));
    }
}

