/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.bin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.MathHelper;
import plantmegapack.PlantMegaPack;

public class PMPSettings {
    protected File optionsFile;
    public boolean contentAquatic;
    public boolean contentChestSeeds;
    public boolean contentCraftingBambooBlocks;
    public boolean contentCrops;
    public boolean contentWallBracketExtra;
    public boolean plantBambooFallsWhenBroken;
    public boolean plantEffectPoison;
    public boolean plantEffectThorns;
    public boolean plantSolidShelfEpiphytes;
    public boolean tooltipAttributes;
    public boolean tooltipCategory;
    public boolean tooltipGrowthStages;
    public boolean tooltipLatinName;
    public boolean worldgenCoralReefs;
    public int worldgenEndRate;
    public int worldgenEndPasses;
    public int worldgenNetherRate;
    public int worldgenNetherPasses;
    public int worldgenOverworldRate;
    public int worldgenOverworldPasses;
    public int worldgenSkyRate;
    public int worldgenSkyPasses;
    public boolean worldgenSpawnAtFullGrowth;
    public boolean worldgenVillageCrops;
    public boolean worldgenVillagePlants;
    public int powderConditionerRadius;
    public int powderConditionerStrength;
    public int powderDefoliantRadius;
    public int powderDefoliantStrength;
    public int powderFertilizerRadius;
    public int powderFertilizerStrength;
    public int salveFireResistDuration;
    public int salveHealthHeartsHealed;
    public int salveNightVisionDuration;
    public int salveStrengthDuration;
    public int salveSwiftnessDuration;
    public int salveWaterBreathingDuration;

    public PMPSettings(String configDirPath) {
        this.optionsFile = new File(configDirPath + "settings.cfg");
        this.resetContentDefaults();
        this.resetGeneralDefaults();
        this.resetItemPowderDefaults();
        this.resetItemSalveDefaults();
        this.resetPlantDefaults();
        this.resetWorldgenDefaults();
        this.checkConfigDirs(configDirPath);
        this.loadOptions();
    }

    private void checkConfigDirs(String configDirPath) {
        File pmpConfigDir = new File(configDirPath);
        if (!pmpConfigDir.exists()) {
            try {
                pmpConfigDir.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(pmpConfigDir = new File(configDirPath + "/decorators")).exists()) {
            try {
                pmpConfigDir.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(pmpConfigDir = new File(configDirPath + "/plants")).exists()) {
            try {
                pmpConfigDir.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void resetContentDefaults() {
        this.contentAquatic = true;
        this.contentChestSeeds = true;
        this.contentCraftingBambooBlocks = true;
        this.contentCrops = true;
        this.contentWallBracketExtra = false;
    }

    public void resetGeneralDefaults() {
        this.tooltipAttributes = true;
        this.tooltipCategory = true;
        this.tooltipGrowthStages = true;
        this.tooltipLatinName = true;
        this.powderDefoliantRadius = 3;
        this.powderDefoliantStrength = 70;
        this.powderFertilizerRadius = 3;
        this.powderFertilizerStrength = 70;
    }

    public void resetItemPowderDefaults() {
        this.powderConditionerRadius = 2;
        this.powderConditionerStrength = 90;
        this.powderDefoliantRadius = 2;
        this.powderDefoliantStrength = 90;
        this.powderFertilizerRadius = 2;
        this.powderFertilizerStrength = 90;
    }

    public void resetItemSalveDefaults() {
        this.salveFireResistDuration = 30;
        this.salveHealthHeartsHealed = 20;
        this.salveNightVisionDuration = 30;
        this.salveStrengthDuration = 30;
        this.salveSwiftnessDuration = 30;
        this.salveWaterBreathingDuration = 30;
    }

    public void resetPlantDefaults() {
        this.plantBambooFallsWhenBroken = true;
        this.plantEffectPoison = false;
        this.plantEffectThorns = true;
        this.plantSolidShelfEpiphytes = true;
    }

    public void resetWorldgenDefaults() {
        this.worldgenCoralReefs = true;
        this.worldgenSpawnAtFullGrowth = false;
        this.worldgenVillageCrops = true;
        this.worldgenVillagePlants = true;
        this.resetWorldgenEnd();
        this.resetWorldgenNether();
        this.resetWorldgenOverworld();
        this.resetWorldgenSky();
    }

    public void resetWorldgenEnd() {
        this.worldgenEndRate = 50;
        this.worldgenEndPasses = 4;
    }

    public void resetWorldgenNether() {
        this.worldgenNetherRate = 50;
        this.worldgenNetherPasses = 4;
    }

    public void resetWorldgenOverworld() {
        this.worldgenOverworldRate = 90;
        this.worldgenOverworldPasses = 8;
    }

    public void resetWorldgenSky() {
        this.worldgenSkyRate = 50;
        this.worldgenSkyPasses = 4;
    }

    public void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                this.saveOptions();
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.optionsFile));
            String line = "";
            while ((line = bufferedreader.readLine()) != null) {
                try {
                    String[] optionLine = line.split(":");
                    if (optionLine[0].equals("contentAquatic")) {
                        this.contentAquatic = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("contentChestSeeds")) {
                        this.contentChestSeeds = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("contentCraftingBambooBlocks")) {
                        this.contentCraftingBambooBlocks = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("contentCrops")) {
                        this.contentCrops = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("contentWallBracketExtra")) {
                        this.contentWallBracketExtra = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("plantBambooFallsWhenBroken")) {
                        this.plantBambooFallsWhenBroken = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("plantEffectPoison")) {
                        this.plantEffectPoison = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("plantEffectThorns")) {
                        this.plantEffectThorns = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("plantSolidShelfEpiphyte")) {
                        this.plantSolidShelfEpiphytes = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("tooltipAttributes")) {
                        this.tooltipAttributes = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("tooltipCategory")) {
                        this.tooltipCategory = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("tooltipGrowthStages")) {
                        this.tooltipGrowthStages = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("tooltipLatinName")) {
                        this.tooltipLatinName = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("worldgenCoralReefs")) {
                        this.worldgenCoralReefs = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("worldgenEndRate")) {
                        this.worldgenEndRate = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("worldgenEndPasses")) {
                        this.worldgenEndPasses = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("worldgenNetherRate")) {
                        this.worldgenNetherRate = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("worldgenNetherPasses")) {
                        this.worldgenNetherPasses = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("worldgenOverworldRate")) {
                        this.worldgenOverworldRate = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("worldgenOverworldPasses")) {
                        this.worldgenOverworldPasses = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("worldgenRateSky")) {
                        this.worldgenSkyRate = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("worldgenSkyPasses")) {
                        this.worldgenSkyPasses = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("worldgenSpawnAtFullGrowth")) {
                        this.worldgenSpawnAtFullGrowth = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("worldgenVillageCrops")) {
                        this.worldgenVillageCrops = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("worldgenVillagePlants")) {
                        this.worldgenVillagePlants = optionLine[1].equals("true");
                    }
                    if (optionLine[0].equals("powderConditionerRadius")) {
                        this.powderConditionerRadius = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("powderConditionerStrength")) {
                        this.powderConditionerStrength = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("powderDefoliantRadius")) {
                        this.powderDefoliantRadius = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("powderDefoliantStrength")) {
                        this.powderDefoliantStrength = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("powderFertilizerRadius")) {
                        this.powderFertilizerRadius = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("powderFertilizerStrength")) {
                        this.powderFertilizerStrength = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("salveFireResistDuration")) {
                        this.salveFireResistDuration = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("salveHealthDuration")) {
                        this.salveHealthHeartsHealed = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("salveNightVisionDuration")) {
                        this.salveNightVisionDuration = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("salveStrengthDuration")) {
                        this.salveStrengthDuration = Integer.parseInt(optionLine[1]);
                    }
                    if (optionLine[0].equals("salveSwiftnessDuration")) {
                        this.salveSwiftnessDuration = Integer.parseInt(optionLine[1]);
                    }
                    if (!optionLine[0].equals("salveWaterBreathingDuration")) continue;
                    this.salveWaterBreathingDuration = Integer.parseInt(optionLine[1]);
                }
                catch (Exception exception) {
                    PlantMegaPack.instance.logOutput("Skipping bad option: " + line);
                }
            }
            bufferedreader.close();
        }
        catch (Exception exception1) {
            PlantMegaPack.instance.logOutput("Failed to load options");
            return;
        }
        PlantMegaPack.instance.logOutput("Config file loaded: settings.cfg");
    }

    public void saveOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            printwriter.println("contentAquatic:" + this.contentAquatic);
            printwriter.println("contentChestSeeds:" + this.contentChestSeeds);
            printwriter.println("contentCraftingBambooBlocks:" + this.contentCraftingBambooBlocks);
            printwriter.println("contentCrops:" + this.contentCrops);
            printwriter.println("contentWallBracketExtra:" + this.contentWallBracketExtra);
            printwriter.println("plantBambooFallsWhenBroken:" + this.plantBambooFallsWhenBroken);
            printwriter.println("plantEffectPoison:" + this.plantEffectPoison);
            printwriter.println("plantEffectThorns:" + this.plantEffectThorns);
            printwriter.println("plantSolidShelfEpiphyte:" + this.plantSolidShelfEpiphytes);
            printwriter.println("tooltipAttributes:" + this.tooltipAttributes);
            printwriter.println("tooltipCategory:" + this.tooltipCategory);
            printwriter.println("tooltipGrowthStages:" + this.tooltipGrowthStages);
            printwriter.println("tooltipLatinName:" + this.tooltipLatinName);
            printwriter.println("worldgenCoralReefs:" + this.worldgenCoralReefs);
            printwriter.println("worldgenEndRate:" + this.worldgenEndRate);
            printwriter.println("worldgenEndPasses:" + this.worldgenEndPasses);
            printwriter.println("worldgenNetherRate:" + this.worldgenNetherRate);
            printwriter.println("worldgenNetherPasses:" + this.worldgenNetherPasses);
            printwriter.println("worldgenOverworldRate:" + this.worldgenOverworldRate);
            printwriter.println("worldgenOverworldPasses:" + this.worldgenOverworldPasses);
            printwriter.println("worldgenSkyRate:" + this.worldgenSkyRate);
            printwriter.println("worldgenSkyPasses:" + this.worldgenSkyPasses);
            printwriter.println("worldgenSpawnAtFullGrowth:" + this.worldgenSpawnAtFullGrowth);
            printwriter.println("worldgenVillageCrops:" + this.worldgenVillageCrops);
            printwriter.println("worldgenVillagePlants:" + this.worldgenVillagePlants);
            printwriter.println("powderConditionerRadius:" + this.powderConditionerRadius);
            printwriter.println("powderConditionerStrength:" + this.powderConditionerStrength);
            printwriter.println("powderDefoliantRadius:" + this.powderDefoliantRadius);
            printwriter.println("powderDefoliantStrength:" + this.powderDefoliantStrength);
            printwriter.println("powderFertilizerRadius:" + this.powderFertilizerRadius);
            printwriter.println("powderFertilizerStrength:" + this.powderFertilizerStrength);
            printwriter.println("salveFireResistDuration:" + this.salveFireResistDuration);
            printwriter.println("salveHealthHeartsHealed:" + this.salveHealthHeartsHealed);
            printwriter.println("salveNightVisionDuration:" + this.salveNightVisionDuration);
            printwriter.println("salveStrengthDuration:" + this.salveStrengthDuration);
            printwriter.println("salveSwiftnessDuration:" + this.salveSwiftnessDuration);
            printwriter.println("salveWaterBreathingDuration:" + this.salveWaterBreathingDuration);
            printwriter.close();
        }
        catch (Exception exception) {
            PlantMegaPack.instance.logOutput("Failed to save options");
            return;
        }
        PlantMegaPack.instance.logOutput("Config file saved: settings.cfg");
    }

    public void setOptionValue(PMPOptions option, int value) {
        if (option == PMPOptions.CONTENT_AQUATIC) {
            boolean bl = this.contentAquatic = !this.contentAquatic;
        }
        if (option == PMPOptions.CONTENT_CHEST_SEEDS) {
            boolean bl = this.contentChestSeeds = !this.contentChestSeeds;
        }
        if (option == PMPOptions.CONTENT_CRAFTING_BAMBOOBLOCKS) {
            boolean bl = this.contentCraftingBambooBlocks = !this.contentCraftingBambooBlocks;
        }
        if (option == PMPOptions.CONTENT_CROPS) {
            boolean bl = this.contentCrops = !this.contentCrops;
        }
        if (option == PMPOptions.CONTENT_WALLBRACKETEXTRA) {
            boolean bl = this.contentWallBracketExtra = !this.contentWallBracketExtra;
        }
        if (option == PMPOptions.PLANT_BAMBOOFALLSWHENBROKEN) {
            boolean bl = this.plantBambooFallsWhenBroken = !this.plantBambooFallsWhenBroken;
        }
        if (option == PMPOptions.PLANT_EFFECT_POISON) {
            boolean bl = this.plantEffectPoison = !this.plantEffectPoison;
        }
        if (option == PMPOptions.PLANT_EFFECT_THORNS) {
            boolean bl = this.plantEffectThorns = !this.plantEffectThorns;
        }
        if (option == PMPOptions.PLANT_SOLIDSHELFEPIPHYTES) {
            boolean bl = this.plantSolidShelfEpiphytes = !this.plantSolidShelfEpiphytes;
        }
        if (option == PMPOptions.TOOLTIP_ATTRIBUTES) {
            boolean bl = this.tooltipAttributes = !this.tooltipAttributes;
        }
        if (option == PMPOptions.TOOLTIP_CATEGORY) {
            boolean bl = this.tooltipCategory = !this.tooltipCategory;
        }
        if (option == PMPOptions.TOOLTIP_GROWTH_STAGES) {
            boolean bl = this.tooltipGrowthStages = !this.tooltipGrowthStages;
        }
        if (option == PMPOptions.TOOLTIP_LATIN_NAME) {
            boolean bl = this.tooltipLatinName = !this.tooltipLatinName;
        }
        if (option == PMPOptions.WORLDGEN_CORALREEFS) {
            boolean bl = this.worldgenCoralReefs = !this.worldgenCoralReefs;
        }
        if (option == PMPOptions.WORLDGEN_END_RATE) {
            this.worldgenEndRate = value;
        }
        if (option == PMPOptions.WORLDGEN_END_PASSES) {
            this.worldgenEndPasses = value;
        }
        if (option == PMPOptions.WORLDGEN_NETHER_RATE) {
            this.worldgenNetherRate = value;
        }
        if (option == PMPOptions.WORLDGEN_NETHER_PASSES) {
            this.worldgenNetherPasses = value;
        }
        if (option == PMPOptions.WORLDGEN_OVERWORLD_RATE) {
            this.worldgenOverworldRate = value;
        }
        if (option == PMPOptions.WORLDGEN_OVERWORLD_PASSES) {
            this.worldgenOverworldPasses = value;
        }
        if (option == PMPOptions.WORLDGEN_SKY_RATE) {
            this.worldgenSkyRate = value;
        }
        if (option == PMPOptions.WORLDGEN_SKY_PASSES) {
            this.worldgenSkyPasses = value;
        }
        if (option == PMPOptions.WORLDGEN_SPAWNATFULLGROWTH) {
            boolean bl = this.worldgenSpawnAtFullGrowth = !this.worldgenSpawnAtFullGrowth;
        }
        if (option == PMPOptions.WORLDGEN_VILLAGE_CROPS) {
            boolean bl = this.worldgenVillageCrops = !this.worldgenVillageCrops;
        }
        if (option == PMPOptions.WORLDGEN_VILLAGE_PLANTS) {
            boolean bl = this.worldgenVillagePlants = !this.worldgenVillagePlants;
        }
        if (option == PMPOptions.POWDER_CONDITIONER_RADIUS) {
            this.powderConditionerRadius = value;
        }
        if (option == PMPOptions.POWDER_CONDITIONER_STRENGTH) {
            this.powderConditionerStrength = value;
        }
        if (option == PMPOptions.POWDER_DEFOLIANT_RADIUS) {
            this.powderDefoliantRadius = value;
        }
        if (option == PMPOptions.POWDER_DEFOLIANT_STRENGTH) {
            this.powderDefoliantStrength = value;
        }
        if (option == PMPOptions.POWDER_FERTILIZER_RADIUS) {
            this.powderFertilizerRadius = value;
        }
        if (option == PMPOptions.POWDER_FERTILIZER_STRENGTH) {
            this.powderFertilizerStrength = value;
        }
        if (option == PMPOptions.SALVE_FIRERESIST_DURATION) {
            this.salveFireResistDuration = value;
        }
        if (option == PMPOptions.SALVE_HEALTH_HEARTSHEALED) {
            this.salveHealthHeartsHealed = value;
        }
        if (option == PMPOptions.SALVE_NIGHVISION_DURATION) {
            this.salveNightVisionDuration = value;
        }
        if (option == PMPOptions.SALVE_STRENGTH_DURATION) {
            this.salveStrengthDuration = value;
        }
        if (option == PMPOptions.SALVE_SWIFTNESS_DURATION) {
            this.salveSwiftnessDuration = value;
        }
        if (option == PMPOptions.SALVE_WATERBREATHING_DURATION) {
            this.salveWaterBreathingDuration = value;
        }
    }

    public void setOptionIntValue(PMPOptions option, int value) {
        if (option == PMPOptions.WORLDGEN_END_RATE) {
            this.worldgenEndRate = value;
        }
        if (option == PMPOptions.WORLDGEN_END_PASSES) {
            this.worldgenEndPasses = value;
        }
        if (option == PMPOptions.WORLDGEN_NETHER_RATE) {
            this.worldgenNetherRate = value;
        }
        if (option == PMPOptions.WORLDGEN_NETHER_PASSES) {
            this.worldgenNetherPasses = value;
        }
        if (option == PMPOptions.WORLDGEN_OVERWORLD_RATE) {
            this.worldgenOverworldRate = value;
        }
        if (option == PMPOptions.WORLDGEN_OVERWORLD_PASSES) {
            this.worldgenOverworldPasses = value;
        }
        if (option == PMPOptions.WORLDGEN_SKY_RATE) {
            this.worldgenSkyRate = value;
        }
        if (option == PMPOptions.WORLDGEN_SKY_PASSES) {
            this.worldgenSkyPasses = value;
        }
        if (option == PMPOptions.POWDER_CONDITIONER_RADIUS) {
            this.powderConditionerRadius = value;
        }
        if (option == PMPOptions.POWDER_CONDITIONER_STRENGTH) {
            this.powderConditionerStrength = value;
        }
        if (option == PMPOptions.POWDER_DEFOLIANT_RADIUS) {
            this.powderDefoliantRadius = value;
        }
        if (option == PMPOptions.POWDER_DEFOLIANT_STRENGTH) {
            this.powderDefoliantStrength = value;
        }
        if (option == PMPOptions.POWDER_FERTILIZER_RADIUS) {
            this.powderFertilizerRadius = value;
        }
        if (option == PMPOptions.POWDER_FERTILIZER_STRENGTH) {
            this.powderFertilizerStrength = value;
        }
        if (option == PMPOptions.SALVE_FIRERESIST_DURATION) {
            this.salveFireResistDuration = value;
        }
        if (option == PMPOptions.SALVE_HEALTH_HEARTSHEALED) {
            this.salveHealthHeartsHealed = value;
        }
        if (option == PMPOptions.SALVE_NIGHVISION_DURATION) {
            this.salveNightVisionDuration = value;
        }
        if (option == PMPOptions.SALVE_STRENGTH_DURATION) {
            this.salveStrengthDuration = value;
        }
        if (option == PMPOptions.SALVE_SWIFTNESS_DURATION) {
            this.salveSwiftnessDuration = value;
        }
        if (option == PMPOptions.SALVE_WATERBREATHING_DURATION) {
            this.salveWaterBreathingDuration = value;
        }
    }

    public float getOptionFloatValue(PMPOptions option) {
        switch (SwitchOptions.optionIds[option.ordinal()]) {
            case 13: {
                return this.worldgenEndRate;
            }
            case 14: {
                return this.worldgenEndPasses;
            }
            case 15: {
                return this.worldgenNetherRate;
            }
            case 16: {
                return this.worldgenNetherPasses;
            }
            case 17: {
                return this.worldgenOverworldRate;
            }
            case 18: {
                return this.worldgenOverworldPasses;
            }
            case 19: {
                return this.worldgenSkyRate;
            }
            case 20: {
                return this.worldgenSkyPasses;
            }
            case 24: {
                return this.powderConditionerRadius;
            }
            case 25: {
                return this.powderConditionerStrength;
            }
            case 26: {
                return this.powderDefoliantRadius;
            }
            case 27: {
                return this.powderDefoliantStrength;
            }
            case 28: {
                return this.powderFertilizerRadius;
            }
            case 29: {
                return this.powderFertilizerStrength;
            }
            case 30: {
                return this.salveFireResistDuration;
            }
            case 31: {
                return this.salveHealthHeartsHealed;
            }
            case 32: {
                return this.salveNightVisionDuration;
            }
            case 33: {
                return this.salveStrengthDuration;
            }
            case 34: {
                return this.salveSwiftnessDuration;
            }
            case 35: {
                return this.salveWaterBreathingDuration;
            }
        }
        return 0.0f;
    }

    public boolean getOptionOrdinalValue(PMPOptions option) {
        switch (SwitchOptions.optionIds[option.ordinal()]) {
            case 1: {
                return this.contentAquatic;
            }
            case 2: {
                return this.contentCraftingBambooBlocks;
            }
            case 3: {
                return this.contentCrops;
            }
            case 4: {
                return this.plantBambooFallsWhenBroken;
            }
            case 5: {
                return this.plantEffectPoison;
            }
            case 6: {
                return this.plantEffectThorns;
            }
            case 7: {
                return this.plantSolidShelfEpiphytes;
            }
            case 8: {
                return this.tooltipAttributes;
            }
            case 9: {
                return this.tooltipCategory;
            }
            case 10: {
                return this.tooltipGrowthStages;
            }
            case 11: {
                return this.tooltipLatinName;
            }
            case 12: {
                return this.worldgenCoralReefs;
            }
            case 21: {
                return this.worldgenSpawnAtFullGrowth;
            }
            case 22: {
                return this.worldgenVillageCrops;
            }
            case 23: {
                return this.worldgenVillagePlants;
            }
            case 36: {
                return this.contentWallBracketExtra;
            }
            case 37: {
                return this.contentChestSeeds;
            }
        }
        return false;
    }

    public String getKeyBinding(PMPOptions option) {
        String s = I18n.func_135052_a((String)option.getEnumString(), (Object[])new Object[0]) + ": ";
        if (option.getEnumBoolean()) {
            boolean flag = this.getOptionOrdinalValue(option);
            return flag ? s + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : s + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        }
        return s;
    }

    static final class SwitchOptions {
        static final int[] optionIds = new int[PMPOptions.values().length];

        SwitchOptions() {
        }

        static {
            try {
                SwitchOptions.optionIds[PMPOptions.CONTENT_AQUATIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.CONTENT_CRAFTING_BAMBOOBLOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.CONTENT_CROPS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.PLANT_BAMBOOFALLSWHENBROKEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.PLANT_EFFECT_POISON.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.PLANT_EFFECT_THORNS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.PLANT_SOLIDSHELFEPIPHYTES.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.TOOLTIP_ATTRIBUTES.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.TOOLTIP_CATEGORY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.TOOLTIP_GROWTH_STAGES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.TOOLTIP_LATIN_NAME.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_CORALREEFS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_END_RATE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_END_PASSES.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_NETHER_RATE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_NETHER_PASSES.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_OVERWORLD_RATE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_OVERWORLD_PASSES.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_SKY_RATE.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_SKY_PASSES.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_SPAWNATFULLGROWTH.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_VILLAGE_CROPS.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.WORLDGEN_VILLAGE_PLANTS.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.POWDER_CONDITIONER_RADIUS.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.POWDER_CONDITIONER_STRENGTH.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.POWDER_DEFOLIANT_RADIUS.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.POWDER_DEFOLIANT_STRENGTH.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.POWDER_FERTILIZER_RADIUS.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.POWDER_FERTILIZER_STRENGTH.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.SALVE_FIRERESIST_DURATION.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.SALVE_HEALTH_HEARTSHEALED.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.SALVE_NIGHVISION_DURATION.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.SALVE_STRENGTH_DURATION.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.SALVE_SWIFTNESS_DURATION.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.SALVE_WATERBREATHING_DURATION.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.CONTENT_WALLBRACKETEXTRA.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchOptions.optionIds[PMPOptions.CONTENT_CHEST_SEEDS.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static enum PMPOptions {
        CONTENT_AQUATIC("option.contentAquatic", false, true),
        CONTENT_CRAFTING_BAMBOOBLOCKS("option.contentCraftingBambooBlocks", false, true),
        CONTENT_CROPS("option.contentCrops", false, true),
        PLANT_BAMBOOFALLSWHENBROKEN("option.plantBambooFallsWhenBroken", false, true),
        PLANT_EFFECT_POISON("option.plantEffectPoison", false, true),
        PLANT_EFFECT_THORNS("option.plantEffectThorns", false, true),
        PLANT_SOLIDSHELFEPIPHYTES("option.plantSolidShelfEpiphytes", false, true),
        TOOLTIP_ATTRIBUTES("option.tooltipAttributes", false, true),
        TOOLTIP_CATEGORY("option.tooltipCategory", false, true),
        TOOLTIP_GROWTH_STAGES("option.tooltipGrowthStages", false, true),
        TOOLTIP_LATIN_NAME("option.tooltipLatinName", false, true),
        WORLDGEN_CORALREEFS("option.worldgenCoralReefs", false, true),
        WORLDGEN_END_RATE("option.worldgenEndRate", true, false, 1.0f, 100.0f, 1.0f),
        WORLDGEN_END_PASSES("option.worldgenEndPasses", true, false, 1.0f, 24.0f, 1.0f),
        WORLDGEN_NETHER_RATE("option.worldgenNetherRate", true, false, 1.0f, 100.0f, 1.0f),
        WORLDGEN_NETHER_PASSES("option.worldgenNetherPasses", true, false, 1.0f, 24.0f, 1.0f),
        WORLDGEN_OVERWORLD_RATE("option.worldgenOverworldRate", true, false, 1.0f, 100.0f, 1.0f),
        WORLDGEN_OVERWORLD_PASSES("option.worldgenOverworldPasses", true, false, 1.0f, 24.0f, 1.0f),
        WORLDGEN_SKY_RATE("option.worldgenSkyRate", true, false, 1.0f, 100.0f, 1.0f),
        WORLDGEN_SKY_PASSES("option.worldgenSkyPasses", true, false, 1.0f, 24.0f, 1.0f),
        WORLDGEN_SPAWNATFULLGROWTH("option.worldgenSpawnAtFullGrowth", false, true),
        WORLDGEN_VILLAGE_CROPS("option.worldgenVillageCrops", false, true),
        WORLDGEN_VILLAGE_PLANTS("option.worldgenVillagePlants", false, true),
        POWDER_CONDITIONER_RADIUS("option.powderConditionerRadius", true, false, 1.0f, 4.0f, 1.0f),
        POWDER_CONDITIONER_STRENGTH("option.powderConditionerStrength", true, false, 1.0f, 100.0f, 1.0f),
        POWDER_DEFOLIANT_RADIUS("option.powderDefoliantRadius", true, false, 1.0f, 4.0f, 1.0f),
        POWDER_DEFOLIANT_STRENGTH("option.powderDefoliantStrength", true, false, 1.0f, 100.0f, 1.0f),
        POWDER_FERTILIZER_RADIUS("option.powderFertilizerRadius", true, false, 1.0f, 4.0f, 1.0f),
        POWDER_FERTILIZER_STRENGTH("option.powderFertilizerStrength", true, false, 1.0f, 100.0f, 1.0f),
        SALVE_FIRERESIST_DURATION("option.salveFireResistDuration", true, false, 10.0f, 60.0f, 1.0f),
        SALVE_HEALTH_HEARTSHEALED("salveHealthHeartsHealed", true, false, 2.0f, 8.0f, 1.0f),
        SALVE_NIGHVISION_DURATION("salveNightVisionDuration", true, false, 10.0f, 60.0f, 1.0f),
        SALVE_STRENGTH_DURATION("salveStrengthDuration", true, false, 10.0f, 60.0f, 1.0f),
        SALVE_SWIFTNESS_DURATION("salveSwiftnessDuration", true, false, 10.0f, 60.0f, 1.0f),
        SALVE_WATERBREATHING_DURATION("salveWaterBreathingDuration", true, false, 10.0f, 60.0f, 1.0f),
        CONTENT_WALLBRACKETEXTRA("option.contentWallBracketExtra", false, true),
        CONTENT_CHEST_SEEDS("option.contentChestSeeds", false, true);

        private final boolean enumFloat;
        private final boolean enumBoolean;
        private final String enumString;
        private final float valueStep;
        private float valueMin;
        private float valueMax;

        public static PMPOptions getEnumOptions(int ordinal) {
            for (PMPOptions options : PMPOptions.values()) {
                if (options.returnEnumOrdinal() != ordinal) continue;
                return options;
            }
            return null;
        }

        private PMPOptions(String stringValue, boolean floatValue, boolean booleanValue, float valueMin, float valueMax, float valueStep, Object object) {
            this(stringValue, floatValue, booleanValue, valueMin, valueMax, valueStep);
        }

        private PMPOptions(String stringValue, boolean floatValue, boolean booleanValue) {
            this(stringValue, floatValue, booleanValue, 0.0f, 1.0f, 0.0f);
        }

        private PMPOptions(String stringValue, boolean floatValue, boolean booleanValue, float valueMin, float valueMax, float valueStep) {
            this.enumString = stringValue;
            this.enumFloat = floatValue;
            this.enumBoolean = booleanValue;
            this.valueMin = valueMin;
            this.valueMax = valueMax;
            this.valueStep = valueStep;
        }

        public boolean getEnumFloat() {
            return this.enumFloat;
        }

        public boolean getEnumBoolean() {
            return this.enumBoolean;
        }

        public int returnEnumOrdinal() {
            return this.ordinal();
        }

        public String getEnumString() {
            return this.enumString;
        }

        public float getValueMax() {
            return this.valueMax;
        }

        public void setValueMax(float valueMax) {
            this.valueMax = valueMax;
        }

        public float normalizeValue(float value) {
            return MathHelper.func_76131_a((float)((this.snapToStepClamp(value) - this.valueMin) / (this.valueMax - this.valueMin)), (float)0.0f, (float)1.0f);
        }

        public float denormalizeValue(float value) {
            return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
        }

        public float snapToStepClamp(float value) {
            value = this.snapToStep(value);
            return MathHelper.func_76131_a((float)value, (float)this.valueMin, (float)this.valueMax);
        }

        protected float snapToStep(float value) {
            if (this.valueStep > 0.0f) {
                value = this.valueStep * (float)Math.round(value / this.valueStep);
            }
            return value;
        }
    }
}

