/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen.tree;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.core.def.DefTree;
import pmp.worldgen.tree.GenTreeBase;

public class GenBirchWhite
extends GenTreeBase {
    private boolean useRandomLeaves;

    public GenBirchWhite(DefTree defTree, boolean notify) {
        super(defTree, notify);
        this.useRandomLeaves = !notify;
        this.stateLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
        switch (defTree) {
            default: {
                this.stateLeaves = PlantMegaPack.objects.getLeaves(DefTree.BIRCH_WHTGR).func_176223_P();
                break;
            }
            case BIRCH_WHTYE: {
                this.stateLeaves = PlantMegaPack.objects.getLeaves(DefTree.BIRCH_WHTYE).func_176223_P();
                break;
            }
            case BIRCH_WHTOR: {
                this.stateLeaves = PlantMegaPack.objects.getLeaves(DefTree.BIRCH_WHTOR).func_176223_P();
                break;
            }
            case BIRCH_WHTRE: {
                this.stateLeaves = PlantMegaPack.objects.getLeaves(DefTree.BIRCH_WHTRE).func_176223_P();
            }
        }
        this.stateLeaves = this.stateLeaves.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!this.canTreeGrowAtPos(world, pos)) {
            return false;
        }
        int trunkHeight = rand.nextInt(10) + 4 + rand.nextInt(this.addRandomHeight);
        if (trunkHeight >= world.func_72800_K() - 2) {
            return false;
        }
        if (this.useRandomLeaves) {
            int randVal = rand.nextInt(100);
            this.stateLeaves = randVal < 70 ? PlantMegaPack.objects.getLeaves(DefTree.BIRCH_WHTGR).func_176223_P() : (randVal < 80 ? PlantMegaPack.objects.getLeaves(DefTree.BIRCH_WHTRE).func_176223_P() : (randVal < 90 ? PlantMegaPack.objects.getLeaves(DefTree.BIRCH_WHTOR).func_176223_P() : PlantMegaPack.objects.getLeaves(DefTree.BIRCH_WHTYE).func_176223_P()));
            this.stateLeaves = this.stateLeaves.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        }
        BlockPos posSoil = pos.func_177977_b();
        IBlockState stateSoil = world.func_180495_p(posSoil);
        stateSoil.func_177230_c().onPlantGrow(stateSoil, world, posSoil, pos);
        for (int trunkY = pos.func_177956_o(); trunkY <= pos.func_177956_o() + trunkHeight; ++trunkY) {
            BlockPos posTrunk = new BlockPos(pos.func_177958_n(), trunkY, pos.func_177952_p());
            this.func_175903_a(world, posTrunk, this.stateLog);
            if (trunkY < pos.func_177956_o() + 2) continue;
            if (rand.nextInt(3) > 0) {
                this.func_175903_a(world, posTrunk.func_177978_c(), this.stateLeaves);
            }
            if (rand.nextInt(3) > 0) {
                this.func_175903_a(world, posTrunk.func_177968_d(), this.stateLeaves);
            }
            if (rand.nextInt(3) > 0) {
                this.func_175903_a(world, posTrunk.func_177974_f(), this.stateLeaves);
            }
            if (rand.nextInt(3) <= 0) continue;
            this.func_175903_a(world, posTrunk.func_177976_e(), this.stateLeaves);
        }
        this.func_175903_a(world, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + trunkHeight + 1, pos.func_177952_p()), this.stateLeaves);
        return true;
    }
}

