/*
 * Decompiled with CFR 0.152.
 */
package pmp.worldgen;

import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pmp.PlantMegaPack;
import pmp.block.BlockTreeSapling;
import pmp.core.data.DataHabitatTree;
import pmp.worldgen.WorldgenGenData;
import pmp.worldgen.WorldgenHelpers;

public abstract class GenTree {
    public static void generateTree(WorldgenGenData genData, DataHabitatTree dataHabitatTree) {
        if (!GenTree.canTreeSpawnAtLocation(genData.world, genData.posSpawn, dataHabitatTree.getDefTree().canGrowOnSand, genData.dataBiome.treeCanReplacePlants, genData.dataBiome.treeCanReplaceSnow)) {
            return;
        }
        BlockTreeSapling sapling = (BlockTreeSapling)PlantMegaPack.objects.getSapling(dataHabitatTree.getDefTree());
        IBlockState stateSapling = sapling.func_176223_P();
        sapling.generateTree(genData.world, genData.posSpawn, stateSapling, genData.random);
    }

    public static boolean canTreeSpawnAtLocation(World world, BlockPos pos, boolean includeSand, boolean canReplacePlants, boolean canReplaceSnow) {
        IBlockState stateSpawn = world.func_180495_p(pos);
        IBlockState stateSoil = world.func_180495_p(pos.func_177977_b());
        if (!(canReplacePlants || stateSpawn.func_185904_a() != Material.field_151577_b && stateSpawn.func_185904_a() != Material.field_151585_k && stateSpawn.func_185904_a() != Material.field_151582_l)) {
            return false;
        }
        if (!canReplaceSnow && stateSpawn.func_185904_a() == Material.field_151597_y) {
            return false;
        }
        if (!world.func_175710_j(pos.func_177984_a())) {
            return false;
        }
        if (stateSoil.func_177230_c() instanceof BlockFarmland) {
            return false;
        }
        if (!GenTree.isTreeRadiusClear(world, pos.func_177984_a(), PlantMegaPack.settings.worldgenThresholdTreeSpawnRadius)) {
            return false;
        }
        if (stateSoil.func_185904_a() == Material.field_151595_p) {
            return includeSand && WorldgenHelpers.isTreeSoilBlock(world, pos.func_177977_b());
        }
        return WorldgenHelpers.isLandPlantSoilBlock(world, pos.func_177977_b());
    }

    private static boolean isTreeRadiusClear(World world, BlockPos pos, int radius) {
        for (int ix = -radius; ix <= radius; ++ix) {
            for (int iz = -radius; iz <= radius; ++iz) {
                BlockPos posTest = new BlockPos(pos.func_177958_n() + ix, pos.func_177956_o(), pos.func_177952_p() + iz);
                if (!world.func_180495_p(posTest = world.func_175672_r(posTest)).func_177230_c().isWood((IBlockAccess)world, posTest)) continue;
                return false;
            }
        }
        return true;
    }
}

