/*
 * Decompiled with CFR 0.152.
 */
package pmp.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public abstract class TileEntityBase
extends TileEntityLockable
implements IInventory,
IInteractionObject {
    private int numPlayersUsing = 0;
    private String name = null;
    protected NonNullList<ItemStack> storageItems = null;

    public TileEntityBase(String name, int slotCount) {
        try {
            if (name == null || name.isEmpty()) {
                throw new Exception("TileEntityBase constructor 'name' cannot be null or empty.");
            }
            if (slotCount < 1) {
                throw new Exception("TileEntityBase constructor 'slotCount' cannot be less than 1.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.name = name;
        if (slotCount > 0) {
            this.storageItems = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
        }
    }

    public String func_70005_c_() {
        return String.format("container.%s", this.name);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public String func_174875_k() {
        return String.format("%s:%s", "pmp", this.name);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.storageItems == null ? 0 : this.storageItems.size();
    }

    public boolean func_191420_l() {
        if (this.storageItems == null) {
            return true;
        }
        for (ItemStack itemstack : this.storageItems) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (this.storageItems == null) {
            return ItemStack.field_190927_a;
        }
        return index >= 0 && index < this.storageItems.size() ? (ItemStack)this.storageItems.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.storageItems == null) {
            return ItemStack.field_190927_a;
        }
        return ItemStackHelper.func_188382_a(this.storageItems, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        if (this.storageItems == null) {
            return ItemStack.field_190927_a;
        }
        return ItemStackHelper.func_188383_a(this.storageItems, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.storageItems == null) {
            return;
        }
        if (index >= 0 && index < this.storageItems.size()) {
            this.storageItems.set(index, (Object)stack);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.storageItems == null) {
            return;
        }
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.storageItems == null) {
            return;
        }
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (this.storageItems == null) {
            return false;
        }
        return index >= 0 && index < this.storageItems.size();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        if (this.storageItems == null) {
            return;
        }
        for (int index = 0; index < this.storageItems.size(); ++index) {
            this.storageItems.set(index, (Object)ItemStack.field_190927_a);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.storageItems == null) {
            return;
        }
        this.storageItems = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.storageItems);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.storageItems != null) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.storageItems);
        }
        return compound;
    }

    public boolean func_145842_c(int id, int type) {
        boolean retValue = super.func_145842_c(id, type);
        if (id == 1) {
            this.numPlayersUsing = type;
            retValue = true;
        }
        return retValue;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        int metadata = this.func_145832_p();
        return new SPacketUpdateTileEntity(this.field_174879_c, metadata, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState != newSate;
    }

    public boolean canOperate() {
        return true;
    }
}

