/*
 * Decompiled with CFR 0.152.
 */
package pmp.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.block.BlockTreeFruit;
import pmp.core.def.DefFood;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;
import pmp.core.type.TypeFood;
import pmp.item.ItemTooltips;

public class ItemBaseFood
extends ItemFood
implements IPlantable {
    protected DefFood defFood;

    public ItemBaseFood(DefFood food) {
        super(food.healAmount, food.saturation, false);
        this.defFood = food;
        if (this.defFood.foodType.isSingleStackFood()) {
            this.field_77777_bU = 1;
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.defFood.foodType == TypeFood.DRINK ? EnumAction.DRINK : EnumAction.EAT;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.defFood.foodType == TypeFood.SALVE) {
            return this.useSalve(player, world, pos, hand, facing);
        }
        DefTree defTree = DefTree.getTreeDefFromFood(this.defFood);
        if (defTree != null && facing == EnumFacing.DOWN) {
            return this.plantTreeFruit(player, world, pos, hand, facing, defTree);
        }
        DefPlant defPlant = null;
        switch (this.defFood) {
            case SEEDF_LENTI: {
                defPlant = DefPlant.CROPL_LENTI;
                break;
            }
            case SEEDF_PEANU: {
                defPlant = DefPlant.CROPL_PEANU;
                break;
            }
            case SEEDF_QUINO: {
                defPlant = DefPlant.CROPL_QUINO;
                break;
            }
            case SEEDF_RICE: {
                defPlant = DefPlant.CROPA_ASIAR;
                break;
            }
            case SEEDF_SOYBE: {
                defPlant = DefPlant.CROPL_SOYBE;
                break;
            }
            default: {
                return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
            }
        }
        Block blockPlant = PlantMegaPack.objects.getPlant(defPlant);
        IBlockState state = world.func_180495_p(pos);
        ItemStack itemstack = player.func_184586_b(hand);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, itemstack) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this) && world.func_175623_d(pos.func_177984_a())) {
            world.func_180501_a(pos.func_177984_a(), blockPlant.func_176223_P(), 2);
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult useSalve(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing) {
        switch (this.defFood) {
            case SALVE_FIRER: {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)12), PlantMegaPack.settings.salveDurationFireResist * 20, 1));
                break;
            }
            case SALVE_HEALT: {
                if (player.func_70996_bM()) {
                    float maxHealth = player.func_110138_aP();
                    float healAmount = maxHealth / 100.0f * (float)PlantMegaPack.settings.salveAmountHealth;
                    player.func_70606_j(player.func_110143_aJ() + healAmount);
                    break;
                }
                return EnumActionResult.PASS;
            }
            case SALVE_INVIS: {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)14), PlantMegaPack.settings.salveDurationInvisibility * 20, 1));
                break;
            }
            case SALVE_LEAPI: {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)8), PlantMegaPack.settings.salveDurationLeaping * 20, 1));
                break;
            }
            case SALVE_NTVIS: {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)16), PlantMegaPack.settings.salveDurationNightVision * 20, 1));
                break;
            }
            case SALVE_STREN: {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)5), PlantMegaPack.settings.salveDurationStrength * 20, 1));
                break;
            }
            case SALVE_SWIFT: {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)1), PlantMegaPack.settings.salveDurationSwiftness * 20, 1));
                break;
            }
            case SALVE_WATBR: {
                player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)13), PlantMegaPack.settings.salveDurationWaterBreathing * 20, 1));
                break;
            }
            default: {
                return EnumActionResult.PASS;
            }
        }
        ItemStack itemstack = player.func_184586_b(hand);
        itemstack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult plantTreeFruit(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, DefTree defTree) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.isWood((IBlockAccess)world, pos)) {
            return EnumActionResult.FAIL;
        }
        if (world.func_175623_d(pos = pos.func_177977_b())) {
            BlockTreeFruit treeFruitBlock = (BlockTreeFruit)PlantMegaPack.objects.getTreeFruit(defTree);
            IBlockState newState = treeFruitBlock.func_176223_P();
            world.func_180501_a(pos, newState, 2);
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack itemstack = player.func_184586_b(hand);
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        super.func_77654_b(stack, world, entityLiving);
        TypeFood typeFood = this.defFood.foodType;
        if (typeFood == TypeFood.BOTTL || typeFood == TypeFood.DRINK) {
            return new ItemStack(Items.field_151069_bo);
        }
        if (typeFood == TypeFood.BOWL) {
            return new ItemStack(Items.field_151054_z);
        }
        return stack;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess source, BlockPos pos) {
        DefPlant defPlant;
        switch (this.defFood) {
            case SEEDF_LENTI: {
                defPlant = DefPlant.CROPL_LENTI;
                break;
            }
            case SEEDF_PEANU: {
                defPlant = DefPlant.CROPL_PEANU;
                break;
            }
            case SEEDF_QUINO: {
                defPlant = DefPlant.CROPL_QUINO;
                break;
            }
            case SEEDF_RICE: {
                defPlant = DefPlant.CROPA_ASIAR;
                break;
            }
            case SEEDF_SOYBE: {
                defPlant = DefPlant.CROPL_SOYBE;
                break;
            }
            default: {
                return null;
            }
        }
        return PlantMegaPack.objects.getPlant(defPlant).func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        ItemTooltips.addOreDictName(tooltip, this.defFood.oreDictName);
        if (PlantMegaPack.settings.tooltipHints) {
            TypeFood typeFood = this.defFood.foodType;
            switch (typeFood) {
                case BERRY: {
                    ItemTooltips.addCraftingText(tooltip, "gui.fruit_bowl");
                    ItemTooltips.addCraftingText(tooltip, "gui.fruit_drink");
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_SANDP.getUnlocalizedName());
                    break;
                }
                case FRUIT: {
                    ItemTooltips.addCraftingText(tooltip, "gui.fruit_bowl");
                    ItemTooltips.addCraftingText(tooltip, "gui.fruit_drink");
                    break;
                }
                case VEGET: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_STIRF.getUnlocalizedName());
                    ItemTooltips.addCraftingText(tooltip, "gui.sandwiches");
                    ItemTooltips.addCraftingText(tooltip, "gui.tortilla");
                    ItemTooltips.addCraftingText(tooltip, "gui.wrap");
                    break;
                }
            }
            switch (this.defFood) {
                case VEGET_BELPO: 
                case VEGET_BELPR: 
                case VEGET_BELPY: {
                    ItemTooltips.addCraftingText(tooltip, "gui.stuffed_pepper");
                    break;
                }
                case VEGET_BROCC: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.SOUP_BROCC.getUnlocalizedName());
                    break;
                }
                case FOOD_RICEC: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_COTOR.getUnlocalizedName());
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_WRCOR.getUnlocalizedName());
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_WRSWR.getUnlocalizedName());
                    break;
                }
                case VEGET_CORN: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_CORFL.getUnlocalizedName());
                    break;
                }
                case FOOD_CORBR: {
                    ItemTooltips.addCraftingText(tooltip, "gui.sandwiches");
                    break;
                }
                case FOOD_CORFL: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_CORBR.getUnlocalizedName());
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_WRCRN.getUnlocalizedName());
                    ItemTooltips.addSmeltingText(tooltip, DefFood.FOOD_CORTO.getUnlocalizedName());
                    break;
                }
                case FOOD_CORTO: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_COTOF.getUnlocalizedName());
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_COTOM.getUnlocalizedName());
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_COTOR.getUnlocalizedName());
                    break;
                }
                case VEGET_HOPS: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.TEA_HOP.getUnlocalizedName());
                    break;
                }
                case ROOT_HORSE: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.SOUP_HORSE.getUnlocalizedName());
                    break;
                }
                case SEEDF_LENTI: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.SOUP_LENTI.getUnlocalizedName());
                    break;
                }
                case ROOT_LICOR: {
                    ItemTooltips.addCraftingText(tooltip, "gui.licorice_candy");
                    break;
                }
                case VEGET_MOZNO: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.SOUP_MOZUK.getUnlocalizedName());
                    break;
                }
                case SEEDF_PEANU: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_PBCOO.getUnlocalizedName());
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_SANDP.getUnlocalizedName());
                    break;
                }
                case SEEDF_QUINO: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.SOUP_QUINO.getUnlocalizedName());
                    break;
                }
                case SEEDF_RICE: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_RICEC.getUnlocalizedName());
                    ItemTooltips.addCraftingText(tooltip, "item.paper.name");
                    break;
                }
                case SEEDF_SOYBE: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.FOOD_TOFU.getUnlocalizedName());
                    break;
                }
                case VEGET_TOMAT: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.SOUP_TOMAT.getUnlocalizedName());
                    break;
                }
                case FOOD_WRCRN: {
                    ItemTooltips.addCraftingText(tooltip, "gui.wrap");
                    break;
                }
                case FOOD_WRSWD: {
                    ItemTooltips.addCraftingText(tooltip, "gui.wrap");
                    ItemTooltips.addCraftingText(tooltip, "gui.medicinal_salve");
                    break;
                }
            }
            switch (this.defFood) {
                case VEGET_HOPS: 
                case ROOT_LICOR: 
                case LEAFF_CENTE: 
                case VEGET_GARLI: 
                case ROOT_SACRL: 
                case STEM_WASAB: {
                    ItemTooltips.addCraftingText(tooltip, DefFood.SALVE_HEALT.getUnlocalizedName());
                    break;
                }
            }
        }
    }
}

