/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.data.DataBiome;
import pmp.core.def.DefHabitat;
import pmp.core.type.TypeBiome;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpButton;
import pmp.gui.control.GuiPmpButtonMode;
import pmp.gui.control.GuiPmpListbox;
import pmp.gui.control.GuiPmpListboxState;
import pmp.gui.control.IListboxOwner;
import pmp.gui.screen.GuiHabitatPlants;
import pmp.gui.screen.GuiHabitatSettings;
import pmp.gui.screen.GuiHabitatTrees;

public class GuiHabitatMain
extends GuiScreenBase
implements IListboxOwner {
    private final TypeBiome biome;
    private DefHabitat habitatSelected;
    private GuiPmpListbox habitatList;
    private static GuiPmpListboxState listboxState = new GuiPmpListboxState();
    private GuiPmpButton buttonSettings;
    private GuiPmpButton buttonPlants;
    private GuiPmpButton buttonTrees;

    public GuiHabitatMain(GuiScreen parentGuiScreen, TypeBiome biome) {
        super(parentGuiScreen, null, GuiButtonLayout.DONE);
        this.biome = biome;
        this.name = String.format("%s %s %s", I18n.func_135052_a((String)"gui.customize", (Object[])new Object[0]), this.biome.getLocalizedName(), I18n.func_135052_a((String)"gui.habitats", (Object[])new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getListboxStartX();
        int yPos = this.getButtonRowStartY(2);
        this.habitatList = new GuiPmpListbox(this, xPos, yPos, this.getListboxWidth(), this.getListboxHeight(), this.getFontRenderer().field_78288_b + 2);
        xPos = this.field_146294_l / 2 + 4;
        yPos = this.getButtonRowStartY(2);
        this.buttonSettings = new GuiPmpButton(this, 10, GuiPmpButtonMode.NORMAL, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]) + "...");
        yPos = this.getButtonRowStartY(3);
        this.buttonPlants = new GuiPmpButton(this, 11, GuiPmpButtonMode.NORMAL, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.plants", (Object[])new Object[0]) + "...");
        yPos = this.getButtonRowStartY(4);
        this.buttonTrees = new GuiPmpButton(this, 12, GuiPmpButtonMode.NORMAL, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.trees", (Object[])new Object[0]) + "...");
        this.populateHabitatList();
        this.habitatList.setListboxState(listboxState);
        this.listItemSelected(this.habitatList, GuiHabitatMain.listboxState.selectedElement);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.habitatList.func_178039_p();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    break;
                }
                case 2: {
                    listboxState.resetState();
                    PlantMegaPack.settings.saveBiomeSettings(this.biome);
                    break;
                }
                case 10: {
                    this.habitatList.saveListboxState(listboxState);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiHabitatSettings((GuiScreen)this, this.biome, this.habitatSelected));
                    return;
                }
                case 11: {
                    this.habitatList.saveListboxState(listboxState);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiHabitatPlants((GuiScreen)this, this.biome, this.habitatSelected));
                    return;
                }
                case 12: {
                    this.habitatList.saveListboxState(listboxState);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiHabitatTrees((GuiScreen)this, this.biome, this.habitatSelected));
                    return;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.habitatList.func_148128_a(mouseX, mouseY, partialTicks);
        int posX = this.getLeftColumnCenterX();
        int posY = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.habitats", (Object[])new Object[0]), posX, posY, 0x60E060);
        posX = this.getRightColumnCenterX();
        posY = this.getButtonRowStartY(1) + 10;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]), posX, posY, 0x60E060);
    }

    @Override
    public void listItemSelected(GuiPmpListbox list, int slotIndex) {
        this.habitatSelected = DefHabitat.getHabitatFromName(this.habitatList.getSelectedItemKey());
        this.habitatList.saveListboxState(listboxState);
        this.updateControls();
    }

    @Override
    public void listItemDoubleClicked(GuiPmpListbox list, int slotIndex) {
        this.func_146284_a(this.buttonPlants);
    }

    private void updateControls() {
        boolean canContainTrees;
        this.buttonTrees.field_146124_l = canContainTrees = this.habitatSelected.canHabitatContainTrees();
        this.buttonTrees.field_146125_m = canContainTrees;
    }

    private void populateHabitatList() {
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.biome);
        if (dataBiome != null) {
            dataBiome.habitats.forEach((k, v) -> this.habitatList.addListboxEntry(k.habitatName, k.getLocalizedNameFormatted()));
        }
    }
}

