/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.screen;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import pmp.PlantMegaPack;
import pmp.core.data.DataBiome;
import pmp.core.type.TypeBiome;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpButton;
import pmp.gui.control.GuiPmpButtonMode;
import pmp.gui.control.GuiPmpSlider;
import pmp.gui.control.GuiPmpSliderMode;

public class GuiBiomeSettings
extends GuiScreenBase {
    private final TypeBiome typeBiome;
    private GuiPmpSlider worldgenRatePlants;
    private GuiPmpButton plantCanReplacePlants;
    private GuiPmpButton plantCanReplaceSnow;
    private GuiPmpSlider worldgenRateTrees;
    private GuiPmpButton treeCanReplacePlants;
    private GuiPmpButton treeCanReplaceSnow;

    public GuiBiomeSettings(GuiScreen parentGuiScreen, TypeBiome biome) {
        super(parentGuiScreen, null, GuiButtonLayout.DEFAULTS_DONE);
        this.typeBiome = biome;
        this.name = String.format("%s %s %s", I18n.func_135052_a((String)"gui.customize", (Object[])new Object[0]), this.typeBiome.getLocalizedName(), I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = this.getLeftColumnStartX();
        int yPos = this.getButtonRowStartY(2);
        this.worldgenRatePlants = new GuiPmpSlider(this, 10, xPos, yPos, 150, 20, String.format("%s %s", I18n.func_135052_a((String)"gui.gen_rate", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.plants", (Object[])new Object[0])), 0, 50, 100, 1);
        this.worldgenRatePlants.setSliderMode(GuiPmpSliderMode.PERCENT);
        yPos = this.getButtonRowStartY(3);
        this.plantCanReplacePlants = new GuiPmpButton(this, 11, GuiPmpButtonMode.TOGGLE, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.can_replace_plants", (Object[])new Object[0]));
        yPos = this.getButtonRowStartY(4);
        this.plantCanReplaceSnow = new GuiPmpButton(this, 12, GuiPmpButtonMode.TOGGLE, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.can_replace_snow", (Object[])new Object[0]));
        xPos = this.getRightColumnStartX();
        yPos = this.getButtonRowStartY(2);
        this.worldgenRateTrees = new GuiPmpSlider(this, 20, xPos, yPos, 150, 20, String.format("%s %s", I18n.func_135052_a((String)"gui.gen_rate", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.trees", (Object[])new Object[0])), 0, 50, 100, 1);
        this.worldgenRateTrees.setSliderMode(GuiPmpSliderMode.PERCENT);
        yPos = this.getButtonRowStartY(3);
        this.treeCanReplacePlants = new GuiPmpButton(this, 21, GuiPmpButtonMode.TOGGLE, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.can_replace_plants", (Object[])new Object[0]));
        yPos = this.getButtonRowStartY(4);
        this.treeCanReplaceSnow = new GuiPmpButton(this, 22, GuiPmpButtonMode.TOGGLE, xPos, yPos, 150, 20, I18n.func_135052_a((String)"gui.can_replace_snow", (Object[])new Object[0]));
        this.updateButtonStatesFromSettings();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.typeBiome);
                    if (dataBiome == null) break;
                    dataBiome.applyDefaultBiomeSettings(true);
                    this.updateButtonStatesFromSettings();
                    break;
                }
                case 2: {
                    this.updateSettingsFromButtonStates();
                    PlantMegaPack.settings.saveBiomeSettings(this.typeBiome);
                    break;
                }
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int posX = this.getLeftColumnCenterX();
        int posY = this.getButtonRowStartY(1) + 10;
        posX = this.getLeftColumnCenterX();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.plants", (Object[])new Object[0]), posX, posY, 0x60E060);
        posX = this.getRightColumnCenterX();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.trees", (Object[])new Object[0]), posX, posY, 0x60E060);
    }

    private void updateButtonStatesFromSettings() {
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.typeBiome);
        if (dataBiome != null) {
            this.worldgenRatePlants.setIntValue(dataBiome.worldgenRatePlants);
            this.worldgenRatePlants.updateDisplayString();
            this.plantCanReplacePlants.setButtonState(dataBiome.plantCanReplacePlants);
            this.plantCanReplaceSnow.setButtonState(dataBiome.plantCanReplaceSnow);
            this.worldgenRateTrees.setIntValue(dataBiome.worldgenRateTrees);
            this.worldgenRateTrees.updateDisplayString();
            this.treeCanReplacePlants.setButtonState(dataBiome.treeCanReplacePlants);
            this.treeCanReplaceSnow.setButtonState(dataBiome.treeCanReplaceSnow);
        }
    }

    private void updateSettingsFromButtonStates() {
        DataBiome dataBiome = PlantMegaPack.settings.biomeSettings.get((Object)this.typeBiome);
        if (dataBiome != null) {
            dataBiome.worldgenRatePlants = this.worldgenRatePlants.getIntValue();
            dataBiome.plantCanReplacePlants = this.plantCanReplacePlants.getButtonState();
            dataBiome.plantCanReplaceSnow = this.plantCanReplaceSnow.getButtonState();
            dataBiome.worldgenRateTrees = this.worldgenRateTrees.getIntValue();
            dataBiome.treeCanReplacePlants = this.treeCanReplacePlants.getButtonState();
            dataBiome.treeCanReplaceSnow = this.treeCanReplaceSnow.getButtonState();
        }
    }
}

