/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui.control;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import pmp.gui.GuiCore;
import pmp.gui.GuiScreenBase;
import pmp.gui.control.GuiPmpButtonMode;

@SideOnly(value=Side.CLIENT)
public class GuiPmpButton
extends GuiButton {
    private GuiPmpButtonMode buttonMode;
    private boolean buttonState;
    private boolean selected;
    private boolean displayOnOff;

    public GuiPmpButton(GuiScreenBase parent, int id, GuiPmpButtonMode mode, int xPosition, int yPosition, int width, int height, String label) {
        super(id, xPosition, yPosition, label);
        parent.registerButton(this);
        this.buttonMode = mode;
        this.buttonState = false;
        this.selected = false;
        this.displayOnOff = true;
        this.field_146120_f = width;
        this.field_146121_g = height;
    }

    public void setDisplayOnOff(boolean state) {
        this.displayOnOff = state;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            int buttonStartXPos = this.field_146128_h;
            int buttonWidth = this.field_146120_f;
            if (this.buttonMode == GuiPmpButtonMode.TOGGLE) {
                GuiCore.drawLED(this.field_146128_h, this.field_146129_i, this.field_146124_l, this.buttonState);
                buttonStartXPos += 6;
                buttonWidth -= 6;
            }
            FontRenderer fontrenderer = mc.field_71466_p;
            mc.func_110434_K().func_110577_a(GuiButton.field_146122_a);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= buttonStartXPos && mouseY >= this.field_146129_i && mouseX < buttonStartXPos + buttonWidth && mouseY < this.field_146129_i + this.field_146121_g;
            int k = this.func_146114_a(this.field_146123_n);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.field_146124_l) {
                if (this.selected) {
                    k = 1;
                    GL11.glColor4f((float)0.5f, (float)1.0f, (float)0.5f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            } else {
                GL11.glColor4f((float)0.5f, (float)0.55f, (float)0.5f, (float)1.0f);
            }
            this.func_73729_b(buttonStartXPos, this.field_146129_i, 0, 46 + k * 20, buttonWidth / 2, this.field_146121_g);
            this.func_73729_b(buttonStartXPos + buttonWidth / 2, this.field_146129_i, 200 - buttonWidth / 2, 46 + k * 20, buttonWidth / 2, this.field_146121_g);
            this.func_146119_b(mc, mouseX, mouseY);
            int textColor = 0x60E060;
            if (this.selected) {
                textColor = 0xA0FFA0;
            } else if (!this.field_146124_l) {
                textColor = 0x208020;
            } else if (this.field_146123_n) {
                textColor = 0xFFFF80;
            }
            this.func_73732_a(fontrenderer, this.getDisplayString(), buttonStartXPos + buttonWidth / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, textColor);
        }
    }

    public boolean func_146116_c(Minecraft mc, int xPos, int yPos) {
        if (!this.selected && super.func_146116_c(mc, xPos, yPos)) {
            if (this.buttonMode != GuiPmpButtonMode.NORMAL) {
                if (xPos < this.field_146128_h + 6) {
                    return false;
                }
                this.buttonState = !this.buttonState;
            }
            return true;
        }
        return false;
    }

    private String getDisplayString() {
        if (this.displayOnOff && this.buttonMode != GuiPmpButtonMode.NORMAL) {
            return this.field_146126_j + ": " + (this.buttonState ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]));
        }
        return this.field_146126_j;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setButtonMode(GuiPmpButtonMode mode) {
        this.buttonMode = mode;
    }

    public boolean getButtonState() {
        return this.buttonState;
    }

    public void setButtonState(boolean state) {
        this.buttonState = state;
    }
}

