/*
 * Decompiled with CFR 0.152.
 */
package pmp.gui;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.gui.GuiButtonLayout;
import pmp.gui.GuiCore;
import pmp.gui.control.GuiPmpButton;
import pmp.gui.control.GuiPmpButtonMode;
import pmp.gui.control.GuiPmpListbox;
import pmp.gui.control.GuiPmpSlider;

@SideOnly(value=Side.CLIENT)
public abstract class GuiScreenBase
extends GuiScreen {
    protected GuiPmpButton buttonDefault;
    protected GuiPmpButton buttonDone;
    protected String name;
    protected GuiScreen parentGuiScreen;
    private GuiButtonLayout buttonLayout;

    public GuiScreenBase(GuiScreen parentGuiScreen, String resourceName, GuiButtonLayout buttonLayout) {
        this.parentGuiScreen = parentGuiScreen;
        if (resourceName != null && !resourceName.isEmpty()) {
            this.name = I18n.func_135052_a((String)resourceName, (Object[])new Object[0]);
        }
        this.buttonLayout = buttonLayout;
    }

    public void func_73866_w_() {
        int yPos = this.field_146295_m - 27;
        if (this.buttonLayout == GuiButtonLayout.DONE) {
            int xPos = this.field_146294_l / 2 - 90;
            this.buttonDone = new GuiPmpButton(this, 2, GuiPmpButtonMode.NORMAL, xPos, this.field_146295_m - 27, 180, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        } else if (this.buttonLayout == GuiButtonLayout.DEFAULTS_DONE) {
            int xPos = this.field_146294_l / 2 - 113;
            this.buttonDefault = new GuiPmpButton(this, 1, GuiPmpButtonMode.NORMAL, xPos, yPos, 73, 20, I18n.func_135052_a((String)"gui.defaults", (Object[])new Object[0]));
            this.buttonDone = new GuiPmpButton(this, 2, GuiPmpButtonMode.NORMAL, xPos += 77, yPos, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        } else if (this.buttonLayout == GuiButtonLayout.CANCEL_DONE) {
            int xPos = this.field_146294_l / 2 - 113;
            this.buttonDefault = new GuiPmpButton(this, 1, GuiPmpButtonMode.NORMAL, xPos, yPos, 73, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
            this.buttonDone = new GuiPmpButton(this, 2, GuiPmpButtonMode.NORMAL, xPos += 77, yPos, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawLogoImage();
        this.drawTitleText();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    if (this.buttonLayout == GuiButtonLayout.CANCEL_DONE) {
                        this.field_146297_k.func_147108_a(this.parentGuiScreen);
                        return;
                    }
                    return;
                }
                case 2: {
                    this.field_146297_k.func_147108_a(this.parentGuiScreen);
                    return;
                }
            }
        }
    }

    public int getHeight() {
        return this.field_146295_m;
    }

    protected void drawLogoImage() {
        if (GuiCore.MOD_LOGO != null) {
            int x = (this.field_146294_l - 128) / 2;
            int y = 3;
            GuiCore.drawTexture(GuiCore.MOD_LOGO, x, y, 128, 16);
        }
    }

    protected void drawTitleText() {
        this.func_73732_a(this.field_146289_q, this.name, this.field_146294_l / 2, 20, 0xA0FFA0);
    }

    protected FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void listItemDoubleClicked(GuiPmpListbox list, int index) {
    }

    public void listItemSelected(GuiPmpListbox list, int index) {
    }

    public void onSliderUpdate(GuiPmpSlider slider, int value) {
    }

    public int getButtonRowStartY(int row) {
        if (row < 1 || row > 7) {
            return 36;
        }
        int actualRow = row - 1;
        return 36 + actualRow * 24;
    }

    public int getCenteredButtonStartX(int buttonWidth) {
        if (buttonWidth < 73 || buttonWidth > 180) {
            return 0;
        }
        return this.field_146294_l / 2 - buttonWidth / 2;
    }

    public int getListboxStartX() {
        return this.field_146294_l / 2 - (this.getListboxWidth() + 4);
    }

    public int getListboxHeight() {
        return 116;
    }

    public int getListboxWidth() {
        return 150;
    }

    public int getLeftColumnStartX() {
        return this.field_146294_l / 2 - 154;
    }

    public int getLeftColumnCenterX() {
        return this.field_146294_l / 2 - 79;
    }

    public int getRightColumnStartX() {
        return this.field_146294_l / 2 + 4;
    }

    public int getRightColumnCenterX() {
        return this.field_146294_l / 2 + 79;
    }

    public int getTriColumnStartLeftX(int buttonWidth) {
        return this.field_146294_l / 2 - (buttonWidth / 2 + 4 + buttonWidth);
    }

    public int getTriColumnStartCenterX(int buttonWidth) {
        return this.field_146294_l / 2 - buttonWidth / 2;
    }

    public int getTriColumnStartRightX(int buttonWidth) {
        return this.field_146294_l / 2 + (buttonWidth / 2 + 4);
    }

    public void registerButton(GuiButton button) {
        this.field_146292_n.add(button);
    }
}

